/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.watcher.list;

import de.bixilon.kutil.watcher.list.ListChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0016\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0016\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0012H\u0016J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0096\u0002J\u0015\u0010&\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0016\u0010)\u001a\u00020\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0002J\u0015\u0010+\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010,\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0015\u0010-\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010 J\u0016\u0010.\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u001e\u0010/\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00100J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f*\u0004\b\t\u0010\nR&\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lde/bixilon/kutil/watcher/list/ObservedList;", "V", "", "original", "(Ljava/util/List;)V", "emptyList", "", "size", "", "getSize$delegate", "(Lde/bixilon/kutil/watcher/list/ObservedList;)Ljava/lang/Object;", "getSize", "()I", "watchers", "Lkotlin/Function1;", "Lde/bixilon/kutil/watcher/list/ListChange;", "", "add", "", "element", "(Ljava/lang/Object;)Z", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "addWatcher", "watcher", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "notifyWatchers", "change", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "kutil"})
public final class ObservedList<V>
implements List<V>,
KMutableList {
    @NotNull
    private final List<V> original;
    @NotNull
    private final List<Function1<ListChange<V>, Unit>> watchers;
    @NotNull
    private final List<V> emptyList;

    public ObservedList(@NotNull List<V> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        this.original = original;
        this.watchers = new ArrayList();
        this.emptyList = CollectionsKt.emptyList();
    }

    public int getSize() {
        return this.original.size();
    }

    public static Object getSize$delegate(ObservedList<Object> observedList) {
        Intrinsics.checkNotNullParameter(observedList, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(observedList.original, List.class, "size", "size()I", 0)));
    }

    public final void addWatcher(@NotNull Function1<? super ListChange<V>, Unit> watcher) {
        Intrinsics.checkNotNullParameter(watcher, (String)"watcher");
        ((Collection)this.watchers).add(watcher);
    }

    private final void notifyWatchers(ListChange<V> change) {
        for (Function1<ListChange<V>, Unit> watcher : this.watchers) {
            watcher.invoke(change);
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.original.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.original.containsAll(elements);
    }

    @Override
    public V get(int index) {
        return this.original.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.original.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.original.iterator();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.original.lastIndexOf(element);
    }

    @Override
    public boolean add(V element) {
        this.notifyWatchers(new ListChange(CollectionsKt.listOf(element), (Collection)this.emptyList));
        return this.original.add(element);
    }

    @Override
    public void add(int index, V element) {
        this.notifyWatchers(new ListChange(CollectionsKt.listOf(element), (Collection)this.emptyList));
        this.original.add(index, element);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.notifyWatchers(new ListChange<V>(elements, (Collection)this.emptyList));
        return this.original.addAll(index, elements);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.notifyWatchers(new ListChange<V>(elements, (Collection)this.emptyList));
        return this.original.addAll(elements);
    }

    @Override
    public void clear() {
        this.notifyWatchers(new ListChange((Collection)this.emptyList, CollectionsKt.toList((Iterable)this.original)));
        this.original.clear();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator() {
        return this.original.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator(int index) {
        return this.original.listIterator(index);
    }

    @Override
    public boolean remove(Object element) {
        if (!this.original.remove(element)) {
            return false;
        }
        this.notifyWatchers(new ListChange((Collection)this.emptyList, CollectionsKt.listOf((Object)element)));
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List contained = new ArrayList();
        for (Object object : elements) {
            if (!this.original.contains(object)) continue;
            ((Collection)contained).add(object);
        }
        if (!this.original.removeAll(elements)) {
            return false;
        }
        if (!((Collection)contained).isEmpty()) {
            this.notifyWatchers(new ListChange((Collection)this.emptyList, contained));
        }
        return true;
    }

    public V removeAt(int index) {
        V removed = this.original.remove(index);
        this.notifyWatchers(new ListChange((Collection)this.emptyList, CollectionsKt.listOf(removed)));
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = this.original.retainAll(elements);
        this.notifyWatchers(new ListChange<Object>((Collection)this.emptyList, elements));
        return removed;
    }

    @Override
    public V set(int index, V element) {
        V previous = this.original.set(index, element);
        this.notifyWatchers(new ListChange(CollectionsKt.listOf(element), CollectionsKt.listOf(element)));
        return previous;
    }

    @Override
    @NotNull
    public List<V> subList(int fromIndex, int toIndex) {
        return this.original.subList(fromIndex, toIndex);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

