/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.rate;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.time.TimeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0018\u0010#\u001a\u00020\u001d2\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001eJ\u001a\u0010%\u001a\u00020\u001d2\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001eH\u0002J\u0018\u0010&\u001a\u00020\u00072\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001eJ\u001b\u0010'\u001a\u00020\u001d2\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001eH\u0086\u0002J\u0006\u0010(\u001a\u00020\u001dR\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cj\u0004\u0018\u0001`\u001e2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cj\u0004\u0018\u0001`\u001e8B@BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\r\u00a8\u0006)"}, d2={"Lde/bixilon/kutil/rate/RateLimiter;", "", "limit", "", "inTime", "", "allowForcePerform", "", "dependencies", "", "(IJZLjava/util/Set;)V", "_canWork", "get_canWork", "()Z", "getAllowForcePerform", "canWork", "getCanWork", "getDependencies", "()Ljava/util/Set;", "executions", "", "getInTime", "()J", "getLimit", "()I", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "<set-?>", "Lkotlin/Function0;", "", "Lde/bixilon/kutil/rate/RateAction;", "toDo", "upToDate", "getUpToDate", "cleanup", "forcePerform", "action", "internalPerform", "perform", "plusAssign", "work", "kutil"})
public final class RateLimiter {
    private final int limit;
    private final long inTime;
    private final boolean allowForcePerform;
    @NotNull
    private final Set<RateLimiter> dependencies;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private Function0<Unit> toDo;
    @NotNull
    private List<Long> executions;

    public RateLimiter(int limit, long inTime, boolean allowForcePerform, @NotNull Set<RateLimiter> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        this.limit = limit;
        this.inTime = inTime;
        this.allowForcePerform = allowForcePerform;
        this.dependencies = dependencies;
        this.lock = new ReentrantLock();
        this.executions = CollectionUtil.INSTANCE.synchronizedListOf(new Long[0]);
    }

    public /* synthetic */ RateLimiter(int n, long l, boolean bl, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 20;
        }
        if ((n2 & 2) != 0) {
            l = 1000L;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            set = CollectionUtil.INSTANCE.synchronizedSetOf(new RateLimiter[0]);
        }
        this(n, l, bl, set);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final long getInTime() {
        return this.inTime;
    }

    public final boolean getAllowForcePerform() {
        return this.allowForcePerform;
    }

    @NotNull
    public final Set<RateLimiter> getDependencies() {
        return this.dependencies;
    }

    public final boolean getUpToDate() {
        this.lock.lock();
        boolean upToDate = this.toDo == null;
        this.lock.unlock();
        return upToDate;
    }

    public final boolean getCanWork() {
        this.cleanup(true);
        return this.executions.size() < this.limit;
    }

    private final boolean get_canWork() {
        this.cleanup(false);
        return this.executions.size() < this.limit;
    }

    public final boolean perform(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.lock.lock();
        if (!this.get_canWork()) {
            this.toDo = action;
            return false;
        }
        this.internalPerform(action);
        this.lock.unlock();
        return true;
    }

    public final void plusAssign(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.perform(action);
    }

    private final void internalPerform(Function0<Unit> action) {
        for (RateLimiter dependency : this.dependencies) {
            if (!dependency.getUpToDate()) {
                dependency.work();
            }
            if (dependency.getUpToDate()) continue;
            boolean bl = false;
            String string = "RateLimiter dependency is not upToDate!";
            throw new IllegalStateException(string.toString());
        }
        this.toDo = null;
        action.invoke();
        long time = TimeUtil.INSTANCE.getTime();
        Long l = time;
        ((Collection)this.executions).add(l);
    }

    public final void forcePerform(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!this.allowForcePerform) {
            boolean bl = false;
            String string = "RateLimiter does not allow force performing!";
            throw new IllegalStateException(string.toString());
        }
        this.lock.lock();
        this.internalPerform(action);
        this.lock.unlock();
    }

    public final void work() {
        this.lock.lock();
        this.cleanup(false);
        if (!this.get_canWork()) {
            return;
        }
        Function0<Unit> function0 = this.toDo;
        if (function0 != null) {
            Function0<Unit> it = function0;
            boolean bl = false;
            this.internalPerform(it);
        }
        this.lock.unlock();
    }

    private final void cleanup(boolean lock) {
        long execution;
        long addDelta;
        if (lock) {
            this.lock.lock();
        }
        List executions = CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.executions);
        long time = TimeUtil.INSTANCE.getTime();
        Iterator iterator = executions.iterator();
        while (iterator.hasNext() && (addDelta = time - (execution = ((Number)iterator.next()).longValue())) - this.inTime >= 0L) {
            CollectionsKt.removeFirst(this.executions);
        }
        if (lock) {
            this.lock.unlock();
        }
    }

    public RateLimiter() {
        this(0, 0L, false, null, 15, null);
    }
}

