/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.queue;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.time.TimeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0011\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lde/bixilon/kutil/concurrent/queue/Queue;", "", "()V", "queue", "", "Ljava/lang/Runnable;", "size", "", "getSize", "()I", "add", "", "runnable", "clear", "", "plusAssign", "timeWork", "time", "", "work", "maxJobs", "kutil"})
public final class Queue {
    @NotNull
    private final List<Runnable> queue = CollectionUtil.INSTANCE.synchronizedListOf(new Runnable[0]);

    public final int getSize() {
        return this.queue.size();
    }

    public final boolean add(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        ((Collection)this.queue).add(runnable);
        return true;
    }

    public final void plusAssign(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.add(runnable);
    }

    public final void work(int maxJobs) {
        int jobsDone = 0;
        for (Runnable runnable : CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.queue)) {
            this.queue.remove(runnable);
            if (jobsDone == maxJobs) break;
            runnable.run();
            ++jobsDone;
        }
    }

    public static /* synthetic */ void work$default(Queue queue, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        queue.work(n);
    }

    public final void timeWork(long time) {
        if (!(time > 0L)) {
            boolean bl = false;
            String string = "Can not have <= 0 time to do jobs!";
            throw new IllegalStateException(string.toString());
        }
        long start = TimeUtil.INSTANCE.getTime();
        for (Runnable runnable : CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.queue)) {
            this.queue.remove(runnable);
            if (TimeUtil.INSTANCE.getTime() - start >= time) break;
            runnable.run();
        }
    }

    public final void clear() {
        this.queue.clear();
    }
}

