package de.bixilon.kutil.time

import java.util.*

object DateUtil {
    val currentCalendar: Calendar
        get() {
            val calendar = Calendar.getInstance()
            calendar.timeInMillis = TimeUtil.millis
            return calendar
        }

    val christmas: Boolean
        get() {
            val calendar = currentCalendar
            if (calendar.get(Calendar.MONTH) != Calendar.DECEMBER) {
                return false
            }
            val day = calendar.get(Calendar.DAY_OF_MONTH)
            return day in 24..26
        }

    val newYear: Boolean
        get() {
            val calendar = currentCalendar
            val month = calendar.get(Calendar.MONTH)
            val day = calendar.get(Calendar.DAY_OF_MONTH)

            return (month == Calendar.DECEMBER && day == 31) || (month == Calendar.JANUARY && day == 1)
        }
}
