/*
 * KUtil
 * Copyright (C) 2021 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.concurrent.lock.simple

import de.bixilon.kutil.concurrent.lock.Lock

class SimpleLock : Lock {
    private val lock = Object()
    override var readers = 0
        private set
    override var writing = false
        private set

    override fun acquire() {
        synchronized(lock) {
            while (writing) {
                lock.wait()
            }
            readers++
            lock.notifyAll()
        }
    }

    override fun release() {
        synchronized(lock) {
            check(readers > 0) { "Nobody is reading?" }
            readers--
            lock.notifyAll()
        }
    }

    override fun lock() {
        synchronized(lock) {
            while (writing || readers > 0) {
                lock.wait()
            }
            writing = true
            lock.notifyAll()
        }
    }

    override fun unlock() {
        synchronized(lock) {
            check(writing) { "Nobody is writing?" }
            writing = false
            lock.notifyAll()
        }
    }
}
