/*
 * KUtil
 * Copyright (C) 2021 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.uuid

import java.util.*

object UUIDUtil {
    private val UUID_FIX_PATTERN = "(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})".toRegex() // thanks https://www.spigotmc.org/threads/free-code-easily-convert-between-trimmed-and-full-uuids.165615

    fun String.toUUID(): UUID {
        var uuid = this
        uuid = uuid.trim { it <= ' ' }
        if (uuid.length == 36) {
            return UUID.fromString(uuid)
        }
        if (uuid.length in 32..36) {
            return UUID.fromString(uuid.replace("-", "").replace(UUID_FIX_PATTERN, "$1-$2-$3-$4-$5"))
        }
        throw IllegalArgumentException("Invalid uuid string $uuid")
    }

    fun UUID.trim(): String {
        return this.toString().replace("-", "")
    }
}
