/*
 * KUtil
 * Copyright (C) 2021 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.string

import java.nio.charset.StandardCharsets

object StringUtil {
    val DEFAULT_CHARSET = StandardCharsets.UTF_8
    private val SNAKE_CASE_REGEX = "(.)(\\p{Upper})".toRegex()

    fun String.toSnakeCase(): String {
        return replace(SNAKE_CASE_REGEX, "$1_$2").lowercase()
    }

    fun String.isLowercase(): Boolean {
        return this.lowercase() == this
    }

    fun String.isUppercase(): Boolean {
        return this.uppercase() == this
    }

    fun String.formatPlaceholder(format: Map<String, Any?>): String {
        var output = this
        for ((key, value) in format) {
            output = output.replace("\${$key}", value.toString())
        }
        return output
    }

    fun String.formatPlaceholder(vararg format: Pair<String, Any?>): String {
        var output = this
        for ((key, value) in format) {
            output = output.replace("\${$key}", value.toString())
        }
        return output
    }


    fun String.getBetween(first: String, second: String): String {
        val result: String = this.substring(this.indexOf(first) + first.length)
        return result.substring(0, result.indexOf(second))
    }
}
