/*
 * KUtil
 * Copyright (C) 2021 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.stream

import de.bixilon.kutil.buffer.BufferDefinition
import de.bixilon.kutil.string.StringUtil
import java.io.InputStream
import java.io.OutputStream
import java.nio.charset.Charset

object InputStreamUtil {

    fun InputStream.readAsString(charset: Charset = StringUtil.DEFAULT_CHARSET): String {
        return String(readAllBytes(), charset)
    }

    fun InputStream.copy(output: OutputStream): Long {
        val buffer = ByteArray(BufferDefinition.DEFAULT_BUFFER_SIZE)
        var length: Int
        var size = 0L
        while (true) {
            length = this.read(buffer, 0, buffer.size)
            if (length < 0) {
                break
            }
            size += length
            output.write(buffer, 0, length)
        }
        return size
    }
}
