/*
 * KUtil
 * Copyright (C) 2021 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.concurrent.lock.thread

import de.bixilon.kutil.concurrent.lock.Lock

class ThreadLock : Lock {
    private val lock = Object()
    override var readers: Int = 0
        private set
    private var writer: Thread? = null
    override val writing: Boolean get() = writer != null

    override fun acquire() {
        val thread = Thread.currentThread()
        synchronized(lock) {
            while (writing && writer !== thread) {
                lock.wait()
            }
            readers++
            lock.notifyAll()
        }
    }

    override fun release() {
        synchronized(lock) {
            check(readers > 0) { "Nobody is reading?" }
            readers--
            lock.notifyAll()
        }
    }

    override fun lock() {
        val thread = Thread.currentThread()
        synchronized(lock) {
            while ((writing && thread !== writer) || readers > 0) {
                lock.wait()
            }
            writer = thread
            lock.notifyAll()
        }
    }

    override fun unlock() {
        val thread = Thread.currentThread()
        synchronized(lock) {
            check(writer === thread) { "Current thread does not hold lock!" }
            writer = thread
            lock.notifyAll()
        }
    }
}
