package de.bixilon.kutil.concurrent.lock.simple

import de.bixilon.kutil.concurrent.lock.Lock

class ParentLock(
    private var parents: MutableList<Lock> = mutableListOf(),
) : Lock {
    private val lock = SimpleLock()

    fun add(parent: Lock) {
        lock.lock()
        parents += parent
        lock.unlock()
    }

    operator fun plusAssign(parent: Lock) = add(parent)

    fun remove(parent: Lock) {
        lock.lock()
        parents -= parent
        lock.unlock()
    }

    operator fun minusAssign(parent: Lock) = remove(parent)


    override val readers: Int
        get() = lock.readers
    override val writing: Boolean
        get() = lock.writing


    override fun acquire() {
        lock.acquire()
        for (parent in parents) {
            parent.acquire()
        }
    }

    override fun release() {
        lock.release()
        for (parent in parents) {
            parent.release()
        }
    }


    override fun lock() {
        lock.lock()
        for (parent in parents) {
            parent.lock()
        }
    }

    override fun unlock() {
        lock.unlock()
        for (parent in parents) {
            parent.unlock()
        }
    }
}
