/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kotlinglm.quaternion;

import de.bixilon.kotlinglm.GLM;
import de.bixilon.kotlinglm.ext.ext_QuaternionGeometric;
import de.bixilon.kotlinglm.mat3x3.Mat3;
import de.bixilon.kotlinglm.mat4x4.Mat4;
import de.bixilon.kotlinglm.quaternion.Quat;
import de.bixilon.kotlinglm.vec3.Vec3;
import de.bixilon.kotlinglm.vec4.Vec4;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0016J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0004\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0015H\u0016J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0016J0\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020#H\u0016\u00a8\u0006%"}, d2={"Lde/bixilon/kotlinglm/quaternion/gtx_quat;", "", "cross", "Lde/bixilon/kotlinglm/vec3/Vec3;", "res", "q", "Lde/bixilon/kotlinglm/quaternion/Quat;", "v", "extractRealComponent", "", "fastMix", "x", "y", "a", "intermediate", "prev", "curr", "next", "length2", "quatIdentity", "rotate", "Lde/bixilon/kotlinglm/vec4/Vec4;", "rotation", "orig", "dest", "shortMix", "squad", "q1", "q2", "s1", "s2", "h", "toMat3", "Lde/bixilon/kotlinglm/mat3x3/Mat3;", "toMat4", "Lde/bixilon/kotlinglm/mat4x4/Mat4;", "toQuat", "glm"})
public interface gtx_quat {
    @NotNull
    public Quat quatIdentity(@NotNull Quat var1);

    @NotNull
    public Vec3 cross(@NotNull Vec3 var1, @NotNull Quat var2, @NotNull Vec3 var3);

    @NotNull
    public Vec3 cross(@NotNull Vec3 var1, @NotNull Vec3 var2, @NotNull Quat var3);

    @NotNull
    public Quat squad(@NotNull Quat var1, @NotNull Quat var2, @NotNull Quat var3, @NotNull Quat var4, float var5);

    @NotNull
    public Quat intermediate(@NotNull Quat var1, @NotNull Quat var2, @NotNull Quat var3);

    @NotNull
    public Vec3 rotate(@NotNull Quat var1, @NotNull Vec3 var2);

    @NotNull
    public Quat rotate(@NotNull Quat var1, @NotNull Vec4 var2);

    public float extractRealComponent(@NotNull Quat var1);

    @NotNull
    public Mat3 toMat3(@NotNull Quat var1);

    @NotNull
    public Mat4 toMat4(@NotNull Quat var1);

    @NotNull
    public Quat toQuat(@NotNull Mat3 var1);

    @NotNull
    public Quat toQuat(@NotNull Mat4 var1);

    @NotNull
    public Quat shortMix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public Quat fastMix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public Quat rotation(@NotNull Vec3 var1, @NotNull Vec3 var2);

    public float length2(@NotNull Quat var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=82)
    @SourceDebugExtension(value={"SMAP\ngtx_quat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 gtx_quat.kt\nde/bixilon/kotlinglm/quaternion/gtx_quat$DefaultImpls\n+ 2 Vec3.kt\nde/bixilon/kotlinglm/vec3/Vec3\n*L\n1#1,202:1\n36#2:203\n33#2:204\n30#2,7:205\n33#2:212\n30#2:213\n30#2:214\n33#2:215\n36#2:216\n36#2:217\n33#2:218\n30#2,7:219\n33#2:226\n30#2:227\n30#2:228\n33#2:229\n36#2:230\n30#2:231\n33#2:232\n36#2:233\n*S KotlinDebug\n*F\n+ 1 gtx_quat.kt\nde/bixilon/kotlinglm/quaternion/gtx_quat$DefaultImpls\n*L\n49#1:203\n49#1:204\n50#1:205,7\n51#1:212\n51#1:213\n55#1:214\n56#1:215\n57#1:216\n65#1:217\n65#1:218\n66#1:219,7\n67#1:226\n67#1:227\n71#1:228\n72#1:229\n73#1:230\n191#1:231\n192#1:232\n193#1:233\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Quat quatIdentity(@NotNull gtx_quat $this, @NotNull Quat res) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            return res.put(1.0f, 0.0f, 0.0f, 0.0f);
        }

        public static /* synthetic */ Quat quatIdentity$default(gtx_quat gtx_quat2, Quat quat, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quatIdentity");
            }
            if ((n & 1) != 0) {
                quat = new Quat();
            }
            return gtx_quat2.quatIdentity(quat);
        }

        @NotNull
        public static Vec3 cross(@NotNull gtx_quat $this, @NotNull Vec3 res, @NotNull Quat q, @NotNull Vec3 v) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            float dot = GLM.INSTANCE.dot(q, q);
            float w = q.w.floatValue() / dot;
            float x = -q.x.floatValue() / dot;
            float y = -q.y.floatValue() / dot;
            float z = -q.z.floatValue() / dot;
            Vec3 this_$iv = v;
            boolean $i$f$getZ = false;
            this_$iv = v;
            boolean $i$f$getY = false;
            float uvX = y * this_$iv.array[this_$iv.ofs + 2] - this_$iv.array[this_$iv.ofs + 1] * z;
            Vec3 this_$iv2 = v;
            boolean $i$f$getX = false;
            this_$iv2 = v;
            boolean $i$f$getZ2 = false;
            float uvY = z * this_$iv2.array[this_$iv2.ofs] - this_$iv2.array[this_$iv2.ofs + 2] * x;
            Vec3 this_$iv3 = v;
            boolean $i$f$getY2 = false;
            this_$iv3 = v;
            boolean $i$f$getX2 = false;
            float uvZ = x * this_$iv3.array[this_$iv3.ofs + 1] - this_$iv3.array[this_$iv3.ofs] * y;
            float uuvX = y * uvZ - uvY * z;
            float uuvY = z * uvX - uvZ * x;
            float uuvZ = x * uvY - uvX * y;
            Vec3 this_$iv4 = v;
            boolean $i$f$getX3 = false;
            float resX = this_$iv4.array[this_$iv4.ofs] + (uvX * w + uuvX) * 2.0f;
            Vec3 this_$iv5 = v;
            boolean $i$f$getY3 = false;
            float resY = this_$iv5.array[this_$iv5.ofs + 1] + (uvY * w + uuvY) * 2.0f;
            Vec3 this_$iv6 = v;
            boolean $i$f$getZ3 = false;
            float resZ = this_$iv6.array[this_$iv6.ofs + 2] + (uvZ * w + uuvZ) * 2.0f;
            return res.invoke(resX, resY, resZ);
        }

        @NotNull
        public static Vec3 cross(@NotNull gtx_quat $this, @NotNull Vec3 res, @NotNull Vec3 v, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3 this_$iv = v;
            boolean $i$f$getZ = false;
            this_$iv = v;
            boolean $i$f$getY = false;
            float uvX = q.y.floatValue() * this_$iv.array[this_$iv.ofs + 2] - this_$iv.array[this_$iv.ofs + 1] * q.z.floatValue();
            Vec3 this_$iv2 = v;
            boolean $i$f$getX = false;
            this_$iv2 = v;
            boolean $i$f$getZ2 = false;
            float uvY = q.z.floatValue() * this_$iv2.array[this_$iv2.ofs] - this_$iv2.array[this_$iv2.ofs + 2] * q.x.floatValue();
            Vec3 this_$iv3 = v;
            boolean $i$f$getY2 = false;
            this_$iv3 = v;
            boolean $i$f$getX2 = false;
            float uvZ = q.x.floatValue() * this_$iv3.array[this_$iv3.ofs + 1] - this_$iv3.array[this_$iv3.ofs] * q.y.floatValue();
            float uuvX = q.y.floatValue() * uvZ - uvY * q.z.floatValue();
            float uuvY = q.z.floatValue() * uvX - uvZ * q.x.floatValue();
            float uuvZ = q.x.floatValue() * uvY - uvX * q.y.floatValue();
            Vec3 this_$iv4 = v;
            boolean $i$f$getX3 = false;
            float resX = this_$iv4.array[this_$iv4.ofs] + (uvX * q.w.floatValue() + uuvX) * 2.0f;
            Vec3 this_$iv5 = v;
            boolean $i$f$getY3 = false;
            float resY = this_$iv5.array[this_$iv5.ofs + 1] + (uvY * q.w.floatValue() + uuvY) * 2.0f;
            Vec3 this_$iv6 = v;
            boolean $i$f$getZ3 = false;
            float resZ = this_$iv6.array[this_$iv6.ofs + 2] + (uvZ * q.w.floatValue() + uuvZ) * 2.0f;
            return res.invoke(resX, resY, resZ);
        }

        @NotNull
        public static Quat squad(@NotNull gtx_quat $this, @NotNull Quat q1, @NotNull Quat q2, @NotNull Quat s1, @NotNull Quat s2, float h) {
            Intrinsics.checkNotNullParameter((Object)q1, (String)"q1");
            Intrinsics.checkNotNullParameter((Object)q2, (String)"q2");
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            return GLM.INSTANCE.mix(GLM.INSTANCE.mix(q1, q2, h), GLM.INSTANCE.mix(s1, s2, h), (float)2 * (1.0f - h) * h);
        }

        @NotNull
        public static Quat intermediate(@NotNull gtx_quat $this, @NotNull Quat prev, @NotNull Quat curr, @NotNull Quat next) {
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            Quat invQuat = Quat.inverse$default(curr, null, 1, null);
            return GLM.INSTANCE.exp(GLM.INSTANCE.log(next.times(invQuat)).plus(GLM.INSTANCE.log(prev.times(invQuat))).div(-4.0f)).times(curr);
        }

        @NotNull
        public static Vec3 rotate(@NotNull gtx_quat $this, @NotNull Quat q, @NotNull Vec3 v) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return q.times(v);
        }

        @NotNull
        public static Quat rotate(@NotNull gtx_quat $this, @NotNull Quat q, @NotNull Vec4 v) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return q.times(v);
        }

        public static float extractRealComponent(@NotNull gtx_quat $this, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            float w = 1.0f - q.x.floatValue() * q.x.floatValue() - q.y.floatValue() * q.y.floatValue() - q.z.floatValue() * q.z.floatValue();
            return w < 0.0f ? 0.0f : -((float)Math.sqrt(w));
        }

        @NotNull
        public static Mat3 toMat3(@NotNull gtx_quat $this, @NotNull Quat x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toMat3();
        }

        @NotNull
        public static Mat4 toMat4(@NotNull gtx_quat $this, @NotNull Quat x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toMat4();
        }

        @NotNull
        public static Quat toQuat(@NotNull gtx_quat $this, @NotNull Mat3 x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toQuat();
        }

        @NotNull
        public static Quat toQuat(@NotNull gtx_quat $this, @NotNull Mat4 x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toQuat();
        }

        @NotNull
        public static Quat shortMix(@NotNull gtx_quat $this, @NotNull Quat x, @NotNull Quat y, float a) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            if (a <= 0.0f) {
                return x;
            }
            if (a >= 1.0f) {
                return y;
            }
            float fCos = x.dot(y);
            Quat y2 = new Quat(y);
            if (fCos < 0.0f) {
                y2 = y.unaryMinus();
                fCos = -fCos;
            }
            float k0 = 0.0f;
            float k1 = 0.0f;
            if (fCos > 1.0f - GLM.epsilonF) {
                k0 = 1.0f - a;
                k1 = 0.0f + a;
            } else {
                float fSin = (float)Math.sqrt(1.0f - fCos * fCos);
                float fAngle = GLM.INSTANCE.atan(fSin, fCos);
                float fOneOverSin = 1.0f / fSin;
                k0 = (float)Math.sin((1.0f - a) * fAngle) * fOneOverSin;
                k1 = (float)Math.sin((0.0f + a) * fAngle) * fOneOverSin;
            }
            return new Quat(k0 * x.w.floatValue() + k1 * y2.w.floatValue(), k0 * x.x.floatValue() + k1 * y2.x.floatValue(), k0 * x.y.floatValue() + k1 * y2.y.floatValue(), k0 * x.z.floatValue() + k1 * y2.z.floatValue());
        }

        @NotNull
        public static Quat fastMix(@NotNull gtx_quat $this, @NotNull Quat x, @NotNull Quat y, float a) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            return ext_QuaternionGeometric.DefaultImpls.normalize$default((ext_QuaternionGeometric)GLM.INSTANCE, x.times(1.0f - a).plus(y.times(a)), null, 2, null);
        }

        @NotNull
        public static Quat rotation(@NotNull gtx_quat $this, @NotNull Vec3 orig, @NotNull Vec3 dest) {
            Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            float cosTheta = orig.dot(dest);
            if (cosTheta >= 1.0f - GLM.epsilonF) {
                return DefaultImpls.quatIdentity$default($this, null, 1, null);
            }
            if (cosTheta < (float)-1 + GLM.epsilonF) {
                Vec3 rotationAxis = new Vec3(0, 0, 1).cross(orig);
                if (rotationAxis.length2() < GLM.epsilonF) {
                    rotationAxis = new Vec3(1, 0, 0).cross(orig);
                }
                rotationAxis = Vec3.normalize$default(rotationAxis, null, 1, null);
                return GLM.INSTANCE.angleAxis(GLM.PIf, rotationAxis);
            }
            Vec3 rotationAxis = orig.cross(dest);
            float s = (float)Math.sqrt((1.0f + cosTheta) * (float)2);
            float invs = 1.0f / s;
            Vec3 this_$iv = rotationAxis;
            boolean $i$f$getX = false;
            this_$iv = rotationAxis;
            boolean $i$f$getY = false;
            this_$iv = rotationAxis;
            boolean $i$f$getZ = false;
            return new Quat(s * 0.5f, this_$iv.array[this_$iv.ofs] * invs, this_$iv.array[this_$iv.ofs + 1] * invs, this_$iv.array[this_$iv.ofs + 2] * invs);
        }

        public static float length2(@NotNull gtx_quat $this, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return q.dot(q);
        }
    }
}

