/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kotlinglm.quaternion;

import de.bixilon.kotlinglm.GLM;
import de.bixilon.kotlinglm.gtc.gtc_Quaternion;
import de.bixilon.kotlinglm.mat3x3.Mat3;
import de.bixilon.kotlinglm.mat3x3.Mat3d;
import de.bixilon.kotlinglm.mat4x4.Mat4;
import de.bixilon.kotlinglm.mat4x4.Mat4d;
import de.bixilon.kotlinglm.quaternion.Quat;
import de.bixilon.kotlinglm.quaternion.QuatT;
import de.bixilon.kotlinglm.quaternion.op_QuatD;
import de.bixilon.kotlinglm.vec3.Vec3;
import de.bixilon.kotlinglm.vec3.Vec3d;
import de.bixilon.kotlinglm.vec4.Vec4bool;
import de.bixilon.kotlinglm.vec4.Vec4d;
import de.bixilon.kotlinglm.vec4.Vec4t;
import de.bixilon.kotlinkool.PointersKt;
import de.bixilon.kotlinkool.UtilsKt;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 ]2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001]B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0007\u0010\u0012B\u0019\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0007\u0010\u0014B\u001d\b\u0016\u0012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00020\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0018B\u0011\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u0007\u0010\u001bB\u0011\b\u0016\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u0007\u0010\u001eB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\u001fB)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020 \u0012\u0006\u0010\u0004\u001a\u00020 \u0012\u0006\u0010\u0005\u001a\u00020 \u0012\u0006\u0010\u0006\u001a\u00020 \u00a2\u0006\u0004\b\u0007\u0010!B\u0015\b\u0016\u0012\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\"\u00a2\u0006\u0004\b\u0007\u0010#B\u0011\b\u0016\u0012\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0004\b\u0007\u0010&J\u0018\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010)\u001a\u00020\u0002J\u0006\u0010*\u001a\u00020\u0002J\"\u0010+\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u00112\b\b\u0002\u0010-\u001a\u00020\u0000H\u0007J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0011J\u0018\u0010/\u001a\u00020(2\u0006\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010)\u001a\u00020\u0002J\u0012\u00100\u001a\u00020\u00002\b\b\u0002\u0010-\u001a\u00020\u0000H\u0007J\u0006\u00101\u001a\u00020\u0000J\u0011\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0002H\u0086\u0006J\u0016\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0000J\u0011\u00104\u001a\u0002052\u0006\u00103\u001a\u00020\u0002H\u0086\u0006J\u0011\u00106\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u0000H\u0086\u0004J\u0013\u00107\u001a\u00020(2\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\u0012\u0010:\u001a\u00020\u00112\b\b\u0002\u0010-\u001a\u00020\u0011H\u0007J\b\u0010;\u001a\u00020\u0017H\u0016J\u0012\u0010<\u001a\u00020\u00002\b\b\u0002\u0010-\u001a\u00020\u0000H\u0007J\u0006\u0010=\u001a\u00020\u0000J\u0006\u0010>\u001a\u00020\u0002J\u0011\u0010?\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0002J\u0016\u0010?\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\u0011\u0010@\u001a\u0002052\u0006\u00103\u001a\u00020\u0000H\u0086\u0006J\u0012\u0010A\u001a\u00020\u00002\b\b\u0002\u0010-\u001a\u00020\u0000H\u0007J\u0006\u0010B\u001a\u00020\u0000J\u0011\u0010C\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010C\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\u0011\u0010D\u001a\u0002052\u0006\u00103\u001a\u00020\u0000H\u0086\u0006J\u001c\u0010E\u001a\u0002052\b\b\u0002\u0010F\u001a\u00020G2\b\b\u0002\u0010H\u001a\u00020IH\u0007J\u001c\u0010J\u001a\u0002052\b\b\u0002\u0010F\u001a\u00020G2\b\b\u0002\u0010H\u001a\u00020IH\u0007J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u0000H\u0086\u0004J&\u0010K\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002J\u0019\u0010M\u001a\u0002052\u0006\u0010N\u001a\u00020\u00172\u0006\u0010O\u001a\u00020 H\u0096\u0002J\"\u0010P\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u00022\b\b\u0002\u0010-\u001a\u00020\u0000H\u0007J\u0016\u0010R\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0002J\u0011\u0010S\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0002H\u0086\u0006J\u0011\u0010S\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010S\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u001dH\u0086\u0006J\u0016\u0010S\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0000J\u0016\u0010S\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\u0016\u0010S\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0000J\u0011\u0010S\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0011H\u0086\u0006J\u0016\u0010S\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011J\u0011\u0010T\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0002H\u0086\u0004J\u0011\u0010T\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010T\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u001dH\u0086\u0004J\u0011\u0010T\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0011H\u0086\u0004J\u001a\u0010U\u001a\u0002052\n\u0010$\u001a\u00060Wj\u0002`VH\u0086\u0004\u00a2\u0006\u0002\u0010XJ\b\u0010Y\u001a\u00020GH\u0016J\t\u0010Z\u001a\u00020\u0000H\u0086\u0002J\t\u0010[\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010\\\u001a\u0002052\b\b\u0002\u0010-\u001a\u00020\u001dH\u0007\u00a8\u0006^"}, d2={"Lde/bixilon/kotlinglm/quaternion/QuatD;", "Lde/bixilon/kotlinglm/quaternion/QuatT;", "", "w", "x", "y", "z", "<init>", "(DDDD)V", "()V", "d", "(D)V", "q", "Lde/bixilon/kotlinglm/quaternion/Quat;", "(Lde/bixilon/kotlinglm/quaternion/Quat;)V", "s", "v", "Lde/bixilon/kotlinglm/vec3/Vec3d;", "(DLde/bixilon/kotlinglm/vec3/Vec3d;)V", "u", "(Lde/bixilon/kotlinglm/vec3/Vec3d;Lde/bixilon/kotlinglm/vec3/Vec3d;)V", "block", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "eulerAngle", "Lde/bixilon/kotlinglm/vec3/Vec3;", "(Lde/bixilon/kotlinglm/vec3/Vec3;)V", "vec4", "Lde/bixilon/kotlinglm/vec4/Vec4d;", "(Lde/bixilon/kotlinglm/vec4/Vec4d;)V", "(Lde/bixilon/kotlinglm/quaternion/QuatD;)V", "", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lde/bixilon/kotlinglm/vec4/Vec4t;", "(Lde/bixilon/kotlinglm/vec4/Vec4t;)V", "ptr", "Lde/bixilon/kotlinkool/DoublePtr;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "allEqual", "", "epsilon", "angle", "angleAxis", "axis", "res", "angleAxisAssign", "anyNotEqual", "conjugate", "conjugateAssign", "div", "b", "divAssign", "", "dot", "equals", "other", "", "eulerAngles", "hashCode", "inverse", "inverseAssign", "length", "minus", "minusAssign", "normalize", "normalizeAssign", "plus", "plusAssign", "print", "name", "", "stream", "Ljava/io/PrintStream;", "println", "put", "quat", "set", "index", "value", "slerp", "interp", "slerpAssign", "times", "timesAssign", "to", "Lde/bixilon/kotlinkool/Ptr;", "", "(J)V", "toString", "unaryMinus", "unaryPlus", "vectorize", "Companion", "glm"})
@SourceDebugExtension(value={"SMAP\nQuatD.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuatD.kt\nde/bixilon/kotlinglm/quaternion/QuatD\n+ 2 Vec3d.kt\nde/bixilon/kotlinglm/vec3/Vec3d\n+ 3 Vec3.kt\nde/bixilon/kotlinglm/vec3/Vec3\n+ 4 Vec4d.kt\nde/bixilon/kotlinglm/vec4/Vec4d\n+ 5 Extensions.kt\nde/bixilon/kotlinglm/ExtensionsKt\n+ 6 QuatT.kt\nde/bixilon/kotlinglm/quaternion/QuatT\n*L\n1#1,233:1\n30#2,7:234\n30#2,7:241\n30#2,7:248\n30#3:255\n33#3:256\n36#3:257\n41#4:258\n32#4,7:259\n91#5:266\n104#5:267\n104#5:268\n104#5:269\n104#5:270\n104#5:271\n104#5:272\n26#6,7:273\n*S KotlinDebug\n*F\n+ 1 QuatD.kt\nde/bixilon/kotlinglm/quaternion/QuatD\n*L\n30#1:234,7\n39#1:241,7\n44#1:248,7\n50#1:255\n51#1:256\n52#1:257\n65#1:258\n65#1:259,7\n82#1:266\n83#1:267\n84#1:268\n109#1:269\n110#1:270\n111#1:271\n112#1:272\n213#1:273,7\n*E\n"})
public final class QuatD
extends QuatT<Double> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public static final int length = 4;
    @JvmField
    public static final int size = length * UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE);

    public QuatD(double w, double x, double y, double z) {
        super(w, x, y, z);
    }

    public QuatD() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public QuatD(double d) {
        this(d, d, d, d);
    }

    public QuatD(@NotNull Quat q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this(q.w, q.x, q.y, q.z);
    }

    public QuatD(double s, @NotNull Vec3d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Vec3d this_$iv = v;
        boolean $i$f$getX = false;
        this_$iv = v;
        boolean $i$f$getY = false;
        this_$iv = v;
        boolean $i$f$getZ = false;
        this(s, this_$iv.array[this_$iv.ofs], this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs + 2]);
    }

    public QuatD(@NotNull Vec3d u, @NotNull Vec3d v) {
        Vec3d w;
        Vec3d vec3d;
        boolean $i$f$getY;
        boolean $i$f$getZ;
        boolean $i$f$getX;
        Vec3d this_$iv;
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this();
        double normUnormV = Math.sqrt(u.dot(u) * v.dot(v));
        double realPart = normUnormV + u.dot(v);
        if (realPart < (double)1.0E-6f * normUnormV) {
            realPart = 0.0;
            this_$iv = u;
            $i$f$getX = false;
            this_$iv = u;
            $i$f$getZ = false;
            if (Math.abs(this_$iv.array[this_$iv.ofs]) > Math.abs(this_$iv.array[this_$iv.ofs + 2])) {
                this_$iv = u;
                $i$f$getY = false;
                this_$iv = u;
                $i$f$getX = false;
                vec3d = new Vec3d(-this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs], 0.0);
            } else {
                this_$iv = u;
                $i$f$getZ = false;
                this_$iv = u;
                $i$f$getY = false;
                vec3d = new Vec3d(0.0, -this_$iv.array[this_$iv.ofs + 2], this_$iv.array[this_$iv.ofs + 1]);
            }
        } else {
            vec3d = u.cross(v);
        }
        this_$iv = w = vec3d;
        $i$f$getX = false;
        this_$iv = w;
        $i$f$getY = false;
        this_$iv = w;
        $i$f$getZ = false;
        this.put(realPart, this_$iv.array[this_$iv.ofs], this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs + 2]).normalizeAssign();
    }

    public QuatD(@NotNull Function1<? super Integer, Double> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(((Number)block.invoke((Object)0)).doubleValue(), ((Number)block.invoke((Object)1)).doubleValue(), ((Number)block.invoke((Object)2)).doubleValue(), ((Number)block.invoke((Object)3)).doubleValue());
    }

    public QuatD(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkNotNullParameter((Object)eulerAngle, (String)"eulerAngle");
        this();
        Vec3 this_$iv = eulerAngle;
        boolean $i$f$getX = false;
        double eX = (double)this_$iv.array[this_$iv.ofs] * 0.5;
        Vec3 this_$iv2 = eulerAngle;
        boolean $i$f$getY = false;
        double eY = (double)this_$iv2.array[this_$iv2.ofs + 1] * 0.5;
        Vec3 this_$iv3 = eulerAngle;
        boolean $i$f$getZ = false;
        double eZ = (double)this_$iv3.array[this_$iv3.ofs + 2] * 0.5;
        double cX = GLM.INSTANCE.cos(eX);
        double cY = GLM.INSTANCE.cos(eY);
        double cZ = GLM.INSTANCE.cos(eZ);
        double sX = GLM.INSTANCE.sin(eX);
        double sY = GLM.INSTANCE.sin(eY);
        double sZ = GLM.INSTANCE.sin(eZ);
        this.w = cX * cY * cZ + sX * sY * sZ;
        this.x = sX * cY * cZ - cX * sY * sZ;
        this.y = cX * sY * cZ + sX * cY * sZ;
        this.z = cX * cY * sZ - sX * sY * cZ;
    }

    public QuatD(@NotNull Vec4d vec4) {
        Intrinsics.checkNotNullParameter((Object)vec4, (String)"vec4");
        Vec4d this_$iv = vec4;
        boolean $i$f$getW = false;
        this_$iv = vec4;
        boolean $i$f$getX = false;
        this_$iv = vec4;
        boolean $i$f$getY = false;
        this_$iv = vec4;
        boolean $i$f$getZ = false;
        this(this_$iv.array[this_$iv.ofs + 3], this_$iv.array[this_$iv.ofs], this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs + 2]);
    }

    public QuatD(@NotNull QuatD q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        double $this$d$iv = q.w.doubleValue();
        boolean $i$f$getD = false;
        double d = $this$d$iv;
        $this$d$iv = q.x.doubleValue();
        $i$f$getD = false;
        double d2 = $this$d$iv;
        $this$d$iv = q.y.doubleValue();
        $i$f$getD = false;
        double d3 = $this$d$iv;
        $this$d$iv = q.z.doubleValue();
        $i$f$getD = false;
        this(d, d2, d3, $this$d$iv);
    }

    public QuatD(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Number $this$d$iv = w;
        boolean $i$f$getD = false;
        double d = $this$d$iv.doubleValue();
        $this$d$iv = x;
        $i$f$getD = false;
        double d2 = $this$d$iv.doubleValue();
        $this$d$iv = y;
        $i$f$getD = false;
        double d3 = $this$d$iv.doubleValue();
        $this$d$iv = z;
        $i$f$getD = false;
        this(d, d2, d3, $this$d$iv.doubleValue());
    }

    public QuatD(@NotNull Vec4t<?> vec4) {
        Intrinsics.checkNotNullParameter(vec4, (String)"vec4");
        Object $this$d$iv = vec4.get_w();
        boolean $i$f$getD = false;
        double d = ((Number)$this$d$iv).doubleValue();
        $this$d$iv = vec4.get_x();
        $i$f$getD = false;
        double d2 = ((Number)$this$d$iv).doubleValue();
        $this$d$iv = vec4.get_y();
        $i$f$getD = false;
        double d3 = ((Number)$this$d$iv).doubleValue();
        $this$d$iv = vec4.get_z();
        $i$f$getD = false;
        this(d, d2, d3, ((Number)$this$d$iv).doubleValue());
    }

    private QuatD(final long ptr) {
        this((Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(){

            @NotNull
            public final Double invoke(int i) {
                long arg0$iv = ptr;
                boolean bl = false;
                return PointersKt.getUNSAFE().getDouble(null, arg0$iv + (long)(i * UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE)));
            }
        }));
    }

    @NotNull
    public final QuatD put(double w, double x, double y, double z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public final QuatD put(@NotNull QuatD quat) {
        Intrinsics.checkNotNullParameter((Object)quat, (String)"quat");
        return this.put(quat.w.doubleValue(), quat.x.doubleValue(), quat.y.doubleValue(), quat.z.doubleValue());
    }

    public final void to(long ptr) {
        MemoryUtil.memPutDouble((long)ptr, (double)this.w.doubleValue());
        MemoryUtil.memPutDouble((long)(ptr + (long)UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE)), (double)this.x.doubleValue());
        MemoryUtil.memPutDouble((long)(ptr + (long)(UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE) * 2)), (double)this.y.doubleValue());
        MemoryUtil.memPutDouble((long)(ptr + (long)(UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE) * 3)), (double)this.z.doubleValue());
    }

    @Override
    public void set(int index, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (index) {
            case 0: {
                Number $this$d$iv = value;
                boolean $i$f$getD = false;
                this.x = $this$d$iv.doubleValue();
                break;
            }
            case 1: {
                Number $this$d$iv = value;
                boolean $i$f$getD = false;
                this.y = $this$d$iv.doubleValue();
                break;
            }
            case 2: {
                Number $this$d$iv = value;
                boolean $i$f$getD = false;
                this.z = $this$d$iv.doubleValue();
                break;
            }
            case 3: {
                Number $this$d$iv = value;
                boolean $i$f$getD = false;
                this.w = $this$d$iv.doubleValue();
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final QuatD unaryPlus() {
        return this;
    }

    @NotNull
    public final QuatD unaryMinus() {
        return new QuatD(-this.w.doubleValue(), -this.x.doubleValue(), -this.y.doubleValue(), -this.z.doubleValue());
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.plus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.plus(res, this, b);
    }

    public final void plusAssign(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.plus(this, this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.minus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.minus(res, this, b);
    }

    public final void minusAssign(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.minus(this, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(double b) {
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Vec3d(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD times(double b, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b, @NotNull Vec3d res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD timesAssign(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD timesAssign(double b) {
        return Companion.times(this, this, b);
    }

    @NotNull
    public final Vec3d timesAssign(@NotNull Vec3d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(b, this, b);
    }

    @NotNull
    public final QuatD timesAssign(@NotNull Vec4d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD div(double b) {
        return Companion.div(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD div(double b, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.div(res, this, b);
    }

    public final void divAssign(double b) {
        Companion.div(this, this, b);
    }

    public final double length() {
        return GLM.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize(@NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.normalize(this, res);
    }

    public static /* synthetic */ QuatD normalize$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.normalize(quatD2);
    }

    @NotNull
    public final QuatD normalizeAssign() {
        return GLM.INSTANCE.normalize(this, this);
    }

    public final double dot(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return GLM.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.angleAxis(angle, axis, res);
    }

    public static /* synthetic */ QuatD angleAxis$default(QuatD quatD, double d, Vec3d vec3d, QuatD quatD2, int n, Object object) {
        if ((n & 4) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.angleAxis(d, vec3d, quatD2);
    }

    @NotNull
    public final QuatD angleAxisAssign(double angle, @NotNull Vec3d axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return GLM.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate(@NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.conjugate(this, res);
    }

    public static /* synthetic */ QuatD conjugate$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.conjugate(quatD2);
    }

    @NotNull
    public final QuatD conjugateAssign() {
        return GLM.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse(@NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.inverse(this, res);
    }

    public static /* synthetic */ QuatD inverse$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.inverse(quatD2);
    }

    @NotNull
    public final QuatD inverseAssign() {
        return GLM.INSTANCE.inverse(this, this);
    }

    public final double angle() {
        return GLM.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles(@NotNull Vec3d res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.eulerAngles(this, res);
    }

    public static /* synthetic */ Vec3d eulerAngles$default(QuatD quatD, Vec3d vec3d, int n, Object object) {
        if ((n & 1) != 0) {
            vec3d = new Vec3d();
        }
        return quatD.eulerAngles(vec3d);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp, @NotNull QuatD res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.slerp(this, b, interp, res);
    }

    public static /* synthetic */ QuatD slerp$default(QuatD quatD, QuatD quatD2, double d, QuatD quatD3, int n, Object object) {
        if ((n & 4) != 0) {
            quatD3 = new QuatD();
        }
        return quatD.slerp(quatD2, d, quatD3);
    }

    @NotNull
    public final QuatD slerpAssign(@NotNull QuatD b, double interp) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return GLM.INSTANCE.slerp(this, b, interp, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object t;
        Object t2;
        Object t3;
        Object t4;
        Object t5;
        Object t6;
        Object t7;
        Object t8;
        QuatT this_$iv;
        if (!(other instanceof QuatD)) return false;
        QuatT quatT = this;
        int index$iv = 0;
        boolean $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t8 = this_$iv.x;
                break;
            }
            case 1: {
                t8 = this_$iv.y;
                break;
            }
            case 2: {
                t8 = this_$iv.z;
                break;
            }
            case 3: {
                t8 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        double d = ((Number)t8).doubleValue();
        this_$iv = (QuatT)other;
        index$iv = 0;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t7 = this_$iv.x;
                break;
            }
            case 1: {
                t7 = this_$iv.y;
                break;
            }
            case 2: {
                t7 = this_$iv.z;
                break;
            }
            case 3: {
                t7 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (d != ((Number)t7).doubleValue()) return false;
        boolean bl = true;
        if (!bl) return false;
        this_$iv = this;
        index$iv = 1;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t6 = this_$iv.x;
                break;
            }
            case 1: {
                t6 = this_$iv.y;
                break;
            }
            case 2: {
                t6 = this_$iv.z;
                break;
            }
            case 3: {
                t6 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        double d2 = ((Number)t6).doubleValue();
        this_$iv = (QuatT)other;
        index$iv = 1;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t5 = this_$iv.x;
                break;
            }
            case 1: {
                t5 = this_$iv.y;
                break;
            }
            case 2: {
                t5 = this_$iv.z;
                break;
            }
            case 3: {
                t5 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (d2 != ((Number)t5).doubleValue()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        this_$iv = this;
        index$iv = 2;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t4 = this_$iv.x;
                break;
            }
            case 1: {
                t4 = this_$iv.y;
                break;
            }
            case 2: {
                t4 = this_$iv.z;
                break;
            }
            case 3: {
                t4 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        double d3 = ((Number)t4).doubleValue();
        this_$iv = (QuatT)other;
        index$iv = 2;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t3 = this_$iv.x;
                break;
            }
            case 1: {
                t3 = this_$iv.y;
                break;
            }
            case 2: {
                t3 = this_$iv.z;
                break;
            }
            case 3: {
                t3 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (d3 != ((Number)t3).doubleValue()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        this_$iv = this;
        index$iv = 3;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t2 = this_$iv.x;
                break;
            }
            case 1: {
                t2 = this_$iv.y;
                break;
            }
            case 2: {
                t2 = this_$iv.z;
                break;
            }
            case 3: {
                t2 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        double d4 = ((Number)t2).doubleValue();
        this_$iv = (QuatT)other;
        index$iv = 3;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t = this_$iv.x;
                break;
            }
            case 1: {
                t = this_$iv.y;
                break;
            }
            case 2: {
                t = this_$iv.z;
                break;
            }
            case 3: {
                t = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (d4 != ((Number)t).doubleValue()) return false;
        return true;
    }

    public int hashCode() {
        return 31 * (31 * (31 * Double.hashCode(this.w.doubleValue()) + Double.hashCode(this.x.doubleValue())) + Double.hashCode(this.y.doubleValue())) + Double.hashCode(this.z.doubleValue());
    }

    @JvmOverloads
    public final void print(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.print(name + this);
    }

    public static /* synthetic */ void print$default(QuatD quatD, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            printStream = System.out;
        }
        quatD.print(string, printStream);
    }

    @JvmOverloads
    public final void println(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.println(name + this);
    }

    public static /* synthetic */ void println$default(QuatD quatD, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            printStream = System.out;
        }
        quatD.println(string, printStream);
    }

    @NotNull
    public String toString() {
        return "(" + this.w + ", {" + this.x + ", " + this.y + ", " + this.z + "})";
    }

    @JvmOverloads
    public final void vectorize(@NotNull Vec4d res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        res.put(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue(), this.w.doubleValue());
    }

    public static /* synthetic */ void vectorize$default(QuatD quatD, Vec4d vec4d, int n, Object object) {
        if ((n & 1) != 0) {
            vec4d = new Vec4d();
        }
        quatD.vectorize(vec4d);
    }

    public final boolean allEqual(@NotNull QuatD q, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.doubleValue() - q.x.doubleValue() < epsilon && this.y.doubleValue() - q.y.doubleValue() < epsilon && this.z.doubleValue() - q.z.doubleValue() < epsilon && this.w.doubleValue() - q.w.doubleValue() < epsilon;
    }

    public static /* synthetic */ boolean allEqual$default(QuatD quatD, QuatD quatD2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = GLM.INSTANCE.get\u03b5();
        }
        return quatD.allEqual(quatD2, d);
    }

    public final boolean anyNotEqual(@NotNull QuatD q, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.doubleValue() - q.x.doubleValue() >= epsilon || this.y.doubleValue() - q.y.doubleValue() >= epsilon || this.z.doubleValue() - q.z.doubleValue() >= epsilon || this.w.doubleValue() - q.w.doubleValue() >= epsilon;
    }

    public static /* synthetic */ boolean anyNotEqual$default(QuatD quatD, QuatD quatD2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = GLM.INSTANCE.get\u03b5();
        }
        return quatD.anyNotEqual(quatD2, d);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize() {
        return QuatD.normalize$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return QuatD.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate() {
        return QuatD.conjugate$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse() {
        return QuatD.inverse$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles() {
        return QuatD.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return QuatD.slerp$default(this, b, interp, null, 4, null);
    }

    @JvmOverloads
    public final void print(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        QuatD.print$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void print() {
        QuatD.print$default(this, null, null, 3, null);
    }

    @JvmOverloads
    public final void println(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        QuatD.println$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void println() {
        QuatD.println$default(this, null, null, 3, null);
    }

    @JvmOverloads
    public final void vectorize() {
        QuatD.vectorize$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Quat fromPointer(long ptr) {
        return Companion.fromPointer(ptr);
    }

    public /* synthetic */ QuatD(long ptr, DefaultConstructorMarker $constructor_marker) {
        this(ptr);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\tj\u0002`\bH\u0007\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/bixilon/kotlinglm/quaternion/QuatD$Companion;", "Lde/bixilon/kotlinglm/quaternion/op_QuatD;", "Lde/bixilon/kotlinglm/gtc/gtc_Quaternion;", "<init>", "()V", "fromPointer", "Lde/bixilon/kotlinglm/quaternion/Quat;", "ptr", "Lde/bixilon/kotlinkool/Ptr;", "", "(J)Lde/bixilon/kotlinglm/quaternion/Quat;", "identity", "Lde/bixilon/kotlinglm/quaternion/QuatD;", "getIdentity", "()Lde/bixilon/kotlinglm/quaternion/QuatD;", "length", "", "size", "glm"})
    public static final class Companion
    implements op_QuatD,
    gtc_Quaternion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Quat fromPointer(long ptr) {
            return new Quat(MemoryUtil.memGetDouble((long)ptr), MemoryUtil.memGetDouble((long)(ptr + (long)UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE))), MemoryUtil.memGetDouble((long)(ptr + (long)(UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE) * 2))), MemoryUtil.memGetDouble((long)(ptr + (long)(UtilsKt.getBYTES((DoubleCompanionObject)DoubleCompanionObject.INSTANCE) * 3))));
        }

        @NotNull
        public final QuatD getIdentity() {
            return new QuatD(1.0, 0.0, 0.0, 0.0);
        }

        @Override
        @NotNull
        public QuatD plus(@NotNull QuatD res, @NotNull QuatD a, @NotNull QuatD b) {
            return op_QuatD.DefaultImpls.plus(this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD minus(@NotNull QuatD res, @NotNull QuatD a, @NotNull QuatD b) {
            return op_QuatD.DefaultImpls.minus(this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a, @NotNull QuatD b) {
            return op_QuatD.DefaultImpls.times((op_QuatD)this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a, double b) {
            return op_QuatD.DefaultImpls.times((op_QuatD)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res, @NotNull QuatD a, @NotNull Vec3d b) {
            return op_QuatD.DefaultImpls.times((op_QuatD)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res, @NotNull Vec3d a, @NotNull QuatD b) {
            return op_QuatD.DefaultImpls.times((op_QuatD)this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a, @NotNull Vec4d b) {
            return op_QuatD.DefaultImpls.times((op_QuatD)this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD div(@NotNull QuatD res, @NotNull QuatD a, double b) {
            return op_QuatD.DefaultImpls.div(this, res, a, b);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res) {
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            return gtc_Quaternion.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res) {
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res, @NotNull QuatD q) {
            return gtc_Quaternion.DefaultImpls.mat4d_cast(this, res, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res) {
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res) {
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.greater(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.greater(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.equal(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.equal(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.isNan(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.isInf(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.isInf(this, q);
        }

        @Override
        @NotNull
        public Quat quatLookAt(@NotNull Vec3 direction, @NotNull Vec3 up) {
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAt(@NotNull Vec3d direction, @NotNull Vec3d up) {
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtRH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtRH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtLH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtLH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

