/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kotlinglm.quaternion;

import de.bixilon.kotlinglm.ExtensionsKt;
import de.bixilon.kotlinglm.GLM;
import de.bixilon.kotlinglm.gtc.gtc_Quaternion;
import de.bixilon.kotlinglm.mat3x3.Mat3;
import de.bixilon.kotlinglm.mat3x3.Mat3d;
import de.bixilon.kotlinglm.mat4x4.Mat4;
import de.bixilon.kotlinglm.mat4x4.Mat4d;
import de.bixilon.kotlinglm.quaternion.QuatD;
import de.bixilon.kotlinglm.quaternion.QuatT;
import de.bixilon.kotlinglm.quaternion.op_Quat;
import de.bixilon.kotlinglm.vec3.Vec3;
import de.bixilon.kotlinglm.vec3.Vec3d;
import de.bixilon.kotlinglm.vec4.Vec4;
import de.bixilon.kotlinglm.vec4.Vec4bool;
import de.bixilon.kotlinglm.vec4.Vec4t;
import de.bixilon.kotlinkool.PointersKt;
import de.bixilon.kotlinkool.UtilsKt;
import java.io.InputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\t\u0018\u0000 e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001eB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\rB\u0019\b\u0016\u0012\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0001\u00a2\u0006\u0004\b\u0007\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0007\u0010\u0013B\u0019\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0007\u0010\u0015B\u001d\b\u0016\u0012\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00020\u0017\u00a2\u0006\u0004\b\u0007\u0010\u0019B\u0011\b\u0016\u0012\u0006\u0010\u001a\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0007\u0010\u001bB\u0011\b\u0016\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u0007\u0010\u001eB\u001b\b\u0016\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\b\b\u0002\u0010!\u001a\u00020\"\u00a2\u0006\u0004\b\u0007\u0010#B\u0011\b\u0016\u0012\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0004\b\u0007\u0010&B\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020'\u00a2\u0006\u0004\b\u0007\u0010(B)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0007\u0010)B\u0015\b\u0016\u0012\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030*\u00a2\u0006\u0004\b\u0007\u0010+J\u0018\u0010,\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010-\u001a\u00020\u0002J\u0006\u0010.\u001a\u00020\u0002J\"\u0010/\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u00122\b\b\u0002\u00101\u001a\u00020\u0000H\u0007J\u0016\u00102\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0012J\u0018\u00103\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010-\u001a\u00020\u0002J\u0012\u00104\u001a\u00020\u00002\b\b\u0002\u00101\u001a\u00020\u0000H\u0007J\u0006\u00105\u001a\u00020\u0000J\u0011\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0002H\u0086\u0006J\u0016\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0000J\u0011\u00108\u001a\u0002092\u0006\u00107\u001a\u00020\u0002H\u0086\u0006J\u0011\u0010:\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010;\u001a\u00020\"2\b\u0010<\u001a\u0004\u0018\u00010=H\u0096\u0002J\u0012\u0010>\u001a\u00020\u00122\b\b\u0002\u00101\u001a\u00020\u0012H\u0007J\b\u0010?\u001a\u00020\u0018H\u0016J\u0012\u0010@\u001a\u00020\u00002\b\b\u0002\u00101\u001a\u00020\u0000H\u0007J\u0006\u0010A\u001a\u00020\u0000J\u0006\u0010B\u001a\u00020\u0002J\u0011\u0010C\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010C\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000J\u0011\u0010D\u001a\u0002092\u0006\u00107\u001a\u00020\u0000H\u0086\u0006J\u0012\u0010E\u001a\u00020\u00002\b\b\u0002\u00101\u001a\u00020\u0000H\u0007J\u0006\u0010F\u001a\u00020\u0000J\u0011\u0010G\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010G\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000J\u0011\u0010H\u001a\u0002092\u0006\u00107\u001a\u00020\u0000H\u0086\u0006J\u001c\u0010I\u001a\u0002092\b\b\u0002\u0010J\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020MH\u0007J\u001c\u0010N\u001a\u0002092\b\b\u0002\u0010J\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020MH\u0007J\u0011\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0000H\u0086\u0004J&\u0010O\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002J\u0019\u0010Q\u001a\u0002092\u0006\u0010R\u001a\u00020\u00182\u0006\u0010S\u001a\u00020\u000eH\u0096\u0002J\"\u0010T\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00022\b\b\u0002\u00101\u001a\u00020\u0000H\u0007J\u0016\u0010V\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u0002J\u0011\u0010W\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0002H\u0086\u0006J\u0011\u0010W\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010W\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u001dH\u0086\u0006J\u0016\u0010W\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0000J\u0016\u0010W\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000J\u0016\u0010W\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0000J\u0011\u0010W\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0012H\u0086\u0006J\u0016\u0010W\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0012J\u0011\u0010X\u001a\u0002092\u0006\u00107\u001a\u00020\u0002H\u0086\u0006J\u0011\u0010X\u001a\u0002092\u0006\u00107\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010X\u001a\u0002092\u0006\u00107\u001a\u00020\u0012H\u0086\u0006J\u0011\u0010X\u001a\u0002092\u0006\u00107\u001a\u00020\u001dH\u0086\u0006J\u0011\u0010Y\u001a\u00020Z2\u0006\u00101\u001a\u00020ZH\u0086\u0004J\u0011\u0010Y\u001a\u00020[2\u0006\u00101\u001a\u00020[H\u0086\u0004J\u001a\u0010Y\u001a\u0002092\n\u0010$\u001a\u00060]j\u0002`\\H\u0086\u0004\u00a2\u0006\u0002\u0010^J\u0006\u0010_\u001a\u00020ZJ\u0006\u0010`\u001a\u00020[J\b\u0010a\u001a\u00020KH\u0016J\t\u0010b\u001a\u00020\u0000H\u0086\u0002J\t\u0010c\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010d\u001a\u0002092\b\b\u0002\u00101\u001a\u00020\u001dH\u0007\u00a8\u0006f"}, d2={"Lde/bixilon/kotlinglm/quaternion/Quat;", "Lde/bixilon/kotlinglm/quaternion/QuatT;", "", "w", "x", "y", "z", "<init>", "(FFFF)V", "()V", "f", "(F)V", "q", "(Lde/bixilon/kotlinglm/quaternion/Quat;)V", "", "(Lde/bixilon/kotlinglm/quaternion/QuatT;)V", "s", "v", "Lde/bixilon/kotlinglm/vec3/Vec3;", "(FLde/bixilon/kotlinglm/vec3/Vec3;)V", "u", "(Lde/bixilon/kotlinglm/vec3/Vec3;Lde/bixilon/kotlinglm/vec3/Vec3;)V", "block", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "eulerAngle", "(Lde/bixilon/kotlinglm/vec3/Vec3;)V", "vec4", "Lde/bixilon/kotlinglm/vec4/Vec4;", "(Lde/bixilon/kotlinglm/vec4/Vec4;)V", "inputStream", "Ljava/io/InputStream;", "bigEndian", "", "(Ljava/io/InputStream;Z)V", "ptr", "Lde/bixilon/kotlinkool/FloatPtr;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Lde/bixilon/kotlinglm/quaternion/QuatD;", "(Lde/bixilon/kotlinglm/quaternion/QuatD;)V", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lde/bixilon/kotlinglm/vec4/Vec4t;", "(Lde/bixilon/kotlinglm/vec4/Vec4t;)V", "allEqual", "epsilon", "angle", "angleAxis", "axis", "res", "angleAxisAssign", "anyNotEqual", "conjugate", "conjugateAssign", "div", "b", "divAssign", "", "dot", "equals", "other", "", "eulerAngles", "hashCode", "inverse", "inverseAssign", "length", "minus", "minusAssign", "normalize", "normalizeAssign", "plus", "plusAssign", "print", "name", "", "stream", "Ljava/io/PrintStream;", "println", "put", "quat", "set", "index", "value", "slerp", "interp", "slerpAssign", "times", "timesAssign", "to", "Lde/bixilon/kotlinglm/mat3x3/Mat3;", "Lde/bixilon/kotlinglm/mat4x4/Mat4;", "Lde/bixilon/kotlinkool/Ptr;", "", "(J)V", "toMat3", "toMat4", "toString", "unaryMinus", "unaryPlus", "vectorize", "Companion", "glm"})
@SourceDebugExtension(value={"SMAP\nQuat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quat.kt\nde/bixilon/kotlinglm/quaternion/Quat\n+ 2 Vec3.kt\nde/bixilon/kotlinglm/vec3/Vec3\n+ 3 Vec4.kt\nde/bixilon/kotlinglm/vec4/Vec4\n+ 4 Extensions.kt\nde/bixilon/kotlinglm/ExtensionsKt\n+ 5 QuatT.kt\nde/bixilon/kotlinglm/quaternion/QuatT\n*L\n1#1,253:1\n30#2,7:254\n30#2,7:261\n30#2,7:268\n30#2:275\n33#2:276\n36#2:277\n39#3:278\n30#3,7:279\n89#4:286\n102#4:287\n102#4:288\n102#4:289\n102#4:290\n102#4:291\n102#4:292\n26#5,7:293\n*S KotlinDebug\n*F\n+ 1 Quat.kt\nde/bixilon/kotlinglm/quaternion/Quat\n*L\n36#1:254,7\n45#1:261,7\n50#1:268,7\n56#1:275\n57#1:276\n58#1:277\n71#1:278\n71#1:279,7\n93#1:286\n94#1:287\n95#1:288\n118#1:289\n119#1:290\n120#1:291\n121#1:292\n235#1:293,7\n*E\n"})
public final class Quat
extends QuatT<Float> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public static final int length = 4;
    @JvmField
    public static final int size = length * UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE);

    public Quat(float w, float x, float y, float z) {
        super((Number)Float.valueOf(w), (Number)Float.valueOf(x), (Number)Float.valueOf(y), (Number)Float.valueOf(z));
    }

    public Quat() {
        this(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public Quat(float f) {
        this(f, f, f, f);
    }

    public Quat(@NotNull Quat q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this(q.w.floatValue(), q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
    }

    public Quat(@NotNull QuatT<? extends Number> q) {
        Intrinsics.checkNotNullParameter(q, (String)"q");
        this((Number)q.w, (Number)q.x, (Number)q.y, (Number)q.z);
    }

    public Quat(float s, @NotNull Vec3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Vec3 this_$iv = v;
        boolean $i$f$getX = false;
        this_$iv = v;
        boolean $i$f$getY = false;
        this_$iv = v;
        boolean $i$f$getZ = false;
        this(s, this_$iv.array[this_$iv.ofs], this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs + 2]);
    }

    public Quat(@NotNull Vec3 u, @NotNull Vec3 v) {
        Vec3 w;
        Vec3 vec3;
        boolean $i$f$getY;
        boolean $i$f$getZ;
        boolean $i$f$getX;
        Vec3 this_$iv;
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this();
        float normUnormV = (float)Math.sqrt(u.dot(u) * v.dot(v));
        float realPart = normUnormV + u.dot(v);
        if (realPart < 1.0E-6f * normUnormV) {
            realPart = 0.0f;
            this_$iv = u;
            $i$f$getX = false;
            this_$iv = u;
            $i$f$getZ = false;
            if (Math.abs(this_$iv.array[this_$iv.ofs]) > Math.abs(this_$iv.array[this_$iv.ofs + 2])) {
                this_$iv = u;
                $i$f$getY = false;
                this_$iv = u;
                $i$f$getX = false;
                vec3 = new Vec3(-this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs], 0.0f);
            } else {
                this_$iv = u;
                $i$f$getZ = false;
                this_$iv = u;
                $i$f$getY = false;
                vec3 = new Vec3(0.0f, -this_$iv.array[this_$iv.ofs + 2], this_$iv.array[this_$iv.ofs + 1]);
            }
        } else {
            vec3 = u.cross(v);
        }
        this_$iv = w = vec3;
        $i$f$getX = false;
        this_$iv = w;
        $i$f$getY = false;
        this_$iv = w;
        $i$f$getZ = false;
        this.put(realPart, this_$iv.array[this_$iv.ofs], this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs + 2]).normalizeAssign();
    }

    public Quat(@NotNull Function1<? super Integer, Float> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(((Number)block.invoke((Object)0)).floatValue(), ((Number)block.invoke((Object)1)).floatValue(), ((Number)block.invoke((Object)2)).floatValue(), ((Number)block.invoke((Object)3)).floatValue());
    }

    public Quat(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkNotNullParameter((Object)eulerAngle, (String)"eulerAngle");
        this();
        Vec3 this_$iv = eulerAngle;
        boolean $i$f$getX = false;
        float eX = this_$iv.array[this_$iv.ofs] * 0.5f;
        Vec3 this_$iv2 = eulerAngle;
        boolean $i$f$getY = false;
        float eY = this_$iv2.array[this_$iv2.ofs + 1] * 0.5f;
        Vec3 this_$iv3 = eulerAngle;
        boolean $i$f$getZ = false;
        float eZ = this_$iv3.array[this_$iv3.ofs + 2] * 0.5f;
        float cX = GLM.INSTANCE.cos(eX);
        float cY = GLM.INSTANCE.cos(eY);
        float cZ = GLM.INSTANCE.cos(eZ);
        float sX = GLM.INSTANCE.sin(eX);
        float sY = GLM.INSTANCE.sin(eY);
        float sZ = GLM.INSTANCE.sin(eZ);
        this.w = Float.valueOf(cX * cY * cZ + sX * sY * sZ);
        this.x = Float.valueOf(sX * cY * cZ - cX * sY * sZ);
        this.y = Float.valueOf(cX * sY * cZ + sX * cY * sZ);
        this.z = Float.valueOf(cX * cY * sZ - sX * sY * cZ);
    }

    public Quat(@NotNull Vec4 vec4) {
        Intrinsics.checkNotNullParameter((Object)vec4, (String)"vec4");
        Vec4 this_$iv = vec4;
        boolean $i$f$getW = false;
        this_$iv = vec4;
        boolean $i$f$getX = false;
        this_$iv = vec4;
        boolean $i$f$getY = false;
        this_$iv = vec4;
        boolean $i$f$getZ = false;
        this(this_$iv.array[this_$iv.ofs + 3], this_$iv.array[this_$iv.ofs], this_$iv.array[this_$iv.ofs + 1], this_$iv.array[this_$iv.ofs + 2]);
    }

    public Quat(@NotNull InputStream inputStream, boolean bigEndian) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian));
    }

    public /* synthetic */ Quat(InputStream inputStream, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(inputStream, bl);
    }

    private Quat(final long ptr) {
        this((Function1<? super Integer, Float>)((Function1)new Function1<Integer, Float>(){

            @NotNull
            public final Float invoke(int i) {
                long arg0$iv = ptr;
                boolean bl = false;
                return Float.valueOf(PointersKt.getUNSAFE().getFloat(null, arg0$iv + (long)(i * UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE))));
            }
        }));
    }

    @NotNull
    public final Mat3 to(@NotNull Mat3 res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.mat3_cast(this, res);
    }

    @NotNull
    public final Mat3 toMat3() {
        return GLM.INSTANCE.mat3_cast(this, new Mat3());
    }

    @NotNull
    public final Mat4 to(@NotNull Mat4 res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.mat4_cast(this, res);
    }

    @NotNull
    public final Mat4 toMat4() {
        return GLM.INSTANCE.mat4_cast(this, new Mat4());
    }

    public Quat(@NotNull QuatD q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        double $this$f$iv = q.w.doubleValue();
        boolean $i$f$getF = false;
        float f = (float)$this$f$iv;
        $this$f$iv = q.x.doubleValue();
        $i$f$getF = false;
        float f2 = (float)$this$f$iv;
        $this$f$iv = q.y.doubleValue();
        $i$f$getF = false;
        float f3 = (float)$this$f$iv;
        $this$f$iv = q.z.doubleValue();
        $i$f$getF = false;
        this(f, f2, f3, (float)$this$f$iv);
    }

    public Quat(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Number $this$f$iv = w;
        boolean $i$f$getF = false;
        float f = $this$f$iv.floatValue();
        $this$f$iv = x;
        $i$f$getF = false;
        float f2 = $this$f$iv.floatValue();
        $this$f$iv = y;
        $i$f$getF = false;
        float f3 = $this$f$iv.floatValue();
        $this$f$iv = z;
        $i$f$getF = false;
        this(f, f2, f3, $this$f$iv.floatValue());
    }

    public Quat(@NotNull Vec4t<?> vec4) {
        Intrinsics.checkNotNullParameter(vec4, (String)"vec4");
        Object $this$f$iv = vec4.get_w();
        boolean $i$f$getF = false;
        float f = ((Number)$this$f$iv).floatValue();
        $this$f$iv = vec4.get_x();
        $i$f$getF = false;
        float f2 = ((Number)$this$f$iv).floatValue();
        $this$f$iv = vec4.get_y();
        $i$f$getF = false;
        float f3 = ((Number)$this$f$iv).floatValue();
        $this$f$iv = vec4.get_z();
        $i$f$getF = false;
        this(f, f2, f3, ((Number)$this$f$iv).floatValue());
    }

    @NotNull
    public final Quat put(float w, float x, float y, float z) {
        this.w = Float.valueOf(w);
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.z = Float.valueOf(z);
        return this;
    }

    @NotNull
    public final Quat put(@NotNull Quat quat) {
        Intrinsics.checkNotNullParameter((Object)quat, (String)"quat");
        return this.put(quat.w.floatValue(), quat.x.floatValue(), quat.y.floatValue(), quat.z.floatValue());
    }

    public final void to(long ptr) {
        MemoryUtil.memPutFloat((long)ptr, (float)this.w.floatValue());
        MemoryUtil.memPutFloat((long)(ptr + (long)UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE)), (float)this.x.floatValue());
        MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE) * 2)), (float)this.y.floatValue());
        MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE) * 3)), (float)this.z.floatValue());
    }

    @Override
    public void set(int index, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (index) {
            case 0: {
                Number $this$f$iv = value;
                boolean $i$f$getF = false;
                this.x = Float.valueOf($this$f$iv.floatValue());
                break;
            }
            case 1: {
                Number $this$f$iv = value;
                boolean $i$f$getF = false;
                this.y = Float.valueOf($this$f$iv.floatValue());
                break;
            }
            case 2: {
                Number $this$f$iv = value;
                boolean $i$f$getF = false;
                this.z = Float.valueOf($this$f$iv.floatValue());
                break;
            }
            case 3: {
                Number $this$f$iv = value;
                boolean $i$f$getF = false;
                this.w = Float.valueOf($this$f$iv.floatValue());
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final Quat unaryPlus() {
        return this;
    }

    @NotNull
    public final Quat unaryMinus() {
        return new Quat(-this.w.floatValue(), -this.x.floatValue(), -this.y.floatValue(), -this.z.floatValue());
    }

    @NotNull
    public final Quat plus(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.plus(new Quat(), this, b);
    }

    @NotNull
    public final Quat plus(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.plus(res, this, b);
    }

    public final void plusAssign(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.plus(this, this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.minus(new Quat(), this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.minus(res, this, b);
    }

    public final void minusAssign(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.minus(this, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(float b) {
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Vec3(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Quat times(float b, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b, @NotNull Vec3 res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.times(res, this, b);
    }

    public final void timesAssign(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(this, this, b);
    }

    public final void timesAssign(float b) {
        Companion.times(this, this, b);
    }

    public final void timesAssign(@NotNull Vec3 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(b, this, b);
    }

    public final void timesAssign(@NotNull Vec4 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(this, this, b);
    }

    @NotNull
    public final Quat div(float b) {
        return Companion.div(new Quat(), this, b);
    }

    @NotNull
    public final Quat div(float b, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return Companion.div(res, this, b);
    }

    public final void divAssign(float b) {
        Companion.div(this, this, b);
    }

    public final float length() {
        return GLM.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize(@NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.normalize(this, res);
    }

    public static /* synthetic */ Quat normalize$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.normalize(quat2);
    }

    @NotNull
    public final Quat normalizeAssign() {
        return GLM.INSTANCE.normalize(this, this);
    }

    public final float dot(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return GLM.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.angleAxis(angle, axis, res);
    }

    public static /* synthetic */ Quat angleAxis$default(Quat quat, float f, Vec3 vec3, Quat quat2, int n, Object object) {
        if ((n & 4) != 0) {
            quat2 = new Quat();
        }
        return quat.angleAxis(f, vec3, quat2);
    }

    @NotNull
    public final Quat angleAxisAssign(float angle, @NotNull Vec3 axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return GLM.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate(@NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.conjugate(this, res);
    }

    public static /* synthetic */ Quat conjugate$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.conjugate(quat2);
    }

    @NotNull
    public final Quat conjugateAssign() {
        return GLM.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse(@NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.inverse(this, res);
    }

    public static /* synthetic */ Quat inverse$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.inverse(quat2);
    }

    @NotNull
    public final Quat inverseAssign() {
        return GLM.INSTANCE.inverse(this, this);
    }

    public final float angle() {
        return GLM.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles(@NotNull Vec3 res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.eulerAngles(this, res);
    }

    public static /* synthetic */ Vec3 eulerAngles$default(Quat quat, Vec3 vec3, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = new Vec3();
        }
        return quat.eulerAngles(vec3);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp, @NotNull Quat res) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        return GLM.INSTANCE.slerp(this, b, interp, res);
    }

    public static /* synthetic */ Quat slerp$default(Quat quat, Quat quat2, float f, Quat quat3, int n, Object object) {
        if ((n & 4) != 0) {
            quat3 = new Quat();
        }
        return quat.slerp(quat2, f, quat3);
    }

    @NotNull
    public final Quat slerpAssign(@NotNull Quat b, float interp) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return GLM.INSTANCE.slerp(this, b, interp, this);
    }

    @JvmOverloads
    public final void vectorize(@NotNull Vec4 res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        res.put(this.x.floatValue(), this.y.floatValue(), this.z.floatValue(), this.w.floatValue());
    }

    public static /* synthetic */ void vectorize$default(Quat quat, Vec4 vec4, int n, Object object) {
        if ((n & 1) != 0) {
            vec4 = new Vec4();
        }
        quat.vectorize(vec4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object t;
        Object t2;
        Object t3;
        Object t4;
        Object t5;
        Object t6;
        Object t7;
        Object t8;
        QuatT this_$iv;
        if (!(other instanceof Quat)) return false;
        QuatT quatT = this;
        int index$iv = 0;
        boolean $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t8 = this_$iv.x;
                break;
            }
            case 1: {
                t8 = this_$iv.y;
                break;
            }
            case 2: {
                t8 = this_$iv.z;
                break;
            }
            case 3: {
                t8 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        float f = ((Number)t8).floatValue();
        this_$iv = (QuatT)other;
        index$iv = 0;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t7 = this_$iv.x;
                break;
            }
            case 1: {
                t7 = this_$iv.y;
                break;
            }
            case 2: {
                t7 = this_$iv.z;
                break;
            }
            case 3: {
                t7 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (f != ((Number)t7).floatValue()) return false;
        boolean bl = true;
        if (!bl) return false;
        this_$iv = this;
        index$iv = 1;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t6 = this_$iv.x;
                break;
            }
            case 1: {
                t6 = this_$iv.y;
                break;
            }
            case 2: {
                t6 = this_$iv.z;
                break;
            }
            case 3: {
                t6 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        float f2 = ((Number)t6).floatValue();
        this_$iv = (QuatT)other;
        index$iv = 1;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t5 = this_$iv.x;
                break;
            }
            case 1: {
                t5 = this_$iv.y;
                break;
            }
            case 2: {
                t5 = this_$iv.z;
                break;
            }
            case 3: {
                t5 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (f2 != ((Number)t5).floatValue()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        this_$iv = this;
        index$iv = 2;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t4 = this_$iv.x;
                break;
            }
            case 1: {
                t4 = this_$iv.y;
                break;
            }
            case 2: {
                t4 = this_$iv.z;
                break;
            }
            case 3: {
                t4 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        float f3 = ((Number)t4).floatValue();
        this_$iv = (QuatT)other;
        index$iv = 2;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t3 = this_$iv.x;
                break;
            }
            case 1: {
                t3 = this_$iv.y;
                break;
            }
            case 2: {
                t3 = this_$iv.z;
                break;
            }
            case 3: {
                t3 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (f3 != ((Number)t3).floatValue()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        this_$iv = this;
        index$iv = 3;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t2 = this_$iv.x;
                break;
            }
            case 1: {
                t2 = this_$iv.y;
                break;
            }
            case 2: {
                t2 = this_$iv.z;
                break;
            }
            case 3: {
                t2 = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        float f4 = ((Number)t2).floatValue();
        this_$iv = (QuatT)other;
        index$iv = 3;
        $i$f$get = false;
        switch (index$iv) {
            case 0: {
                t = this_$iv.x;
                break;
            }
            case 1: {
                t = this_$iv.y;
                break;
            }
            case 2: {
                t = this_$iv.z;
                break;
            }
            case 3: {
                t = this_$iv.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        if (f4 != ((Number)t).floatValue()) return false;
        return true;
    }

    public int hashCode() {
        return 31 * (31 * (31 * Float.hashCode(this.w.floatValue()) + Float.hashCode(this.x.floatValue())) + Float.hashCode(this.y.floatValue())) + Float.hashCode(this.z.floatValue());
    }

    @JvmOverloads
    public final void print(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.print(name + this);
    }

    public static /* synthetic */ void print$default(Quat quat, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            printStream = System.out;
        }
        quat.print(string, printStream);
    }

    @JvmOverloads
    public final void println(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.println(name + this);
    }

    public static /* synthetic */ void println$default(Quat quat, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            printStream = System.out;
        }
        quat.println(string, printStream);
    }

    @NotNull
    public String toString() {
        return "(" + this.w + ", {" + this.x + ", " + this.y + ", " + this.z + "})";
    }

    public final boolean allEqual(@NotNull Quat q, float epsilon) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.floatValue() - q.x.floatValue() < epsilon && this.y.floatValue() - q.y.floatValue() < epsilon && this.z.floatValue() - q.z.floatValue() < epsilon && this.w.floatValue() - q.w.floatValue() < epsilon;
    }

    public static /* synthetic */ boolean allEqual$default(Quat quat, Quat quat2, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = GLM.INSTANCE.get\u03b5f();
        }
        return quat.allEqual(quat2, f);
    }

    public final boolean anyNotEqual(@NotNull Quat q, float epsilon) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.floatValue() - q.x.floatValue() >= epsilon || this.y.floatValue() - q.y.floatValue() >= epsilon || this.z.floatValue() - q.z.floatValue() >= epsilon || this.w.floatValue() - q.w.floatValue() >= epsilon;
    }

    public static /* synthetic */ boolean anyNotEqual$default(Quat quat, Quat quat2, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = GLM.INSTANCE.get\u03b5f();
        }
        return quat.anyNotEqual(quat2, f);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize() {
        return Quat.normalize$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return Quat.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate() {
        return Quat.conjugate$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse() {
        return Quat.inverse$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles() {
        return Quat.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Quat.slerp$default(this, b, interp, null, 4, null);
    }

    @JvmOverloads
    public final void vectorize() {
        Quat.vectorize$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void print(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Quat.print$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void print() {
        Quat.print$default(this, null, null, 3, null);
    }

    @JvmOverloads
    public final void println(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Quat.println$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void println() {
        Quat.println$default(this, null, null, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final Quat fromPointer(long ptr) {
        return Companion.fromPointer(ptr);
    }

    public /* synthetic */ Quat(long ptr, DefaultConstructorMarker $constructor_marker) {
        this(ptr);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\tj\u0002`\bH\u0007\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/bixilon/kotlinglm/quaternion/Quat$Companion;", "Lde/bixilon/kotlinglm/quaternion/op_Quat;", "Lde/bixilon/kotlinglm/gtc/gtc_Quaternion;", "<init>", "()V", "fromPointer", "Lde/bixilon/kotlinglm/quaternion/Quat;", "ptr", "Lde/bixilon/kotlinkool/Ptr;", "", "(J)Lde/bixilon/kotlinglm/quaternion/Quat;", "identity", "getIdentity", "()Lde/bixilon/kotlinglm/quaternion/Quat;", "length", "", "size", "glm"})
    public static final class Companion
    implements op_Quat,
    gtc_Quaternion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Quat fromPointer(long ptr) {
            return new Quat(MemoryUtil.memGetFloat((long)ptr), MemoryUtil.memGetFloat((long)(ptr + (long)UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE))), MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE) * 2))), MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES((FloatCompanionObject)FloatCompanionObject.INSTANCE) * 3))));
        }

        @NotNull
        public final Quat getIdentity() {
            return new Quat(1.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        @NotNull
        public Quat plus(@NotNull Quat res, @NotNull Quat a, @NotNull Quat b) {
            return op_Quat.DefaultImpls.plus(this, res, a, b);
        }

        @Override
        @NotNull
        public Quat minus(@NotNull Quat res, @NotNull Quat a, @NotNull Quat b) {
            return op_Quat.DefaultImpls.minus(this, res, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a, @NotNull Quat b) {
            return op_Quat.DefaultImpls.times((op_Quat)this, res, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a, float b) {
            return op_Quat.DefaultImpls.times((op_Quat)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull Quat a, @NotNull Vec3 b) {
            return op_Quat.DefaultImpls.times((op_Quat)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull Vec3 a, @NotNull Quat b) {
            return op_Quat.DefaultImpls.times((op_Quat)this, res, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a, @NotNull Vec4 b) {
            return op_Quat.DefaultImpls.times((op_Quat)this, res, a, b);
        }

        @Override
        @NotNull
        public Quat div(@NotNull Quat res, @NotNull Quat a, float b) {
            return op_Quat.DefaultImpls.div(this, res, a, b);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res) {
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            return gtc_Quaternion.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res) {
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res, @NotNull QuatD q) {
            return gtc_Quaternion.DefaultImpls.mat4d_cast(this, res, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res) {
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res) {
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.greater(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.greater(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.equal(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.equal(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b) {
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.isNan(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res) {
            return gtc_Quaternion.DefaultImpls.isInf(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            return gtc_Quaternion.DefaultImpls.isInf(this, q);
        }

        @Override
        @NotNull
        public Quat quatLookAt(@NotNull Vec3 direction, @NotNull Vec3 up) {
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAt(@NotNull Vec3d direction, @NotNull Vec3d up) {
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtRH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtRH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtLH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtLH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

