/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kotlinglm.ext;

import de.bixilon.kotlinglm.GLM;
import de.bixilon.kotlinglm.func.Func_TrigonometricKt;
import de.bixilon.kotlinglm.quaternion.Quat;
import de.bixilon.kotlinglm.quaternion.QuatD;
import de.bixilon.kotlinglm.vec3.Vec3;
import de.bixilon.kotlinglm.vec3.Vec3d;
import de.bixilon.kotlinglm.vec3.operators.Op_Vec3Kt;
import de.bixilon.kotlinglm.vec3.operators.Op_Vec3dKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lde/bixilon/kotlinglm/ext/ext_QuaternionExponential;", "", "exp", "Lde/bixilon/kotlinglm/quaternion/Quat;", "q", "Lde/bixilon/kotlinglm/quaternion/QuatD;", "log", "pow", "x", "y", "", "", "sqrt", "glm"})
public interface ext_QuaternionExponential {
    @NotNull
    public Quat exp(@NotNull Quat var1);

    @NotNull
    public Quat log(@NotNull Quat var1);

    @NotNull
    public Quat pow(@NotNull Quat var1, float var2);

    @NotNull
    public Quat sqrt(@NotNull Quat var1);

    @NotNull
    public QuatD exp(@NotNull QuatD var1);

    @NotNull
    public QuatD log(@NotNull QuatD var1);

    @NotNull
    public QuatD pow(@NotNull QuatD var1, double var2);

    @NotNull
    public QuatD sqrt(@NotNull QuatD var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=82)
    public static final class DefaultImpls {
        @NotNull
        public static Quat exp(@NotNull ext_QuaternionExponential $this, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3 u = new Vec3(q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
            float angle = u.length();
            if (angle < GLM.INSTANCE.get\u03b5f()) {
                return new Quat();
            }
            Vec3 v = u.div(angle);
            return new Quat(Func_TrigonometricKt.getCos(angle), Op_Vec3Kt.times(Func_TrigonometricKt.getSin(angle), v));
        }

        @NotNull
        public static Quat log(@NotNull ext_QuaternionExponential $this, @NotNull Quat q) {
            Quat quat;
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3 u = new Vec3(q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
            float vec3Len = u.length();
            if (vec3Len < GLM.INSTANCE.get\u03b5f()) {
                quat = q.w.floatValue() > 0.0f ? new Quat(GLM.INSTANCE.log(q.w.floatValue()), 0.0f, 0.0f, 0.0f) : (q.w.floatValue() < 0.0f ? new Quat(GLM.INSTANCE.log(-q.w.floatValue()), GLM.INSTANCE.get\u03c0f(), 0.0f, 0.0f) : new Quat(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
            } else {
                float t = GLM.INSTANCE.atan(vec3Len, q.w.floatValue()) / vec3Len;
                float quatLen2 = vec3Len * vec3Len + q.w.floatValue() * q.w.floatValue();
                quat = new Quat(0.5f * GLM.INSTANCE.log(quatLen2), t * q.x.floatValue(), t * q.y.floatValue(), t * q.z.floatValue());
            }
            return quat;
        }

        @NotNull
        public static Quat pow(@NotNull ext_QuaternionExponential $this, @NotNull Quat x, float y) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (y > -GLM.INSTANCE.get\u03b5f() && y < GLM.INSTANCE.get\u03b5f()) {
                return new Quat(1.0f, 0.0f, 0.0f, 0.0f);
            }
            float magnitude = (float)Math.sqrt(x.x.floatValue() * x.x.floatValue() + x.y.floatValue() * x.y.floatValue() + x.z.floatValue() * x.z.floatValue() + x.w.floatValue() * x.w.floatValue());
            if (Math.abs(x.w.floatValue() / magnitude) > 1.0f - GLM.INSTANCE.get\u03b5f() && Math.abs(x.w.floatValue() / magnitude) < 1.0f + GLM.INSTANCE.get\u03b5f()) {
                return new Quat(GLM.INSTANCE.pow(x.w.floatValue(), y), 0.0f, 0.0f, 0.0f);
            }
            float angle = (float)Math.acos(x.w.floatValue() / magnitude);
            float newAngle = angle * y;
            float div = (float)Math.sin(newAngle) / (float)Math.sin(angle);
            float mag = GLM.INSTANCE.pow(magnitude, y - 1.0f);
            return new Quat((float)Math.cos(newAngle) * magnitude * mag, x.x.floatValue() * div * mag, x.y.floatValue() * div * mag, x.z.floatValue() * div * mag);
        }

        @NotNull
        public static Quat sqrt(@NotNull ext_QuaternionExponential $this, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return $this.pow(q, 0.5f);
        }

        @NotNull
        public static QuatD exp(@NotNull ext_QuaternionExponential $this, @NotNull QuatD q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3d u = new Vec3d(q.x.doubleValue(), q.y.doubleValue(), q.z.doubleValue());
            double angle = u.length();
            if (angle < GLM.INSTANCE.get\u03b5()) {
                return new QuatD();
            }
            Vec3d v = u.div(angle);
            return new QuatD(Func_TrigonometricKt.getCos(angle), Op_Vec3dKt.times(Func_TrigonometricKt.getSin(angle), v));
        }

        @NotNull
        public static QuatD log(@NotNull ext_QuaternionExponential $this, @NotNull QuatD q) {
            QuatD quatD;
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3d u = new Vec3d(q.x.doubleValue(), q.y.doubleValue(), q.z.doubleValue());
            double vec3Len = u.length();
            if (vec3Len < GLM.INSTANCE.get\u03b5()) {
                quatD = q.w.doubleValue() > 0.0 ? new QuatD(GLM.INSTANCE.log(q.w.doubleValue()), 0.0, 0.0, 0.0) : (q.w.doubleValue() < 0.0 ? new QuatD(GLM.INSTANCE.log(-q.w.doubleValue()), GLM.INSTANCE.get\u03c0(), 0.0, 0.0) : new QuatD(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            } else {
                double t = GLM.INSTANCE.atan(vec3Len, q.w.doubleValue()) / vec3Len;
                double quatLen2 = vec3Len * vec3Len + q.w.doubleValue() * q.w.doubleValue();
                quatD = new QuatD(0.5 * GLM.INSTANCE.log(quatLen2), t * q.x.doubleValue(), t * q.y.doubleValue(), t * q.z.doubleValue());
            }
            return quatD;
        }

        @NotNull
        public static QuatD pow(@NotNull ext_QuaternionExponential $this, @NotNull QuatD x, double y) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (y > -GLM.INSTANCE.get\u03b5() && y < GLM.INSTANCE.get\u03b5()) {
                return new QuatD(1.0, 0.0, 0.0, 0.0);
            }
            double magnitude = Math.sqrt(x.x.doubleValue() * x.x.doubleValue() + x.y.doubleValue() * x.y.doubleValue() + x.z.doubleValue() * x.z.doubleValue() + x.w.doubleValue() * x.w.doubleValue());
            if (Math.abs(x.w.doubleValue() / magnitude) > (double)1.0f - GLM.INSTANCE.get\u03b5() && Math.abs(x.w.doubleValue() / magnitude) < 1.0 + GLM.INSTANCE.get\u03b5()) {
                return new QuatD(GLM.INSTANCE.pow(x.w.doubleValue(), y), 0.0, 0.0, 0.0);
            }
            double angle = Math.acos(x.w.doubleValue() / magnitude);
            double newAngle = angle * y;
            double div = Math.sin(newAngle) / Math.sin(angle);
            double mag = GLM.INSTANCE.pow(magnitude, y - 1.0);
            return new QuatD(Math.cos(newAngle) * magnitude * mag, x.x.doubleValue() * div * mag, x.y.doubleValue() * div * mag, x.z.doubleValue() * div * mag);
        }

        @NotNull
        public static QuatD sqrt(@NotNull ext_QuaternionExponential $this, @NotNull QuatD q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return $this.pow(q, 0.5);
        }
    }
}

