/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kotlinglm.ext;

import de.bixilon.kotlinglm.GLM;
import de.bixilon.kotlinglm.quaternion.Quat;
import de.bixilon.kotlinglm.quaternion.QuatD;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0096\u0004J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0011\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006H\u0096\u0004J\u0018\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0011\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0096\u0004J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0011\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006H\u0096\u0004J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J \u0010\b\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\fH\u0016J(\u0010\b\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\fH\u0016J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lde/bixilon/kotlinglm/ext/ext_QuaternionCommon;", "", "conjugate", "Lde/bixilon/kotlinglm/quaternion/Quat;", "a", "res", "Lde/bixilon/kotlinglm/quaternion/QuatD;", "inverse", "lerp", "b", "interp", "", "", "mix", "slerp", "glm"})
public interface ext_QuaternionCommon {
    @NotNull
    public Quat mix(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat mix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD mix(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD mix(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat lerp(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat lerp(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD lerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD lerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat slerp(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat slerp(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD slerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD slerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat conjugate(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat conjugate(@NotNull Quat var1);

    @NotNull
    public QuatD conjugate(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD conjugate(@NotNull QuatD var1);

    @NotNull
    public Quat inverse(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat inverse(@NotNull Quat var1);

    @NotNull
    public QuatD inverse(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD inverse(@NotNull QuatD var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=82)
    public static final class DefaultImpls {
        @NotNull
        public static Quat mix(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            float cosTheta = GLM.INSTANCE.dot(a, b);
            if (cosTheta > 1.0f - GLM.epsilonF) {
                res.w = Float.valueOf(GLM.INSTANCE.mix(a.w.floatValue(), b.w.floatValue(), interp));
                res.x = Float.valueOf(GLM.INSTANCE.mix(a.x.floatValue(), b.x.floatValue(), interp));
                res.y = Float.valueOf(GLM.INSTANCE.mix(a.y.floatValue(), b.y.floatValue(), interp));
                res.z = Float.valueOf(GLM.INSTANCE.mix(a.z.floatValue(), b.z.floatValue(), interp));
                return res;
            }
            float angle = GLM.INSTANCE.acos(cosTheta);
            float s0 = GLM.INSTANCE.sin((1.0f - interp) * angle);
            float s1 = GLM.INSTANCE.sin(interp * angle);
            float s2 = GLM.INSTANCE.sin(angle);
            res.w = Float.valueOf((s0 * a.w.floatValue() + s1 * b.w.floatValue()) / s2);
            res.x = Float.valueOf((s0 * a.x.floatValue() + s1 * b.x.floatValue()) / s2);
            res.y = Float.valueOf((s0 * a.y.floatValue() + s1 * b.y.floatValue()) / s2);
            res.z = Float.valueOf((s0 * a.z.floatValue() + s1 * b.z.floatValue()) / s2);
            return res;
        }

        @NotNull
        public static Quat mix(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return $this.mix(a, b, interp, new Quat());
        }

        @NotNull
        public static QuatD mix(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            double cosTheta = GLM.INSTANCE.dot(a, b);
            if (cosTheta > 1.0 - GLM.epsilon) {
                res.w = GLM.INSTANCE.mix(a.w.doubleValue(), b.w.doubleValue(), interp);
                res.x = GLM.INSTANCE.mix(a.x.doubleValue(), b.x.doubleValue(), interp);
                res.y = GLM.INSTANCE.mix(a.y.doubleValue(), b.y.doubleValue(), interp);
                res.z = GLM.INSTANCE.mix(a.z.doubleValue(), b.z.doubleValue(), interp);
                return res;
            }
            double angle = GLM.INSTANCE.acos(cosTheta);
            double s0 = GLM.INSTANCE.sin((1.0 - interp) * angle);
            double s1 = GLM.INSTANCE.sin(interp * angle);
            double s2 = GLM.INSTANCE.sin(angle);
            res.w = (s0 * a.w.doubleValue() + s1 * b.w.doubleValue()) / s2;
            res.x = (s0 * a.x.doubleValue() + s1 * b.x.doubleValue()) / s2;
            res.y = (s0 * a.y.doubleValue() + s1 * b.y.doubleValue()) / s2;
            res.z = (s0 * a.z.doubleValue() + s1 * b.z.doubleValue()) / s2;
            return res;
        }

        @NotNull
        public static QuatD mix(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return $this.mix(a, b, interp, new QuatD());
        }

        @NotNull
        public static Quat lerp(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            if (interp < 0.0f || interp > 1.0f) {
                throw new ArithmeticException("interp outside [0, 1]");
            }
            res.w = Float.valueOf(a.w.floatValue() * (1.0f - interp) + b.w.floatValue() * interp);
            res.x = Float.valueOf(a.x.floatValue() * (1.0f - interp) + b.x.floatValue() * interp);
            res.y = Float.valueOf(a.y.floatValue() * (1.0f - interp) + b.y.floatValue() * interp);
            res.z = Float.valueOf(a.z.floatValue() * (1.0f - interp) + b.z.floatValue() * interp);
            return res;
        }

        @NotNull
        public static Quat lerp(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return $this.lerp(a, b, interp, new Quat());
        }

        @NotNull
        public static QuatD lerp(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            if (interp < 0.0 || interp > 1.0) {
                throw new ArithmeticException("interp outside [0, 1]");
            }
            res.w = a.w.doubleValue() * (1.0 - interp) + b.w.doubleValue() * interp;
            res.x = a.x.doubleValue() * (1.0 - interp) + b.x.doubleValue() * interp;
            res.y = a.y.doubleValue() * (1.0 - interp) + b.y.doubleValue() * interp;
            res.z = a.z.doubleValue() * (1.0 - interp) + b.z.doubleValue() * interp;
            return res;
        }

        @NotNull
        public static QuatD lerp(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return $this.lerp(a, b, interp, new QuatD());
        }

        @NotNull
        public static Quat slerp(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            float zW = b.w.floatValue();
            float zX = b.x.floatValue();
            float zY = b.y.floatValue();
            float zZ = b.z.floatValue();
            float cosTheta = GLM.INSTANCE.dot(a, b);
            if (cosTheta < 0.0f) {
                zW = -b.w.floatValue();
                zX = -b.x.floatValue();
                zY = -b.y.floatValue();
                zZ = -b.z.floatValue();
                cosTheta = -cosTheta;
            }
            if (cosTheta > 1.0f - GLM.INSTANCE.get_epsilonF()) {
                res.w = Float.valueOf(GLM.INSTANCE.mix(a.w.floatValue(), zW, interp));
                res.x = Float.valueOf(GLM.INSTANCE.mix(a.x.floatValue(), zX, interp));
                res.y = Float.valueOf(GLM.INSTANCE.mix(a.y.floatValue(), zY, interp));
                res.z = Float.valueOf(GLM.INSTANCE.mix(a.z.floatValue(), zZ, interp));
                return res;
            }
            float angle = GLM.INSTANCE.acos(cosTheta);
            float s0 = GLM.INSTANCE.sin((1.0f - interp) * angle);
            float s1 = GLM.INSTANCE.sin(interp * angle);
            float s2 = GLM.INSTANCE.sin(angle);
            res.w = Float.valueOf((s0 * a.w.floatValue() + s1 * zW) / s2);
            res.x = Float.valueOf((s0 * a.x.floatValue() + s1 * zX) / s2);
            res.y = Float.valueOf((s0 * a.y.floatValue() + s1 * zY) / s2);
            res.z = Float.valueOf((s0 * a.z.floatValue() + s1 * zZ) / s2);
            return res;
        }

        @NotNull
        public static Quat slerp(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return $this.slerp(a, b, interp, new Quat());
        }

        @NotNull
        public static QuatD slerp(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            double zW = b.w.doubleValue();
            double zX = b.x.doubleValue();
            double zY = b.y.doubleValue();
            double zZ = b.z.doubleValue();
            double cosTheta = GLM.INSTANCE.dot(a, b);
            if (cosTheta < 0.0) {
                zW = -b.w.doubleValue();
                zX = -b.x.doubleValue();
                zY = -b.y.doubleValue();
                zZ = -b.z.doubleValue();
                cosTheta = -cosTheta;
            }
            if (cosTheta > 1.0 - GLM.epsilon) {
                res.w = GLM.INSTANCE.mix(a.w.doubleValue(), zW, interp);
                res.x = GLM.INSTANCE.mix(a.x.doubleValue(), zX, interp);
                res.y = GLM.INSTANCE.mix(a.y.doubleValue(), zY, interp);
                res.z = GLM.INSTANCE.mix(a.z.doubleValue(), zZ, interp);
                return res;
            }
            double angle = GLM.INSTANCE.acos(cosTheta);
            double s0 = GLM.INSTANCE.sin((1.0 - interp) * angle);
            double s1 = GLM.INSTANCE.sin(interp * angle);
            double s2 = GLM.INSTANCE.sin(angle);
            res.w = (s0 * a.w.doubleValue() + s1 * b.w.doubleValue()) / s2;
            res.x = (s0 * a.x.doubleValue() + s1 * b.x.doubleValue()) / s2;
            res.y = (s0 * a.y.doubleValue() + s1 * b.y.doubleValue()) / s2;
            res.z = (s0 * a.z.doubleValue() + s1 * b.z.doubleValue()) / s2;
            return res;
        }

        @NotNull
        public static QuatD slerp(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return $this.slerp(a, b, interp, new QuatD());
        }

        @NotNull
        public static Quat conjugate(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            res.w = a.w;
            res.x = Float.valueOf(-a.x.floatValue());
            res.y = Float.valueOf(-a.y.floatValue());
            res.z = Float.valueOf(-a.z.floatValue());
            return res;
        }

        @NotNull
        public static Quat conjugate(@NotNull ext_QuaternionCommon $this, @NotNull Quat a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return $this.conjugate(a, new Quat());
        }

        @NotNull
        public static QuatD conjugate(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            res.w = a.w;
            res.x = -a.x.doubleValue();
            res.y = -a.y.doubleValue();
            res.z = -a.z.doubleValue();
            return res;
        }

        @NotNull
        public static QuatD conjugate(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return $this.conjugate(a, new QuatD());
        }

        @NotNull
        public static Quat inverse(@NotNull ext_QuaternionCommon $this, @NotNull Quat a, @NotNull Quat res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            float dot = GLM.INSTANCE.dot(a, a);
            res.w = Float.valueOf(a.w.floatValue() / dot);
            res.x = Float.valueOf(-a.x.floatValue() / dot);
            res.y = Float.valueOf(-a.y.floatValue() / dot);
            res.z = Float.valueOf(-a.z.floatValue() / dot);
            return res;
        }

        @NotNull
        public static Quat inverse(@NotNull ext_QuaternionCommon $this, @NotNull Quat a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return $this.inverse(a, new Quat());
        }

        @NotNull
        public static QuatD inverse(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a, @NotNull QuatD res) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            double dot = GLM.INSTANCE.dot(a, a);
            res.w = a.w.doubleValue() / dot;
            res.x = -a.x.doubleValue() / dot;
            res.y = -a.y.doubleValue() / dot;
            res.z = -a.z.doubleValue() / dot;
            return res;
        }

        @NotNull
        public static QuatD inverse(@NotNull ext_QuaternionCommon $this, @NotNull QuatD a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return $this.inverse(a, new QuatD());
        }
    }
}

