/*
 * Jiibles
 * Copyright (C) 2022 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.jiibles

object JiiblesUtil {
    private val ANSI_REGEX = "\\x1b\\[[\\d;]*m".toRegex()
    const val EMPTY_STRING = ""
    const val NULL_STRING = "null"
    const val NEW_LINE = '\n'

    fun String.removeAnsi(): String {
        if (ANSI_REGEX.find(this) == null) {
            return this
        }
        return ANSI_REGEX.replace(this, "")
    }

    fun AnyLine.cache(hideNull: Boolean): StringLine {
        return Array(this.size) { this[it].convertToString(hideNull) }
    }

    fun getSeparatorLine(widths: IntArray, separator: Char): String {
        var totalWidth = 0
        for (width in widths) {
            totalWidth += width + 2 // 2 spaces
        }
        totalWidth += widths.size + 1 // 1 final row

        return separator.toString().repeat(totalWidth)
    }


    private fun AnyString.convertToString(hideNull: Boolean): String {
        if (this == null) {
            if (hideNull) {
                return EMPTY_STRING
            }
            return NULL_STRING
        }
        return this.toString()
    }
}
