/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.elternportal;

import de.bixilon.elternportal.ElternPortalLoginFormular;
import de.bixilon.elternportal.ElternPortalStates;
import de.bixilon.elternportal.ElternPortalUtil;
import de.bixilon.elternportal.login.InvalidCredentialsError;
import de.bixilon.elternportal.login.LoginError;
import de.bixilon.elternportal.login.UnknownLoginError;
import de.bixilon.elternportal.service.SchoolInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.select.Elements;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0013J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006 "}, d2={"Lde/bixilon/elternportal/ElternPortal;", "", "url", "", "sessionKey", "schoolName", "loginFormular", "Lde/bixilon/elternportal/ElternPortalLoginFormular;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/bixilon/elternportal/ElternPortalLoginFormular;)V", "hostname", "getSchoolName", "()Ljava/lang/String;", "<set-?>", "Lde/bixilon/elternportal/ElternPortalStates;", "state", "getState", "()Lde/bixilon/elternportal/ElternPortalStates;", "getUrl", "checkState", "", "fetch", "Lorg/jsoup/nodes/Document;", "fetchSchoolInfo", "Lde/bixilon/elternportal/service/SchoolInfo;", "login", "email", "password", "logout", "update", "response", "Lorg/jsoup/Connection$Response;", "Companion", "eltern-portal.org"})
public final class ElternPortal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private String sessionKey;
    @NotNull
    private final String schoolName;
    @NotNull
    private final ElternPortalLoginFormular loginFormular;
    @NotNull
    private final String hostname;
    @NotNull
    private ElternPortalStates state;
    @NotNull
    private static final String SESSION_COOKIE_NAME = "PHPSESSID";

    public ElternPortal(@NotNull String url, @NotNull String sessionKey, @NotNull String schoolName, @NotNull ElternPortalLoginFormular loginFormular) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)schoolName, (String)"schoolName");
        Intrinsics.checkNotNullParameter((Object)loginFormular, (String)"loginFormular");
        this.url = url;
        this.sessionKey = sessionKey;
        this.schoolName = schoolName;
        this.loginFormular = loginFormular;
        this.hostname = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)this.url, (CharSequence)"https://"), (CharSequence)"/");
        this.state = ElternPortalStates.QUERIED;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getSchoolName() {
        return this.schoolName;
    }

    @NotNull
    public final ElternPortalStates getState() {
        return this.state;
    }

    private final void checkState() {
        if (!(this.state == ElternPortalStates.LOGGED_IN)) {
            boolean bl = false;
            String string = "Not logged in!";
            throw new IllegalStateException(string.toString());
        }
    }

    private final Document fetch(String url) {
        this.checkState();
        Connection.Response response = Jsoup.connect((String)(this.url + url)).method(Connection.Method.GET).cookie(SESSION_COOKIE_NAME, this.sessionKey).followRedirects(true).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        this.update(response);
        Document document = response.parse();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"response.parse()");
        return document;
    }

    private final void update(Connection.Response response) {
        String string = response.cookie(SESSION_COOKIE_NAME);
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.sessionKey = it;
        }
    }

    public final void login(@NotNull String email, @NotNull String password) {
        List split;
        block6: {
            Map loginData;
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Map map = loginData = MapsKt.toMutableMap(this.loginFormular.getAdditionalFields());
            String string = this.loginFormular.getEmailFieldName();
            map.put(string, email);
            map = loginData;
            string = this.loginFormular.getPasswordFieldName();
            map.put(string, password);
            Connection.Response response = Jsoup.connect((String)(this.url + "/includes/project/auth/login.php")).data(loginData).method(Connection.Method.POST).cookie(SESSION_COOKIE_NAME, this.sessionKey).followRedirects(false).execute();
            if (response.statusCode() != 302) {
                throw new UnknownLoginError("Could not login (statusCode=" + response.statusCode() + ")");
            }
            String string2 = response.header("Location");
            if (string2 == null) {
                throw new LoginError("No Location header found!");
            }
            String redirect = string2;
            if (Intrinsics.areEqual((Object)redirect, (Object)("//" + this.hostname + "/start")) || Intrinsics.areEqual((Object)this.hostname, (Object)(this.url + "/start"))) {
                this.state = ElternPortalStates.LOGGED_IN;
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                this.update(response);
                return;
            }
            ElternPortal $this$login_u24lambda_u2d2 = this;
            boolean bl = false;
            Object object = new char[]{'?'};
            List data = StringsKt.split$default((CharSequence)redirect, (char[])object, (boolean)false, (int)0, (int)6, null);
            object = data.iterator();
            while (object.hasNext()) {
                char[] cArray;
                String entry = (String)object.next();
                split = StringsKt.split$default((CharSequence)entry, (char[])(cArray = new char[]{'='}), (boolean)false, (int)0, (int)6, null);
                String key = (String)split.get(1);
                if (!Intrinsics.areEqual((Object)key, (Object)"errorno")) {
                    continue;
                }
                break block6;
            }
            throw new UnknownLoginError(null, 1, null);
        }
        int errorId = Integer.parseInt((String)split.get(2));
        if (errorId == 1) {
            throw new InvalidCredentialsError(email);
        }
        String string = "Unknown error code: " + errorId;
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)string));
    }

    public final void logout() {
        this.fetch("/logout");
        this.sessionKey = "";
        this.state = ElternPortalStates.LOGGED_OUT;
    }

    @NotNull
    public final SchoolInfo fetchSchoolInfo() {
        Document document = this.fetch("/service/schulinformationen");
        Element element = document.getElementById("asam_content");
        Intrinsics.checkNotNull((Object)element);
        Elements elements = element.select("div[class=row m_bot]");
        String address = null;
        String phone = null;
        String fax = null;
        String email = null;
        String homepage = null;
        Map shortcodes = new LinkedHashMap();
        block14: for (Element element2 : elements) {
            int n;
            String value;
            String propertyName;
            block20: {
                Elements property = element2.getElementsByClass("hidden-sm");
                if (property.size() != 1) continue;
                propertyName = ((Element)property.get(0)).text();
                Elements valueElements = element2.getElementsByClass("col-md-6");
                if (valueElements.size() != 1) continue;
                value = ((Element)valueElements.get(0)).text();
                String string = propertyName;
                if (string == null) break block20;
                int n2 = -1;
                switch (string.hashCode()) {
                    case 529516687: {
                        if (string.equals("Adresse")) {
                            n2 = 1;
                        }
                        break;
                    }
                    case -420727794: {
                        if (string.equals("Homepage")) {
                            n2 = 2;
                        }
                        break;
                    }
                    case 2019360351: {
                        if (string.equals("E-Mail")) {
                            n2 = 3;
                        }
                        break;
                    }
                    case 70397: {
                        if (string.equals("Fax")) {
                            n2 = 4;
                        }
                        break;
                    }
                    case 235292859: {
                        if (string.equals("Telefon")) {
                            n2 = 5;
                        }
                        break;
                    }
                }
                switch (n2) {
                    case 1: {
                        address = value;
                        continue block14;
                    }
                    case 5: {
                        phone = value;
                        continue block14;
                    }
                    case 4: {
                        fax = value;
                        continue block14;
                    }
                    case 3: {
                        email = value;
                        continue block14;
                    }
                    case 2: {
                        homepage = value;
                        continue block14;
                    }
                }
            }
            boolean bl = 1 <= (n = propertyName.length()) ? n < 6 : false;
            if (!bl) continue;
            Intrinsics.checkNotNullExpressionValue((Object)propertyName, (String)"propertyName");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            shortcodes.put(propertyName, value);
        }
        return new SchoolInfo(address, phone, fax, email, homepage, MapsKt.toMap((Map)shortcodes));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/bixilon/elternportal/ElternPortal$Companion;", "", "()V", "SESSION_COOKIE_NAME", "", "createByURL", "Lde/bixilon/elternportal/ElternPortal;", "url", "getLoginFormularInfo", "Lde/bixilon/elternportal/ElternPortalLoginFormular;", "document", "Lorg/jsoup/nodes/Document;", "eltern-portal.org"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ElternPortalLoginFormular getLoginFormularInfo(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            FormElement formular = de.bixilon.elternportal.ElternPortal$Companion.getLoginFormularInfo$getLoginFormularElement(document);
            String actionURL = formular.attributes().get("action");
            String emailFieldName = null;
            String passwordFieldName = null;
            Map additionalFields = new LinkedHashMap();
            for (Connection.KeyVal field : formular.formData()) {
                CharSequence charSequence;
                String key = field.key();
                if (emailFieldName == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    charSequence = key;
                    if (new Regex("(input)?([uU]sername|([eE][\\-]?mail))").matches(charSequence)) {
                        emailFieldName = key;
                        continue;
                    }
                }
                if (passwordFieldName == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    charSequence = key;
                    if (new Regex("(input)?[pP]assword").matches(charSequence)) {
                        passwordFieldName = key;
                        continue;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String string = field.value();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.value()");
                additionalFields.put(key, string);
            }
            if (emailFieldName == null) {
                throw new IllegalStateException("Could not find email field!".toString());
            }
            if (passwordFieldName == null) {
                throw new IllegalStateException("Could not find password field!".toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)actionURL, (String)"actionURL");
            return new ElternPortalLoginFormular(actionURL, emailFieldName, passwordFieldName, MapsKt.toMap((Map)additionalFields));
        }

        @NotNull
        public final ElternPortal createByURL(@NotNull String url) {
            String string;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String realURL = ElternPortalUtil.INSTANCE.checkElternPortalURL(url);
            Connection.Response response = Jsoup.connect((String)realURL).method(Connection.Method.GET).execute();
            String string2 = response.cookie(ElternPortal.SESSION_COOKIE_NAME);
            if (string2 == null) {
                throw new IllegalStateException("Can not find session cookie!".toString());
            }
            String sessionKey = string2;
            Document document = response.parse();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            ElternPortalLoginFormular loginFormular = this.getLoginFormularInfo(document);
            Element element = document.getElementById("schule");
            if (element == null) {
                string = "Unknown school!";
            } else {
                string = element.text();
                if (string == null) {
                    string = "Unknown school!";
                }
            }
            String schoolName = string;
            return new ElternPortal(realURL, sessionKey, schoolName, loginFormular);
        }

        private static final FormElement getLoginFormularInfo$getLoginFormularElement(Document $document) {
            Set possibleElements = new LinkedHashSet();
            Elements elements = $document.getElementsByClass("form-signin");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"document.getElementsByClass(\"form-signin\")");
            Element element = (Element)CollectionsKt.getOrNull((List)((List)elements), (int)0);
            if (element != null) {
                Element it = element;
                boolean bl = false;
                ((Collection)possibleElements).add(it);
            }
            Elements it = $document.getElementsByTag("form");
            boolean bl = false;
            Collection collection = possibleElements;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)it));
            for (Element element2 : possibleElements) {
                if (!(element2 instanceof FormElement) || ((FormElement)element2).formData().size() < 3) continue;
                return (FormElement)element2;
            }
            throw new IllegalStateException("Can not find login formular. Is the URL correct?".toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

