/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.secon.http4s;

import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.effect.kernel.Async;
import de.bitmarck.bms.secon.fs2.CertLookup;
import de.bitmarck.bms.secon.fs2.DecryptVerify;
import de.bitmarck.bms.secon.fs2.DecryptVerify$;
import de.bitmarck.bms.secon.fs2.IdentityLookup;
import de.bitmarck.bms.secon.fs2.SignEncrypt;
import de.bitmarck.bms.secon.http4s.EntityMediaEncoder;
import de.bitmarck.bms.secon.http4s.SeconHeaders$SeconContentType$;
import de.bitmarck.bms.secon.http4s.SeconMessage$;
import de.bitmarck.bms.secon.http4s.SeconMetadata;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.EntityDecoder;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Media;
import org.http4s.Media$;
import org.http4s.MediaType$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusType$;
import org.typelevel.ci.CIString;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.NotGiven$;

public interface SeconMessage<F> {
    public static <F> EntityDecoder<F, SeconMessage<F>> entityDecoder(Async<F> async) {
        return SeconMessage$.MODULE$.entityDecoder(async);
    }

    public static <F> OptionT<F, SeconMessage<F>> fromOctetStreamRequest(Media<F> media, Async<F> async) {
        return SeconMessage$.MODULE$.fromOctetStreamRequest(media, async);
    }

    public static <F> EntityDecoder<F, SeconMessage<F>> seconMultipartDecoder(Async<F> async) {
        return SeconMessage$.MODULE$.seconMultipartDecoder(async);
    }

    public static <F> EntityMediaEncoder<F, SeconMessage<F>> seconMultipartEncoder(Async<F> async) {
        return SeconMessage$.MODULE$.seconMultipartEncoder(async);
    }

    public static <F> EntityDecoder<F, SeconMessage<F>> seconOctetStreamDecoder(Async<F> async) {
        return SeconMessage$.MODULE$.seconOctetStreamDecoder(async);
    }

    public static <F> EntityMediaEncoder<F, SeconMessage<F>> seconOctetStreamEncoder(Async<F> async) {
        return SeconMessage$.MODULE$.seconOctetStreamEncoder(async);
    }

    public SeconMetadata metadata();

    public Option<String> fileName();

    public Media<F> media();

    public EntityMediaEncoder<F, SeconMessage<F>> encoder();

    public static SeconMessage withMedia$(SeconMessage $this, Media media) {
        return $this.withMedia(media);
    }

    default public SeconMessage<F> withMedia(Media<F> media) {
        Media<F> _media = media;
        return new SeconMessage<F>(_media, this){
            private final Media _media$1;
            private final /* synthetic */ SeconMessage $outer;
            {
                this._media$1 = _media$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public SeconMetadata metadata() {
                return this.$outer.metadata();
            }

            public Option fileName() {
                return this.$outer.fileName();
            }

            public Media media() {
                return this._media$1;
            }

            public EntityMediaEncoder encoder() {
                return this.$outer.encoder();
            }
        };
    }

    public static SeconMessage signAndEncrypt$(SeconMessage $this, IdentityLookup identityLookup, CertLookup certLookup, boolean request, SignEncrypt signEncrypt) {
        return $this.signAndEncrypt(identityLookup, certLookup, request, signEncrypt);
    }

    default public SeconMessage<F> signAndEncrypt(IdentityLookup<F> identityLookup, CertLookup<F> certLookup, boolean request, SignEncrypt<F> signEncrypt) {
        return this.withMedia(Media$.MODULE$.apply(Stream$.MODULE$.eval(identityLookup.identityByAliasUnsafe(request ? this.metadata().sender() : this.metadata().empfaenger())).flatMap((Function1 & Serializable)identity -> this.media().body().through(signEncrypt.signAndEncrypt(identity, certLookup, request ? NonEmptyList$.MODULE$.one((Object)this.metadata().empfaenger()) : NonEmptyList$.MODULE$.one((Object)this.metadata().sender()))), NotGiven$.MODULE$.value()), Headers$.MODULE$.put$extension(Headers$.MODULE$.removePayloadHeaders$extension(this.media().headers()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.foldablesToRaw((Object)Headers$.MODULE$.get$extension(this.media().headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance())).map((Function1 & Serializable)_$2 -> SeconHeaders$SeconContentType$.MODULE$.apply((Content.minusType)_$2)), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, SeconHeaders$SeconContentType$.MODULE$.headerInstance())), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusType$.MODULE$.apply(MediaType$.MODULE$.application().octet$minusstream()), Content$minusType$.MODULE$.headerInstance())}))));
    }

    public static SeconMessage decryptAndVerify$(SeconMessage $this, IdentityLookup identityLookup, CertLookup certLookup, DecryptVerify decryptVerify) {
        return $this.decryptAndVerify(identityLookup, certLookup, decryptVerify);
    }

    default public SeconMessage<F> decryptAndVerify(IdentityLookup<F> identityLookup, CertLookup<F> certLookup, DecryptVerify<F> decryptVerify) {
        DecryptVerify decryptVerify2 = DecryptVerify$.MODULE$.apply(decryptVerify);
        return this.withMedia(Media$.MODULE$.apply(this.media().body().through(decryptVerify2.decryptAndVerify(identityLookup, certLookup, decryptVerify2.decryptAndVerify$default$3())), Headers$.MODULE$.transform$extension(Headers$.MODULE$.put$extension(Headers$.MODULE$.removePayloadHeaders$extension(this.media().headers()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.foldablesToRaw((Object)Headers$.MODULE$.get$extension(this.media().headers(), Header.Select$.MODULE$.singleHeaders(SeconHeaders$SeconContentType$.MODULE$.headerInstance())).map((Function1 & Serializable)_$3 -> _$3.contentType()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusType$.MODULE$.headerInstance()))})), (Function1 & Serializable)_$4 -> _$4.filterNot((Function1 & Serializable)_$5 -> {
            CIString cIString = _$5.name();
            CIString cIString2 = SeconHeaders$SeconContentType$.MODULE$.headerInstance().name();
            return !(cIString != null ? !cIString.equals(cIString2) : cIString2 != null);
        }))));
    }
}

