/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.secon.fs2;

import cats.Applicative;
import cats.Applicative$;
import cats.Functor;
import cats.Monad;
import cats.Monad$;
import cats.data.OptionT;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.std.Dispatcher;
import cats.kernel.Monoid;
import cats.package$;
import cats.syntax.package;
import de.bitmarck.bms.secon.fs2.CertLookup;
import de.bitmarck.bms.secon.fs2.CertLookup$;
import de.bitmarck.bms.secon.fs2.CertSelectors$;
import de.bitmarck.bms.secon.fs2.IdentityLookup;
import de.tk.opensource.secon.Directory;
import de.tk.opensource.secon.SECON;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Optional;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class CertLookup$ {
    public static final CertLookup$ MODULE$ = new CertLookup$();

    public <F> Monoid<CertLookup<F>> monoid(Monad<F> evidence$1) {
        return package$.MODULE$.Monoid().instance((Object)new CertLookup<F>(evidence$1){
            private final Monad evidence$1$1;

            public final F certificateByAliasUnsafe(String alias) {
                return (F)CertLookup.certificateByAliasUnsafe$(this, alias);
            }

            public final F certificateBySelectorUnsafe(X509CertSelector selector) {
                return (F)CertLookup.certificateBySelectorUnsafe$(this, selector);
            }

            public final CertLookup<F> filterByAlias(Function1<String, Object> f) {
                return CertLookup.filterByAlias$(this, f);
            }

            public Monad<F> monadF() {
                return Monad$.MODULE$.apply(this.evidence$1$1);
            }

            public F certificateByAlias(String alias) {
                return (F)Applicative$.MODULE$.apply((Applicative)this.evidence$1$1).pure((Object)None$.MODULE$);
            }

            public F certificateBySelector(X509CertSelector selector) {
                return (F)Applicative$.MODULE$.apply((Applicative)this.evidence$1$1).pure((Object)None$.MODULE$);
            }
            {
                this.evidence$1$1 = evidence$1$1;
                CertLookup.$init$(this);
            }
        }, (Function2 & Serializable)(a, b) -> new CertLookup<F>(evidence$1, (CertLookup)a, (CertLookup)b){
            private final Monad evidence$1$1;
            private final CertLookup a$1;
            private final CertLookup b$1;

            public final F certificateByAliasUnsafe(String alias) {
                return (F)CertLookup.certificateByAliasUnsafe$(this, alias);
            }

            public final F certificateBySelectorUnsafe(X509CertSelector selector) {
                return (F)CertLookup.certificateBySelectorUnsafe$(this, selector);
            }

            public final CertLookup<F> filterByAlias(Function1<String, Object> f) {
                return CertLookup.filterByAlias$(this, f);
            }

            public Monad<F> monadF() {
                return Monad$.MODULE$.apply(this.evidence$1$1);
            }

            public F certificateByAlias(String alias) {
                return (F)new OptionT(this.a$1.certificateByAlias(alias)).orElseF((Function0 & Serializable)() -> $this.b$1.certificateByAlias(alias), this.evidence$1$1).value();
            }

            public F certificateBySelector(X509CertSelector selector) {
                return (F)new OptionT(this.a$1.certificateBySelector(selector)).orElseF((Function0 & Serializable)() -> $this.b$1.certificateBySelector(selector), this.evidence$1$1).value();
            }
            {
                this.evidence$1$1 = evidence$1$1;
                this.a$1 = a$1;
                this.b$1 = b$1;
                CertLookup.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$certificateByAlias$1(de.bitmarck.bms.secon.fs2.CertLookup$$anon$3 java.lang.String ), $anonfun$certificateBySelector$1(de.bitmarck.bms.secon.fs2.CertLookup$$anon$3 java.security.cert.X509CertSelector )}, serializedLambda);
            }
        });
    }

    public <F> Directory toSeconDirectory(CertLookup<F> certLookup, Dispatcher<F> dispatcher) {
        return new Directory(dispatcher, certLookup){
            private final Dispatcher dispatcher$1;
            private final CertLookup certLookup$1;

            public Optional<X509Certificate> certificate(X509CertSelector selector) {
                return OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption((Option)this.dispatcher$1.unsafeRunSync(this.certLookup$1.certificateBySelector(selector))));
            }

            public Optional<X509Certificate> certificate(String identifier) {
                return OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption((Option)this.dispatcher$1.unsafeRunSync(this.certLookup$1.certificateByAlias(identifier))));
            }

            public Optional<X509Certificate> issuer(X509Certificate cert) {
                return this.certificate(CertSelectors$.MODULE$.issuerOf(cert));
            }
            {
                this.dispatcher$1 = dispatcher$1;
                this.certLookup$1 = certLookup$1;
            }
        };
    }

    public <F> CertLookup<F> fromSeconDirectory(Directory seconDirectory, Sync<F> evidence$2) {
        return new CertLookup<F>(evidence$2, seconDirectory){
            private final Sync evidence$2$1;
            private final Directory seconDirectory$1;

            public final F certificateByAliasUnsafe(String alias) {
                return (F)CertLookup.certificateByAliasUnsafe$(this, alias);
            }

            public final F certificateBySelectorUnsafe(X509CertSelector selector) {
                return (F)CertLookup.certificateBySelectorUnsafe$(this, selector);
            }

            public final CertLookup<F> filterByAlias(Function1<String, Object> f) {
                return CertLookup.filterByAlias$(this, f);
            }

            public Monad<F> monadF() {
                return Monad$.MODULE$.apply((Monad)this.evidence$2$1);
            }

            public F certificateByAlias(String alias) {
                return (F)cats.effect.package$.MODULE$.Sync().apply(this.evidence$2$1).blocking((Function0 & Serializable)() -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.seconDirectory$1.certificate(alias))));
            }

            public F certificateBySelector(X509CertSelector selector) {
                return (F)cats.effect.package$.MODULE$.Sync().apply(this.evidence$2$1).blocking((Function0 & Serializable)() -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.seconDirectory$1.certificate(selector))));
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.seconDirectory$1 = seconDirectory$1;
                CertLookup.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$certificateByAlias$2(de.bitmarck.bms.secon.fs2.CertLookup$$anon$5 java.lang.String ), $anonfun$certificateBySelector$2(de.bitmarck.bms.secon.fs2.CertLookup$$anon$5 java.security.cert.X509CertSelector )}, serializedLambda);
            }
        };
    }

    public <F> CertLookup<F> fromCertificate(X509Certificate certificate, Option<String> expectedAlias, Sync<F> evidence$3) {
        return new CertLookup<F>(evidence$3, expectedAlias, certificate){
            private final Sync evidence$3$1;
            private final Option expectedAlias$1;
            private final X509Certificate certificate$1;

            public final F certificateByAliasUnsafe(String alias) {
                return (F)CertLookup.certificateByAliasUnsafe$(this, alias);
            }

            public final F certificateBySelectorUnsafe(X509CertSelector selector) {
                return (F)CertLookup.certificateBySelectorUnsafe$(this, selector);
            }

            public final CertLookup<F> filterByAlias(Function1<String, Object> f) {
                return CertLookup.filterByAlias$(this, f);
            }

            public Monad<F> monadF() {
                return Monad$.MODULE$.apply((Monad)this.evidence$3$1);
            }

            public F certificateByAlias(String alias) {
                return (F)cats.effect.package$.MODULE$.Sync().apply(this.evidence$3$1).delay((Function0 & Serializable)() -> {
                    if ($this.expectedAlias$1.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)anon.6.$anonfun$certificateByAlias$4(alias, x$3)))) {
                        return new Some((Object)$this.certificate$1);
                    }
                    return None$.MODULE$;
                });
            }

            public F certificateBySelector(X509CertSelector selector) {
                return (F)cats.effect.package$.MODULE$.Sync().apply(this.evidence$3$1).delay((Function0 & Serializable)() -> Option$.MODULE$.when(selector.match($this.certificate$1), (Function0 & Serializable)() -> $this.certificate$1));
            }

            public static final /* synthetic */ boolean $anonfun$certificateByAlias$4(String alias$4, String x$3) {
                String string = x$3;
                String string2 = alias$4;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.evidence$3$1 = evidence$3$1;
                this.expectedAlias$1 = expectedAlias$1;
                this.certificate$1 = certificate$1;
                CertLookup.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$certificateByAlias$3(de.bitmarck.bms.secon.fs2.CertLookup$$anon$6 java.lang.String ), $anonfun$certificateByAlias$4$adapted(java.lang.String java.lang.String ), $anonfun$certificateBySelector$3(de.bitmarck.bms.secon.fs2.CertLookup$$anon$6 java.security.cert.X509CertSelector ), $anonfun$certificateBySelector$4(de.bitmarck.bms.secon.fs2.CertLookup$$anon$6 )}, serializedLambda);
            }
        };
    }

    public <F> Option<String> fromCertificate$default$2() {
        return None$.MODULE$;
    }

    public <F> CertLookup<F> fromIdentityLookup(IdentityLookup<F> identityLookup, Monad<F> evidence$4) {
        return new CertLookup<F>(evidence$4, identityLookup){
            private final Monad evidence$4$1;
            private final IdentityLookup identityLookup$1;

            public final F certificateByAliasUnsafe(String alias) {
                return (F)CertLookup.certificateByAliasUnsafe$(this, alias);
            }

            public final F certificateBySelectorUnsafe(X509CertSelector selector) {
                return (F)CertLookup.certificateBySelectorUnsafe$(this, selector);
            }

            public final CertLookup<F> filterByAlias(Function1<String, Object> f) {
                return CertLookup.filterByAlias$(this, f);
            }

            public Monad<F> monadF() {
                return Monad$.MODULE$.apply(this.evidence$4$1);
            }

            public F certificateByAlias(String alias) {
                return (F)package.functor$.MODULE$.toFunctorOps(this.identityLookup$1.identityByAlias(alias), (Functor)this.evidence$4$1).map((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)x$5 -> x$5.certificate()));
            }

            public F certificateBySelector(X509CertSelector selector) {
                return (F)package.functor$.MODULE$.toFunctorOps(this.identityLookup$1.identityBySelector(selector), (Functor)this.evidence$4$1).map((Function1 & Serializable)x$6 -> x$6.map((Function1 & Serializable)x$7 -> x$7.certificate()));
            }
            {
                this.evidence$4$1 = evidence$4$1;
                this.identityLookup$1 = identityLookup$1;
                CertLookup.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$certificateByAlias$5(scala.Option ), $anonfun$certificateByAlias$6(de.bitmarck.bms.secon.fs2.Identity ), $anonfun$certificateBySelector$5(scala.Option ), $anonfun$certificateBySelector$6(de.bitmarck.bms.secon.fs2.Identity )}, serializedLambda);
            }
        };
    }

    public <F> CertLookup<F> fromKeyStore(KeyStore keyStore, Sync<F> evidence$5) {
        return new CertLookup<F>(evidence$5, keyStore){
            private final Sync evidence$5$1;
            private final KeyStore keyStore$1;

            public final F certificateByAliasUnsafe(String alias) {
                return (F)CertLookup.certificateByAliasUnsafe$(this, alias);
            }

            public final F certificateBySelectorUnsafe(X509CertSelector selector) {
                return (F)CertLookup.certificateBySelectorUnsafe$(this, selector);
            }

            public final CertLookup<F> filterByAlias(Function1<String, Object> f) {
                return CertLookup.filterByAlias$(this, f);
            }

            public Monad<F> monadF() {
                return Monad$.MODULE$.apply((Monad)this.evidence$5$1);
            }

            public F certificateByAlias(String alias) {
                return (F)cats.effect.package$.MODULE$.Sync().apply(this.evidence$5$1).delay((Function0 & Serializable)() -> {
                    Certificate certificate = $this.keyStore$1.getCertificate(alias);
                    if (certificate instanceof X509Certificate) {
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        return new Some((Object)x509Certificate);
                    }
                    return None$.MODULE$;
                });
            }

            public F certificateBySelector(X509CertSelector selector) {
                return (F)cats.effect.package$.MODULE$.Sync().apply(this.evidence$5$1).delay((Function0 & Serializable)() -> CollectionConverters$.MODULE$.EnumerationHasAsScala($this.keyStore$1.aliases()).asScala().flatMap((Function1 & Serializable)alias -> {
                    X509Certificate x509Certificate;
                    Certificate certificate = $this.keyStore$1.getCertificate((String)alias);
                    if (certificate instanceof X509Certificate && selector.match(x509Certificate = (X509Certificate)certificate)) {
                        return new Some((Object)x509Certificate);
                    }
                    return None$.MODULE$;
                }).nextOption());
            }
            {
                this.evidence$5$1 = evidence$5$1;
                this.keyStore$1 = keyStore$1;
                CertLookup.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$certificateByAlias$7(de.bitmarck.bms.secon.fs2.CertLookup$$anon$8 java.lang.String ), $anonfun$certificateBySelector$7(de.bitmarck.bms.secon.fs2.CertLookup$$anon$8 java.security.cert.X509CertSelector ), $anonfun$certificateBySelector$8(de.bitmarck.bms.secon.fs2.CertLookup$$anon$8 java.security.cert.X509CertSelector java.lang.String )}, serializedLambda);
            }
        };
    }

    public <F> Resource<F, CertLookup<F>> fromLdap(Function0<DirContext> dirContext2, Sync<F> evidence$6) {
        return cats.effect.package$.MODULE$.Resource().make(cats.effect.package$.MODULE$.Sync().apply(evidence$6).blocking(dirContext2), (Function1 & Serializable)dirContext -> cats.effect.package$.MODULE$.Sync().apply(evidence$6).blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> dirContext.close()), evidence$6).map((Function1 & Serializable)dirContext -> MODULE$.fromSeconDirectory(SECON.directory(() -> dirContext), evidence$6));
    }

    public <F> Resource<F, CertLookup<F>> fromLdapUri(URI ldapUri, Function1<Hashtable<String, String>, BoxedUnit> configure, Sync<F> evidence$7) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUri.toString());
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        configure.apply(env);
        return this.fromLdap((Function0<DirContext>)(Function0 & Serializable)() -> new InitialDirContext(env), evidence$7);
    }

    public <F> Function1<Hashtable<String, String>, BoxedUnit> fromLdapUri$default$2() {
        return (Function1 & Serializable)x$8 -> {
            CertLookup$.$anonfun$fromLdapUri$default$2$1(x$8);
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$fromLdapUri$default$2$1(Hashtable x$8) {
    }

    private CertLookup$() {
    }
}

