/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.base32;

import de.bitmarck.bms.base32.Alphabets;
import de.bitmarck.bms.base32.Alphabets$Base32RFC4648$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class Base32$ {
    public static final Base32$ MODULE$ = new Base32$();

    private int bitsAtOffset(IndexedSeq<Object> bytes, long bitIndex, int length) {
        int i = (int)(bitIndex / 8L);
        if (i >= bytes.length()) {
            return 0;
        }
        int off = (int)(bitIndex - (long)(i * 8));
        int mask = (1 << length) - 1 << 8 - length;
        int half = BoxesRunTime.unboxToByte((Object)bytes.apply(i)) << off & mask;
        int full = off + length <= 8 || i + 1 >= bytes.length() ? half : half | (BoxesRunTime.unboxToByte((Object)bytes.apply(i + 1)) & (mask << 8 - off & 0xFF)) >>> 8 - off;
        return full >>> 8 - length;
    }

    public String encode(IndexedSeq<Object> bytes, Alphabets.Base32Alphabet alphabet) {
        int bitsPerChar = 5;
        int bytesPerGroup = 5;
        int charsPerGroup = bytesPerGroup * 8 / bitsPerChar;
        CharBuffer bldr = CharBuffer.allocate((bytes.length() + bytesPerGroup - 1) / bytesPerGroup * charsPerGroup);
        long bidx = 0L;
        while (bidx / 8L < (long)bytes.length()) {
            char c = alphabet.toChar(this.bitsAtOffset(bytes, bidx, bitsPerChar));
            bldr.append(c);
            bidx += (long)bitsPerChar;
        }
        if (alphabet.pad() != (char)0) {
            int padLen = ((bytes.length() + bitsPerChar - 1) / bitsPerChar * bitsPerChar - bytes.length()) * 8 / bitsPerChar;
            for (int i = 0; i < padLen; ++i) {
                bldr.append(alphabet.pad());
            }
        }
        return bldr.flip().toString();
    }

    public Alphabets.Base32Alphabet encode$default$2() {
        return Alphabets$Base32RFC4648$.MODULE$;
    }

    public Either<String, byte[]> decodeDescriptive(String str, Alphabets.Base32Alphabet alphabet) {
        int bitsPerChar = 5;
        int bytesPerGroup = 5;
        int charsPerGroup = bytesPerGroup * 8 / bitsPerChar;
        char Pad = alphabet.pad();
        int bidx = 0;
        int buffer = 0;
        int padding = 0;
        ByteBuffer acc = ByteBuffer.allocate((str.length() + charsPerGroup - 1) / charsPerGroup * bytesPerGroup);
        for (int idx = 0; idx < str.length(); ++idx) {
            int n;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx);
            if (Pad != (char)0 && c == Pad) {
                ++padding;
                continue;
            }
            if (alphabet.ignore(c)) continue;
            if (padding > 0) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(131).append("Unexpected character '").append(c).append("' at index ").append(idx).append(" after padding character; only '=' and whitespace characters allowed after first padding character").toString());
            }
            try {
                n = alphabet.toIndex(c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(38).append("Invalid base 32 character '").append(c).append("' at index ").append(idx).toString());
            }
            int index = n;
            buffer |= index << 8 - bitsPerChar >>> bidx & 0xFF;
            if ((bidx += bitsPerChar) < 8) continue;
            acc.put((byte)buffer);
            buffer = index << 8 - (bidx -= 8) & 0xFF;
        }
        Object object = bidx >= bitsPerChar ? acc.put((byte)buffer) : BoxedUnit.UNIT;
        acc.flip();
        byte[] bytes = new byte[acc.remaining()];
        acc.get(bytes);
        int expectedPadding = ((bytes.length + bitsPerChar - 1) / bitsPerChar * bitsPerChar - bytes.length) * 8 / bitsPerChar;
        if (padding != 0 && padding != expectedPadding) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(94).append("Malformed padding - optionally expected ").append(expectedPadding).append(" padding characters such that the quantum is completed").toString());
        }
        return package$.MODULE$.Right().apply((Object)bytes);
    }

    public byte[] decode(String str, Alphabets.Base32Alphabet alphabet) {
        return (byte[])this.decodeDescriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (byte[])Predef$.MODULE$.identity(x));
    }

    public Alphabets.Base32Alphabet decodeDescriptive$default$2() {
        return Alphabets$Base32RFC4648$.MODULE$;
    }

    public Alphabets.Base32Alphabet decode$default$2() {
        return Alphabets$Base32RFC4648$.MODULE$;
    }

    private Base32$() {
    }
}

