/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.base32;

import de.bitmarck.bms.base32.Alphabets;
import de.bitmarck.bms.base32.Alphabets$Base32RFC4648$;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.StringOps$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class Base32$ {
    public static final Base32$ MODULE$;

    static {
        new Base32$();
    }

    private int bitsAtOffset(IndexedSeq<Object> bytes, long bitIndex, int length) {
        int n;
        int i = (int)(bitIndex / 8L);
        if (i >= bytes.length()) {
            n = 0;
        } else {
            int off = (int)(bitIndex - (long)(i * 8));
            int mask = (1 << length) - 1 << 8 - length;
            int half = BoxesRunTime.unboxToByte((Object)bytes.apply(i)) << off & mask;
            int full = off + length <= 8 || i + 1 >= bytes.length() ? half : half | (BoxesRunTime.unboxToByte((Object)bytes.apply(i + 1)) & (mask << 8 - off & 0xFF)) >>> 8 - off;
            n = full >>> 8 - length;
        }
        return n;
    }

    public String encode(IndexedSeq<Object> bytes, Alphabets.Base32Alphabet alphabet) {
        int bitsPerChar = 5;
        int bytesPerGroup = 5;
        int charsPerGroup = bytesPerGroup * 8 / bitsPerChar;
        CharBuffer bldr = CharBuffer.allocate((bytes.length() + bytesPerGroup - 1) / bytesPerGroup * charsPerGroup);
        long bidx = 0L;
        while (bidx / 8L < (long)bytes.length()) {
            char c = alphabet.toChar(this.bitsAtOffset(bytes, bidx, bitsPerChar));
            bldr.append(c);
            bidx += (long)bitsPerChar;
        }
        if (alphabet.pad() != (char)0) {
            int padLen = ((bytes.length() + bitsPerChar - 1) / bitsPerChar * bitsPerChar - bytes.length()) * 8 / bitsPerChar;
            for (int i = 0; i < padLen; ++i) {
                bldr.append(alphabet.pad());
            }
        }
        return bldr.flip().toString();
    }

    public Alphabets.Base32Alphabet encode$default$2() {
        return Alphabets$Base32RFC4648$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<String, byte[]> decodeDescriptive(String str, Alphabets.Base32Alphabet alphabet) {
        int bitsPerChar = 5;
        int bytesPerGroup = 5;
        int charsPerGroup = bytesPerGroup * 8 / bitsPerChar;
        char Pad = alphabet.pad();
        int bidx = 0;
        int buffer = 0;
        int padding = 0;
        ByteBuffer acc = ByteBuffer.allocate((str.length() + charsPerGroup - 1) / charsPerGroup * bytesPerGroup);
        for (int idx = 0; idx < str.length(); ++idx) {
            int index;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx);
            if (Pad != (char)0 && c == Pad) {
                ++padding;
                continue;
            }
            if (alphabet.ignore(c)) continue;
            if (padding > 0) {
                return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected character '", "' at index ", " after padding character; only '=' and whitespace characters allowed after first padding character"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c), BoxesRunTime.boxToInteger((int)idx)})));
            }
            try {
                index = alphabet.toIndex(c);
                buffer |= index << 8 - bitsPerChar >>> bidx & 0xFF;
                if ((bidx += bitsPerChar) < 8) continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void var7_7;
                void var12_12;
                return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid base 32 character '", "' at index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)var12_12), BoxesRunTime.boxToInteger((int)var7_7)})));
            }
            acc.put((byte)buffer);
            buffer = index << 8 - (bidx -= 8) & 0xFF;
        }
        Object object = bidx >= bitsPerChar ? acc.put((byte)buffer) : BoxedUnit.UNIT;
        acc.flip();
        byte[] bytes = new byte[acc.remaining()];
        acc.get(bytes);
        int expectedPadding = ((bytes.length + bitsPerChar - 1) / bitsPerChar * bitsPerChar - bytes.length) * 8 / bitsPerChar;
        if (padding != 0 && padding != expectedPadding) {
            return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed padding - optionally expected ", " padding characters such that the quantum is completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedPadding)})));
        }
        return package$.MODULE$.Right().apply((Object)bytes);
    }

    public byte[] decode(String str, Alphabets.Base32Alphabet alphabet) {
        return (byte[])this.decodeDescriptive(str, alphabet).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new IllegalArgumentException(msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(byte[] x) {
                return (byte[])Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Alphabets.Base32Alphabet decodeDescriptive$default$2() {
        return Alphabets$Base32RFC4648$.MODULE$;
    }

    public Alphabets.Base32Alphabet decode$default$2() {
        return Alphabets$Base32RFC4648$.MODULE$;
    }

    private Base32$() {
        MODULE$ = this;
    }
}

