/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.base32.alphabet;

import de.bitmarck.bms.base32.alphabet.Base32Alphabet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Base32RFC4648
implements Base32Alphabet {
    private final char[] chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
    private final Base32Alphabet.CharIndicesLookup indicesLookup = new Base32Alphabet.CharIndicesLookup(IntStream.range(0, this.chars.length).boxed().collect(Collectors.toMap(n -> Character.valueOf(this.chars[n]), Function.identity())));
    private static final Base32RFC4648 instance = new Base32RFC4648();

    private Base32RFC4648() {
    }

    public static Base32RFC4648 getInstance() {
        return instance;
    }

    @Override
    public char toChar(int n) {
        return this.chars[n];
    }

    @Override
    public int toIndex(char c) {
        return this.indicesLookup.getIndex(c);
    }

    @Override
    public boolean ignore(char c) {
        return Character.isWhitespace(c);
    }

    @Override
    public char pad() {
        return '=';
    }
}

