/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.base32.alphabet;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

public interface Base32Alphabet {
    public char toChar(int var1);

    public int toIndex(char var1);

    public boolean ignore(char var1);

    public char pad();

    public static class CharIndicesLookup {
        private final int min;
        private final int[] indices;

        public CharIndicesLookup(Map<Character, Integer> map) {
            Set<Character> set = map.keySet();
            this.min = Collections.min(set).charValue();
            char c = Collections.max(set).charValue();
            this.indices = new int[c - this.min + 1];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = map.getOrDefault(Character.valueOf((char)(i + this.min)), -1);
            }
        }

        public int getIndex(char c) {
            int n = c - this.min;
            if (n >= 0 && n < this.indices.length && this.indices[n] >= 0) {
                return this.indices[n];
            }
            throw new IllegalArgumentException();
        }
    }
}

