/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.base32;

import de.bitmarck.bms.base32.alphabet.Base32Alphabet;
import de.bitmarck.bms.base32.alphabet.Base32RFC4648;

public class Base32Check1 {
    private static final int cardinal = 32;
    private final int[][] primitivePowers;
    private static final Base32Check1 instance = new Base32Check1(new int[]{1, 17, 8, 5, 3});

    public Base32Check1(int[] nArray) {
        this.primitivePowers = Base32Check1.getPrimitivePowers(nArray);
    }

    public static Base32Check1 getInstance() {
        return instance;
    }

    public boolean validate(String string) {
        return this.validate(string, Base32RFC4648.getInstance());
    }

    public boolean validate(String string, Base32Alphabet base32Alphabet) {
        return this.compute(string, base32Alphabet) == base32Alphabet.toChar(0);
    }

    public char compute(String string) {
        return this.compute(string, Base32RFC4648.getInstance());
    }

    public char compute(String string, Base32Alphabet base32Alphabet) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4 = base32Alphabet.toIndex(string.charAt(n));
            n3 ^= Base32Check1.matMul(new int[]{n4}, this.primitivePowers[(n + 1) % 31])[0];
        }
        n = (32 - n2 - 2) % 31;
        if (n < 0) {
            n += 31;
        }
        return base32Alphabet.toChar(Base32Check1.matMul(new int[]{n3}, this.primitivePowers[n])[0]);
    }

    private static int[][] getPrimitivePowers(int[] nArray) {
        int[][] nArrayArray = new int[31][];
        nArrayArray[1] = nArray;
        for (int i = 2; i <= nArrayArray.length; ++i) {
            int[] nArray2 = Base32Check1.matMul(nArrayArray[i - 1], nArray);
            if (i < nArrayArray.length) {
                nArrayArray[i] = nArray2;
                continue;
            }
            nArrayArray[0] = nArray2;
        }
        return nArrayArray;
    }

    private static int[] matMul(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = 0;
            for (int j = 0; j < nArray2.length; ++j) {
                if ((nArray[i] & 1 << nArray2.length - 1 - j) == 0) continue;
                int n = i;
                nArray3[n] = nArray3[n] ^ nArray2[j];
            }
        }
        return nArray3;
    }
}

