/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.base32;

import de.bitmarck.bms.base32.alphabet.Base32Alphabet;
import de.bitmarck.bms.base32.alphabet.Base32RFC4648;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class Base32 {
    private static int bitsAtOffset(byte[] byArray, long l, int n) {
        int n2 = (int)(l / 8L);
        if (n2 >= byArray.length) {
            return 0;
        }
        int n3 = (int)(l - (long)(n2 * 8));
        int n4 = (1 << n) - 1 << 8 - n;
        int n5 = byArray[n2] << n3 & n4;
        int n6 = n3 + n <= 8 || n2 + 1 >= byArray.length ? n5 : n5 | (byArray[n2 + 1] & (n4 << 8 - n3 & 0xFF)) >>> 8 - n3;
        return n6 >>> 8 - n;
    }

    public static String encode(byte[] byArray) {
        return Base32.encode(byArray, Base32RFC4648.getInstance());
    }

    public static String encode(byte[] byArray, Base32Alphabet base32Alphabet) {
        int n = 5;
        int n2 = 5;
        int n3 = n2 * 8 / n;
        CharBuffer charBuffer = CharBuffer.allocate((byArray.length + n2 - 1) / n2 * n3);
        long l = 0L;
        while (l / 8L < (long)byArray.length) {
            char c = base32Alphabet.toChar(Base32.bitsAtOffset(byArray, l, n));
            charBuffer.append(c);
            l += (long)n;
        }
        if (base32Alphabet.pad() != '\u0000') {
            int n4 = ((byArray.length + n - 1) / n * n - byArray.length) * 8 / n;
            for (int i = 0; i < n4; ++i) {
                charBuffer.append(base32Alphabet.pad());
            }
        }
        return charBuffer.flip().toString();
    }

    public static byte[] decode(String string) {
        return Base32.decode(string, Base32RFC4648.getInstance());
    }

    public static byte[] decode(String string, Base32Alphabet base32Alphabet) {
        int n;
        int n2 = 5;
        int n3 = 5;
        int n4 = n3 * 8 / n2;
        char c = base32Alphabet.pad();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate((string.length() + n4 - 1) / n4 * n3);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c != '\u0000' && c2 == c) {
                ++n7;
                continue;
            }
            if (base32Alphabet.ignore(c2)) continue;
            if (n7 > 0) {
                throw new IllegalArgumentException("Unexpected character '" + c2 + "' at index " + i + " after padding character; only '=' and whitespace characters allowed after first padding character");
            }
            try {
                n = base32Alphabet.toIndex(c2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Invalid base 32 character '" + c2 + "' at index " + i);
            }
            n6 |= n << 8 - n2 >>> n5 & 0xFF;
            if ((n5 += n2) < 8) continue;
            byteBuffer.put((byte)n6);
            n6 = n << 8 - (n5 -= 8) & 0xFF;
        }
        if (n5 >= n2) {
            byteBuffer.put((byte)n6);
        }
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        n = ((byArray.length + n2 - 1) / n2 * n2 - byArray.length) * 8 / n2;
        if (n7 != 0 && n7 != n) {
            throw new IllegalArgumentException("Malformed padding - optionally expected " + n + " padding characters such that the quantum is completed");
        }
        return byArray;
    }
}

