/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.swagger;

import com.fasterxml.classmate.TypeResolver;
import de.bitgrip.ficum.annotation.FicumExpression;
import java.lang.reflect.Type;
import java.util.Optional;
import org.springframework.core.annotation.Order;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Order(value=-2147481648)
public class FicumExpressionParameterBuilderPlugin
implements ParameterBuilderPlugin {
    private static final String DEFAULT_FORMAT_DESCRIPTION = "Filter string for filtering object using ficum-query-language, checkout https://github.com/bitgrip/ficum#ficum-query-language. Allowed fieldNames are: %s";
    private TypeResolver resolver;
    private String formatDescription;

    public FicumExpressionParameterBuilderPlugin(TypeResolver resolver, String formatDescription) {
        this.resolver = resolver;
        this.formatDescription = formatDescription;
    }

    public FicumExpressionParameterBuilderPlugin(TypeResolver resolver) {
        this(resolver, DEFAULT_FORMAT_DESCRIPTION);
    }

    public void apply(ParameterContext parameterContext) {
        ResolvedMethodParameter methodParameter = parameterContext.resolvedMethodParameter();
        Optional ficumExpressionAnnotation = methodParameter.findAnnotation(FicumExpression.class).toJavaUtil();
        if (ficumExpressionAnnotation.isPresent()) {
            String joinedAllowedValues = String.join((CharSequence)", ", ((FicumExpression)ficumExpressionAnnotation.get()).value());
            parameterContext.parameterBuilder().type(this.resolver.resolve(String.class, new Type[0])).description(String.format(this.formatDescription, joinedAllowedValues));
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

