/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.parboiled.Action;
import org.parboiled.BaseParser;
import org.parboiled.Context;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.support.StringVar;

@BuildParseTree
public class ArgumentParser
extends BaseParser<Object> {
    private static final Set<Class<? extends Comparable<?>>> baseTypes = new HashSet();

    public static Collection<Class<? extends Comparable<?>>> getBaseTypes() {
        return Collections.unmodifiableCollection(baseTypes);
    }

    @MemoMismatches
    protected Rule AlgebraicSign() {
        return this.AnyOf("-+");
    }

    protected Rule AnyString(final StringVar literal) {
        return this.Sequence(this.NoneOf("'"), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                literal.append(ArgumentParser.this.match());
                return true;
            }
        }, new Object[0]);
    }

    protected Rule Argument() {
        return this.Sequence(this.FirstOf(this.UUIDLiteral(), this.StringLiteral(), new Object[]{this.IntegerLiteral(), this.DoubleLiteral(), this.FloatLiteral(), this.DateLiteral(), this.TimestampLiteral(), this.BooleanTrue(), this.BooleanFalse(), this.NullLiteral()}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                Comparable argument = (Comparable)context.getValueStack().peek();
                return ArgumentParser.this.isBaseType(argument);
            }
        }, new Object[0]);
    }

    @SuppressSubnodes
    protected Rule BooleanFalse() {
        return this.Sequence(this.FirstOf(this.Sequence(this.AnyOf("Ff"), this.String("alse"), new Object[0]), this.Sequence(this.AnyOf("Nn"), this.String("o"), new Object[0]), new Object[0]), this.push(Boolean.FALSE), new Object[0]);
    }

    @SuppressSubnodes
    protected Rule BooleanTrue() {
        return this.Sequence(this.FirstOf(this.Sequence(this.AnyOf("Tt"), this.String("rue"), new Object[0]), this.Sequence(this.AnyOf("Yy"), this.String("es"), new Object[0]), new Object[0]), this.push(Boolean.TRUE), new Object[0]);
    }

    @SuppressSubnodes
    protected Rule DateLiteral() {
        return this.Sequence(this.Sequence(this.Optional(this.AlgebraicSign()), this.OneOrMore(this.Digit()), new Object[]{this.Ch('-'), this.Digit(), this.Digit(), this.Ch('-'), this.Digit(), this.Digit(), this.TestNot(this.Ch('T'))}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                try {
                    LocalDate date = DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)ArgumentParser.this.match(), LocalDate::from);
                    return ArgumentParser.this.push(date);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, new Object[0]);
    }

    protected Rule DecimalNumeral() {
        return this.FirstOf(this.Ch('0'), this.Sequence(this.CharRange('1', '9'), this.ZeroOrMore(this.Digit()), new Object[0]), new Object[0]);
    }

    @MemoMismatches
    protected Rule Digit() {
        return this.CharRange('0', '9');
    }

    protected Rule DoubleDecimal() {
        return this.FirstOf(this.Sequence(this.OneOrMore(this.Digit()), this.Ch('.'), new Object[]{this.ZeroOrMore(this.Digit()), this.Optional(this.Exponent()), this.Optional(this.DoubleMarker())}), this.Sequence(Character.valueOf('.'), this.OneOrMore(this.Digit()), new Object[]{this.Optional(this.Exponent()), this.Optional(this.DoubleMarker())}), new Object[]{this.Sequence(this.OneOrMore(this.Digit()), this.Exponent(), new Object[]{this.Optional(this.DoubleMarker())}), this.Sequence(this.OneOrMore(this.Digit()), this.Optional(this.Exponent()), new Object[]{this.DoubleMarker()})});
    }

    @SuppressSubnodes
    protected Rule DoubleLiteral() {
        return this.Sequence(this.Sequence(this.Optional(this.AlgebraicSign()), this.DoubleDecimal(), new Object[]{this.TestNot(this.Sign())}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                try {
                    Double valueOf = Double.parseDouble(ArgumentParser.this.match());
                    return ArgumentParser.this.push(valueOf);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }, new Object[0]);
    }

    @MemoMismatches
    protected Rule DoubleMarker() {
        return this.AnyOf("dD");
    }

    protected Rule Exponent() {
        return this.Sequence(this.AnyOf("eE"), this.Optional(this.AlgebraicSign()), new Object[]{this.OneOrMore(this.Digit())});
    }

    protected Rule FloatDecimal() {
        return this.FirstOf(this.Sequence(this.OneOrMore(this.Digit()), this.Ch('.'), new Object[]{this.ZeroOrMore(this.Digit()), this.Optional(this.Exponent()), this.Optional(this.FloatingPointMarker())}), this.Sequence(Character.valueOf('.'), this.OneOrMore(this.Digit()), new Object[]{this.Optional(this.Exponent()), this.Optional(this.FloatingPointMarker())}), new Object[]{this.Sequence(this.OneOrMore(this.Digit()), this.Exponent(), new Object[]{this.Optional(this.FloatingPointMarker())}), this.Sequence(this.OneOrMore(this.Digit()), this.Optional(this.Exponent()), new Object[]{this.FloatingPointMarker()})});
    }

    protected Rule FloatingPointMarker() {
        return this.AnyOf("fF");
    }

    @SuppressSubnodes
    protected Rule FloatLiteral() {
        return this.Sequence(this.Sequence(this.Optional(this.AlgebraicSign()), this.FloatDecimal(), new Object[]{this.TestNot(this.Sign())}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                try {
                    Float valueOf = Float.valueOf(Float.parseFloat(ArgumentParser.this.match()));
                    return ArgumentParser.this.push(valueOf);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }, new Object[0]);
    }

    protected Rule HexDigit() {
        return this.FirstOf(this.LowerHexChar(), this.UpperHexChar(), new Object[]{this.Digit()});
    }

    protected Rule LowerHexDigit() {
        return this.FirstOf(this.LowerHexChar(), this.Digit(), new Object[0]);
    }

    @SuppressSubnodes
    protected Rule HexEscape(final StringVar literal) {
        return this.Sequence(this.Sequence(this.FirstOf(this.Ch('#'), this.Sequence(this.Ch('0'), this.AnyOf("xX"), new Object[0]), new Object[0]), this.OneOrMore(this.Sequence(this.HexDigit(), this.HexDigit(), new Object[0])), new Object[0]), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                literal.append(new String(Character.toChars(Integer.decode(ArgumentParser.this.match()))));
                return true;
            }
        }, new Object[0]);
    }

    @SuppressSubnodes
    protected Rule IntegerLiteral() {
        return this.Sequence(this.Sequence(this.Optional(this.AlgebraicSign()), this.DecimalNumeral(), new Object[]{this.Optional(this.AnyOf("lL")), this.TestNot(this.Sign())}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                try {
                    boolean isLong = false;
                    String match = ArgumentParser.this.match();
                    int index = match.indexOf("l");
                    if (index == -1) {
                        index = match.indexOf("L");
                    }
                    if (index != -1) {
                        isLong = true;
                        match = match.substring(0, index);
                    }
                    if ((index = match.indexOf("+")) == 0) {
                        match = match.substring(1, match.length());
                    }
                    if (isLong) {
                        Long valueOf = Long.parseLong(match);
                        return ArgumentParser.this.push(valueOf);
                    }
                    Integer valueOf = Integer.parseInt(match);
                    return ArgumentParser.this.push(valueOf);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }, new Object[0]);
    }

    protected boolean isBaseType(Comparable<?> type) {
        if (type == null) {
            return true;
        }
        Class<?> clazz = type.getClass();
        for (Class<Comparable<?>> baseType : baseTypes) {
            if (!baseType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @SuppressSubnodes
    protected Rule NullLiteral() {
        return this.Sequence(this.Sequence(this.AnyOf("Nn"), this.String("ull"), new Object[0]), this.push(null), new Object[0]);
    }

    protected Rule PctDigit() {
        return this.FirstOf(this.UpperHexChar(), this.Digit(), new Object[0]);
    }

    @SuppressSubnodes
    protected Rule PctEncoded(final StringVar literal) {
        return this.Sequence(this.OneOrMore(this.Sequence(this.Ch('%'), this.PctDigit(), new Object[]{this.PctDigit()})), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                try {
                    literal.append(URLDecoder.decode(ArgumentParser.this.match(), "utf-8"));
                    return true;
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
            }
        }, new Object[0]);
    }

    public Rule root() {
        return this.Sequence(this.Argument(), EOI, new Object[0]);
    }

    protected Rule Sign() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.Digit(), this.AnyOf("-+.")});
    }

    protected Rule UUIDLiteral() {
        return this.Sequence(this.Sequence(this.NTimes(8, this.LowerHexDigit()), this.Ch('-'), new Object[]{this.NTimes(4, this.LowerHexDigit()), this.Ch('-'), this.NTimes(4, this.LowerHexDigit()), this.Ch('-'), this.NTimes(4, this.LowerHexDigit()), this.Ch('-'), this.NTimes(12, this.LowerHexDigit())}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                try {
                    UUID uuid = UUID.fromString(ArgumentParser.this.match());
                    return ArgumentParser.this.push(uuid);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, new Object[0]);
    }

    protected Rule StringLiteral() {
        final StringVar literal = new StringVar();
        return this.Sequence(this.Sequence(this.Ch('\''), this.ZeroOrMore(this.FirstOf(this.PctEncoded(literal), this.HexEscape(literal), new Object[]{this.AnyString(literal)})), new Object[]{this.Ch('\'')}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                String value = (String)literal.get();
                if (value == null) {
                    return ArgumentParser.this.push("");
                }
                if (value.length() == 1) {
                    return ArgumentParser.this.push(new Character(value.charAt(0)));
                }
                return ArgumentParser.this.push(value);
            }
        }, new Object[0]);
    }

    @SuppressSubnodes
    protected Rule TimestampLiteral() {
        return this.Sequence(this.Sequence(this.Optional(this.AlgebraicSign()), this.OneOrMore(this.Digit()), new Object[]{this.Ch('-'), this.Digit(), this.Digit(), this.Ch('-'), this.Digit(), this.Digit(), this.Ch('T'), this.Digit(), this.Digit(), this.Ch(':'), this.Digit(), this.Digit(), this.Ch(':'), this.Digit(), this.Digit(), this.Ch('.'), this.Digit(), this.Digit(), this.Optional(this.Digit()), this.FirstOf(this.Ch('Z'), this.Sequence(this.AlgebraicSign(), this.Digit(), new Object[]{this.Digit(), this.Ch(':'), this.Digit(), this.Digit(), this.Optional(this.Ch(':'), this.Digit(), new Object[]{this.Digit()})}), new Object[0])}), new Action<Comparable<?>>(){

            public boolean run(Context<Comparable<?>> context) {
                try {
                    OffsetDateTime dateTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)ArgumentParser.this.match(), OffsetDateTime::from);
                    return ArgumentParser.this.push(dateTime);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, new Object[0]);
    }

    @MemoMismatches
    protected Rule UpperHexChar() {
        return this.CharRange('A', 'F');
    }

    @MemoMismatches
    protected Rule LowerHexChar() {
        return this.CharRange('a', 'f');
    }

    static {
        baseTypes.add(Character.class);
        baseTypes.add(String.class);
        baseTypes.add(Float.class);
        baseTypes.add(Double.class);
        baseTypes.add(Integer.class);
        baseTypes.add(Long.class);
        baseTypes.add(Boolean.class);
        baseTypes.add(OffsetDateTime.class);
        baseTypes.add(LocalDate.class);
        baseTypes.add(UUID.class);
    }
}

