/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.node;

import de.bitgrip.ficum.node.AbstractVisitor;
import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.OperationNode;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

public class QueryPrinterVisitor
extends AbstractVisitor<String> {
    private StringBuffer output;
    private boolean preceded = false;

    private void printArgument(StringBuffer buffer, Object argument) {
        if (argument == null) {
            buffer.append("null");
        } else if (argument instanceof Boolean) {
            buffer.append(argument);
        } else if (argument instanceof Byte) {
            buffer.append(argument);
        } else if (argument instanceof Short) {
            buffer.append(argument);
        } else if (argument instanceof Integer) {
            buffer.append(argument);
        } else if (argument instanceof Float) {
            buffer.append(argument).append('f');
        } else if (argument instanceof Long) {
            buffer.append(argument).append('l');
        } else if (argument instanceof Double) {
            buffer.append(argument);
        } else if (argument instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)argument);
            this.printCalendar(buffer, cal);
        } else if (argument instanceof Calendar) {
            Calendar cal = (Calendar)argument;
            this.printCalendar(buffer, cal);
        } else if (argument instanceof ReadablePartial) {
            buffer.append(ISODateTimeFormat.yearMonthDay().print((ReadablePartial)argument));
        } else if (argument instanceof ReadableInstant) {
            buffer.append(ISODateTimeFormat.dateTime().print((ReadableInstant)argument));
        } else if (argument instanceof Enum) {
            buffer.append('\'').append(((Enum)argument).name()).append('\'');
        } else if (argument instanceof Iterable) {
            Iterator it = ((Iterable)argument).iterator();
            buffer.append('[');
            if (it.hasNext()) {
                this.printArgument(buffer, it.next());
                while (it.hasNext()) {
                    buffer.append(',');
                    this.printArgument(buffer, it.next());
                }
            }
            buffer.append(']');
        } else {
            buffer.append('\'').append(argument.toString()).append('\'');
        }
    }

    private void printCalendar(StringBuffer buffer, Calendar cal) {
        if (cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
            this.printArgument(buffer, new LocalDate((Object)cal, DateTimeZone.UTC));
        } else {
            this.printArgument(buffer, new DateTime((Object)cal, DateTimeZone.forTimeZone((TimeZone)cal.getTimeZone())));
        }
    }

    @Override
    public String start(Node node) {
        this.output = new StringBuffer();
        node.accept(this);
        return this.output.toString();
    }

    @Override
    public void visit(ConstraintNode<?> node) {
        this.output.append(node.getSelector());
        this.output.append(node.getComparison().getSign());
        this.printArgument(this.output, node.getArgument());
    }

    @Override
    public void visit(OperationNode node) {
        switch (node.getOperator()) {
            case AND: 
            case NOR: {
                this.preceded = node.getOperator().preceded;
                node.getLeft().accept(this);
                this.output.append(node.getOperator().getSign());
                node.getRight().accept(this);
                this.preceded = false;
                break;
            }
            case OR: 
            case NAND: {
                if (this.preceded) {
                    this.output.append('(');
                }
                node.getLeft().accept(this);
                this.output.append(node.getOperator().getSign());
                node.getRight().accept(this);
                if (!this.preceded) break;
                this.output.append(')');
                break;
            }
            default: {
                throw new IllegalArgumentException("OperationNode: " + node + " does not resolve to a operation");
            }
        }
    }
}

