/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.node;

import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.OperationNode;
import de.bitgrip.ficum.node.Visitor;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractVisitor<T>
implements Visitor<T> {
    private boolean alwaysWildcard = false;
    private Map<String, String> selectorToFieldMapping = new HashMap<String, String>();

    public static boolean containsWildcard(String value) {
        return value.contains("*") || value.contains("?");
    }

    public void addSelectorToFieldMapping(String selector, String field) {
        this.selectorToFieldMapping.put(selector, field);
    }

    public String getMappedField(String selector) {
        if (this.selectorToFieldMapping.containsKey(selector)) {
            return this.selectorToFieldMapping.get(selector);
        }
        return selector;
    }

    public boolean isAlwaysWildcard() {
        return this.alwaysWildcard;
    }

    public void setAlwaysWildcard(boolean alwaysWildcardMatch) {
        this.alwaysWildcard = alwaysWildcardMatch;
    }

    public void setSelectorToFieldMapping(Map<String, String> selectorToFieldMapping) {
        this.selectorToFieldMapping = selectorToFieldMapping;
    }

    @Override
    public void visit(Node node) {
        if (node instanceof ConstraintNode) {
            this.visit((ConstraintNode)node);
            return;
        }
        if (node instanceof OperationNode) {
            this.visit((OperationNode)node);
            return;
        }
    }
}

