/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.node;

import de.bitgrip.ficum.node.Comparison;
import de.bitgrip.ficum.node.Constraint;
import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.LogicalOperationNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.Operator;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public class Builder {
    private Deque<Object> infixStack = new ArrayDeque<Object>();
    private UnbalancedBuilder unbalancedBuilder = new UnbalancedBuilder(this);
    private DefinedBuilder definedBuilder = new DefinedBuilder();
    private Builder parent;

    private Builder() {
    }

    private Builder(Builder parent) {
        this();
        this.parent = parent;
    }

    public static Node build(Iterable<Object> stack) {
        if (stack == null) {
            return null;
        }
        return Builder.eval(Builder.infixToPostfix(stack));
    }

    private static Node eval(Deque<Object> postfix) {
        while (!postfix.isEmpty()) {
            Object element = postfix.removeFirst();
            if (element instanceof Constraint) {
                Constraint constraint = (Constraint)element;
                return new ConstraintNode(constraint);
            }
            if (!(element instanceof Operator)) continue;
            Operator operator = (Operator)((Object)element);
            LogicalOperationNode node = new LogicalOperationNode(operator);
            Node operand1 = Builder.eval(postfix);
            Node operand2 = Builder.eval(postfix);
            node.setRight(operand1);
            node.setLeft(operand2);
            return node;
        }
        return null;
    }

    protected static Deque<Object> infixToPostfix(Iterable<Object> infixStack) {
        ArrayDeque<Object> output = new ArrayDeque<Object>();
        ArrayDeque<Operator> operatorStack = new ArrayDeque<Operator>();
        for (Object element : infixStack) {
            if (element instanceof Constraint) {
                output.push(element);
            }
            if (!(element instanceof Operator)) continue;
            Operator op = (Operator)((Object)element);
            switch (op) {
                case AND: 
                case NOR: 
                case LEFT: {
                    operatorStack.push(op);
                    break;
                }
                case OR: 
                case NAND: {
                    while (!operatorStack.isEmpty() && ((Operator)((Object)operatorStack.peek())).preceded) {
                        output.push(operatorStack.pop());
                    }
                    operatorStack.push(op);
                    break;
                }
                case RIGHT: {
                    boolean balanced = false;
                    while (!operatorStack.isEmpty()) {
                        Operator last = (Operator)((Object)operatorStack.pop());
                        if (Operator.LEFT.equals((Object)last)) {
                            balanced = true;
                            break;
                        }
                        output.push((Object)last);
                    }
                    if (balanced) break;
                    throw new IllegalStateException("Unbalanced subexpression! Make sure subexpressions are closed properly.");
                }
            }
        }
        while (!operatorStack.isEmpty()) {
            output.push(operatorStack.pop());
        }
        return output;
    }

    protected static Deque<Object> reverse(Iterable<Object> stack) {
        ArrayDeque<Object> deque = new ArrayDeque<Object>();
        for (Object element : stack) {
            deque.addFirst(element);
        }
        return deque;
    }

    public static UnbalancedBuilder start() {
        return new Builder().unbalancedBuilder;
    }

    public class UnbalancedBuilder {
        private Builder builder;

        public UnbalancedBuilder(Builder builder) {
            this.builder = builder;
        }

        public DefinedBuilder constraint(String selector, Comparison comparison, Comparable<?> argument) {
            Builder.this.infixStack.push(new Constraint(selector, comparison, argument));
            return Builder.this.definedBuilder;
        }

        public DefinedBuilder constraint(String selector, Comparison comparison, Comparable<?> ... argument) {
            if (argument.length == 0) {
                throw new IllegalArgumentException("Comparable argument array should have at least 2 members.");
            }
            if (argument.length == 1) {
                Builder.this.infixStack.push(new Constraint(selector, comparison, argument[0]));
            }
            Builder.this.infixStack.push(new Constraint(selector, comparison, Arrays.asList(argument)));
            return Builder.this.definedBuilder;
        }

        public UnbalancedBuilder sub() {
            return new Builder(this.builder).unbalancedBuilder;
        }
    }

    public class DefinedBuilder {
        public UnbalancedBuilder and() {
            Builder.this.infixStack.push(Operator.AND);
            return Builder.this.unbalancedBuilder;
        }

        public Node build() {
            if (Builder.this.parent != null) {
                throw new IllegalStateException("Can not build! Close subexpression first.");
            }
            return Builder.eval(Builder.infixToPostfix(Builder.reverse(Builder.this.infixStack)));
        }

        public DefinedBuilder endsub() {
            if (Builder.this.parent == null) {
                throw new IllegalStateException("No open subexpression found!");
            }
            Builder.this.parent.infixStack.push(Operator.LEFT);
            while (!Builder.this.infixStack.isEmpty()) {
                Builder.this.parent.infixStack.push(Builder.this.infixStack.removeLast());
            }
            Builder.this.parent.infixStack.push(Operator.RIGHT);
            return Builder.this.parent.definedBuilder;
        }

        public UnbalancedBuilder or() {
            Builder.this.infixStack.push(Operator.OR);
            return Builder.this.unbalancedBuilder;
        }
    }
}

