/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import java.io.File;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Set column data format")
public class SetColumnDataFormat
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter(required=false)
    private File file;
    @Parameter(label="Sheet name or index", description="if empty the sheet will receive the name of the table used truncated at 30 characters if the title is >30 char", required=false)
    private String sheetNameOrIndex;
    @Parameter(label="Column index (0-based)")
    private int columnIndex;
    @Parameter(label="Data format", choices={"General", "0", "0.00", "0%", "0.00%", "h:mm:ss", "0.00E+00"})
    private String dataFormat;

    protected static void setColumnDataFormat(String filePathToExcelWorkbook, Object sheetObject, Integer columnNumber, String dataFormatString) {
        ExcelUtils excelUtils = new ExcelUtils();
        filePathToExcelWorkbook = excelUtils.fixFilePath(filePathToExcelWorkbook);
        String filePath = excelUtils.fixFilePath(filePathToExcelWorkbook);
        logger.info("Output file path  = " + filePath);
        Workbook workbook = excelUtils.getWorkbook(filePath);
        Sheet sheet = excelUtils.getSheet(workbook, sheetObject, true);
        logger.info("Current sheet = " + sheet);
        ExcelUtils.setColumnDataFormat(sheet, columnNumber, dataFormatString);
        excelUtils.saveWorkbook(workbook, filePath);
    }

    public void run() {
        String filePath = this.file == null ? "" : this.file.getAbsolutePath();
        SetColumnDataFormat.setColumnDataFormat(filePath, this.sheetNameOrIndex, this.columnIndex, this.dataFormat);
    }

    @Override
    public void runFromMacro(Object[] parameters) {
        String filePath = (String)parameters[0];
        if (filePath.equals("") || filePath == null) {
            filePath = System.getProperty("user.home");
        }
        SetColumnDataFormat.setColumnDataFormat(filePath, parameters[1].toString(), ((Double)parameters[2]).intValue(), parameters[3].toString());
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1, 2, 1};
    }

    @Override
    public String description() {
        return "The column data format can de set for a defined workbook and sheet\nPossible formats are described under\n<a href=https://poi.apache.org/apidocs/dev/org/apache/poi/ss/usermodel/BuiltinFormats.html>BuiltinFormats</a>";
    }

    @Override
    public String parameters() {
        return "filePathToExcelWorkbook, sheetNameOrIndex, columnNumber, dataFormatString";
    }
}

