/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.measure.ResultsTable;
import java.io.File;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Save table as worksheet")
public class SaveTableAsWorksheet
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter(label="Results table name", description="if this field is empty the active table will be automatically used", required=false)
    private ResultsTable selectedTable;
    @Parameter(required=false)
    private File file;
    @Parameter(label="Sheet name or index", description="if empty the sheet will receive the name of the table used truncated at 30 characters if the title is >30 char", required=false)
    private String sheetNameOrIndex;
    @Parameter(label="Append data to specified sheet")
    private Boolean append = false;
    @Parameter(label="Skip headings while appending")
    private Boolean skipAppendedHeadings = false;

    public void run() {
        String filePath = this.file == null ? "" : this.file.getAbsolutePath();
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(this.selectedTable, filePath, this.sheetNameOrIndex, this.append, this.skipAppendedHeadings);
    }

    protected static void saveTableAsWorkbookSheet(ResultsTable ijResultsTable, String filePathToExcelWorkbook, Object sheetObject, Boolean appendToSheet, Boolean skipHeadings) {
        ExcelUtils.setupLogger();
        ExcelUtils excelUtils = new ExcelUtils();
        filePathToExcelWorkbook = excelUtils.fixFilePath(filePathToExcelWorkbook);
        if (ijResultsTable == null) {
            excelUtils.noTableFoundMessage();
            return;
        }
        logger.info("Current results table = " + ijResultsTable);
        Vector<String[]> tableVector = excelUtils.getImageJTableRowsAsVector(ijResultsTable);
        Workbook workbook = excelUtils.getWorkbook(filePathToExcelWorkbook);
        logger.info("Workbook = " + workbook);
        if (workbook == null) {
            logger.info("Aborting due to nonexisting workbook");
            return;
        }
        String sheetObjectAsString = excelUtils.getSheetObjectAsString(sheetObject);
        if (sheetObjectAsString.equals("") && ijResultsTable != null && (sheetObjectAsString = ijResultsTable.getTitle()).equals("")) {
            sheetObjectAsString = "Sheet";
        }
        Sheet sheet = excelUtils.getSheet(workbook, sheetObjectAsString, appendToSheet);
        logger.info("Current sheet = " + sheet);
        logger.info("Current sheet name = " + sheet.getSheetName());
        logger.info("Append data = " + appendToSheet);
        logger.info("Skip headings = " + skipHeadings);
        int excelRowStartingIndex = 0;
        int excelColumnStartingIndex = 0;
        if (appendToSheet.booleanValue()) {
            excelRowStartingIndex = sheet.getLastRowNum() < 0 ? 0 : sheet.getLastRowNum() + 1;
            skipHeadings = skipHeadings != false && excelRowStartingIndex > 0;
        }
        logger.info("Row starting index = " + excelRowStartingIndex);
        logger.info("Skip data headings = " + skipHeadings);
        int rowIndexOffset = 0;
        for (int excelRowIndex = excelRowStartingIndex; excelRowIndex < excelRowStartingIndex + tableVector.size(); ++excelRowIndex) {
            int ijTableRowIndex = excelRowIndex - excelRowStartingIndex;
            if (skipHeadings.booleanValue() && ijTableRowIndex == 0) {
                rowIndexOffset = -1;
                continue;
            }
            Row row = sheet.createRow(excelRowIndex + rowIndexOffset);
            for (int excelColumnIndex = excelColumnStartingIndex; excelColumnIndex < excelUtils.getVectorContentSize(tableVector); ++excelColumnIndex) {
                Cell cell = row.createCell(excelColumnIndex);
                String value = tableVector.get(ijTableRowIndex)[excelColumnIndex];
                if (value.equals("NaN")) {
                    value = "";
                }
                try {
                    cell.setCellValue(Double.parseDouble(value));
                    continue;
                }
                catch (Exception e) {
                    cell.setCellValue(value);
                }
            }
        }
        excelUtils.saveWorkbook(workbook, filePathToExcelWorkbook);
        logger.info("Saved " + workbook + " at " + filePathToExcelWorkbook);
    }

    @Override
    public void runFromMacro(Object[] parameters) {
        ExcelUtils.setupLogger();
        String filePath = (String)parameters[0];
        if (filePath.equals("") || filePath == null) {
            filePath = System.getProperty("user.home");
        }
        parameters[3] = ExcelUtils.readBooleanMacroInput(parameters[3]);
        parameters[4] = ExcelUtils.readBooleanMacroInput(parameters[4]);
        for (int p = 0; p < parameters.length; ++p) {
            logger.info("Macro parameter " + p + " = " + parameters[p]);
        }
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(ResultsTable.getResultsTable((String)parameters[0].toString()), parameters[1].toString(), parameters[2], Boolean.valueOf(parameters[3].toString()), Boolean.valueOf(parameters[4].toString()));
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1, 1, 1, 1};
    }

    @Override
    public String description() {
        return "The active or otherwise specified table will be saved as a single sheet in an Excel workbook (.xlsx) fileunder the specified name or the ImageJ table name otherwise.\nData can also be appended to existing data in a specified sheet if indicated with or without their headings.\nIf indicated the existing file will be overwritten or a new file will be created.";
    }

    @Override
    public String parameters() {
        return "ijResultsTableTitle, filePathToExcelWorkbook, sheetNameOrIndex, appendDataToSheet, skipHeadingsWhenAppending";
    }
}

