/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.plugins.SaveTableAsWorksheet;
import excel.functions.utils.ExcelUtils;
import ij.WindowManager;
import ij.measure.ResultsTable;
import java.io.File;
import java.util.logging.Logger;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Save all tables to workbook")
public class SaveAllTablesToWorkbook
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter
    File file;
    @Parameter(label="Append data to specified sheet")
    private Boolean append;
    @Parameter(label="Skip headings while appending")
    private Boolean skipAppendedHeadings;

    public void run() {
        String filePath = this.file == null ? "" : this.file.getAbsolutePath();
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(filePath, this.append, this.skipAppendedHeadings);
    }

    protected static void saveAllOpenTablesAsWorkbookSheets(String filePath, Boolean appendData, Boolean skipHeadings) {
        ExcelUtils.setupLogger();
        ExcelUtils excelUtils = new ExcelUtils();
        String[] nonImageWindowNames = WindowManager.getNonImageTitles();
        logger.info("Non image windows: " + nonImageWindowNames);
        for (int window = 0; window < nonImageWindowNames.length; ++window) {
            ResultsTable currentTable = ResultsTable.getResultsTable((String)nonImageWindowNames[window]);
            logger.info("Current results table = " + currentTable);
            if (currentTable == null) continue;
            SaveTableAsWorksheet.saveTableAsWorkbookSheet(currentTable, filePath, nonImageWindowNames[window], appendData, skipHeadings);
        }
    }

    @Override
    public void runFromMacro(Object[] parameters) {
        ExcelUtils.setupLogger();
        String filePath = (String)parameters[0];
        if (filePath.equals("") || filePath == null) {
            filePath = System.getProperty("user.home");
        }
        parameters[1] = ExcelUtils.readBooleanMacroInput(parameters[1]);
        parameters[2] = ExcelUtils.readBooleanMacroInput(parameters[2]);
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(filePath, Boolean.valueOf(parameters[1].toString()), Boolean.valueOf(parameters[2].toString()));
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1, 1};
    }

    @Override
    public String description() {
        return "Saves all open IJ results table as individual sheets to an XLSX Workbook orappends the data in the specified sheet.\nThe name of the table is used as sheet name and trunkated after 30 characters";
    }

    @Override
    public String parameters() {
        return "filePathToExcelWorkbook, appendData, skipHeadingsWhenAppendingData";
    }
}

