/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.measure.ResultsTable;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Import worksheet as table")
public class ImportXlsxWorksheetAsTable
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter(required=true)
    private File file;
    @Parameter(label="Workbook sheet name or index", description="", required=true)
    private String sheetNameOrIndex;

    public void run() {
        if (!this.file.exists()) {
            JOptionPane.showMessageDialog(null, "Specified file is not existing!", "File not found", 2);
            return;
        }
        String filePath = this.file == null ? "" : this.file.getAbsolutePath();
        ImportXlsxWorksheetAsTable.importXlsxWorksheetAsTable(filePath, this.sheetNameOrIndex);
    }

    protected static void importXlsxWorksheetAsTable(String filePathToExcelWorkbook, Object sheetObject) {
        ExcelUtils.setupLogger();
        ExcelUtils excelUtils = new ExcelUtils();
        filePathToExcelWorkbook = excelUtils.fixFilePath(filePathToExcelWorkbook);
        Workbook workbook = excelUtils.getWorkbook(filePathToExcelWorkbook);
        Sheet sheet = excelUtils.getSheet(workbook, sheetObject, true);
        if (sheet == null) {
            JOptionPane.showMessageDialog(null, "Sheet could not be found", "No such sheet", 2);
        }
        Vector<String[]> tableVector = excelUtils.getXlsxSheetAsVectorOfColumns(sheet);
        ResultsTable resultsTable = excelUtils.createResultsTable(tableVector);
        resultsTable.show(sheet.getSheetName());
        try {
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void runFromMacro(Object[] parameters) {
        ExcelUtils.setupLogger();
        for (int p = 0; p < parameters.length; ++p) {
            logger.info("Macro parameter " + p + " = " + parameters[p]);
        }
        ImportXlsxWorksheetAsTable.importXlsxWorksheetAsTable((String)parameters[0], parameters[1]);
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1};
    }

    @Override
    public String description() {
        return "Loads a specified spreadsheet from an Excel workbook.Sheetnames can be specified as the real names or as sheet indices (0-based).If 0 is used, the active sheet will be returned.Typing <b>FIRST</b> or <b>LAST</b> (case sensitive, so use pure capital letters) the first or last sheet is returned, respectively.";
    }

    @Override
    public String parameters() {
        return "filePathToExcelWorkbook, sheetNameOrIndex";
    }
}

