/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.plugins.AddImageToWorksheet;
import excel.functions.plugins.AppendArrayAsExcelColumn;
import excel.functions.plugins.AppendArrayAsExcelRow;
import excel.functions.plugins.SaveAllTablesToWorkbook;
import excel.functions.plugins.SaveTableAsWorksheet;
import excel.functions.plugins.SetColumnDataFormat;
import excel.functions.utils.ExcelUtils;
import ij.ImagePlus;
import ij.measure.ResultsTable;
import java.io.File;

public class ExcelFunctions {
    public ExcelFunctions() {
        ExcelUtils utils = new ExcelUtils();
    }

    public static void saveTableToWorkbookSheet(ResultsTable ijResultsTable, File file, Object sheetNameOrIndex, Boolean appendData, Boolean skipHeadingsWhenAppending) {
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(ijResultsTable, file.getAbsolutePath(), sheetNameOrIndex, appendData, skipHeadingsWhenAppending);
    }

    public static void saveTableToWorkbookSheet(ResultsTable ijResultsTable, String filePath, Object sheetNameOrIndex, Boolean appendData, Boolean skipHeadingsWhenAppending) {
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(ijResultsTable, filePath, sheetNameOrIndex, appendData, skipHeadingsWhenAppending);
    }

    public static void saveTableToWorkbookSheet(String ijTableName, String filePath, Object sheetNameOrIndex, Boolean appendData, Boolean skipHeadingsWhenAppending) {
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(ResultsTable.getResultsTable((String)ijTableName), filePath, sheetNameOrIndex, appendData, skipHeadingsWhenAppending);
    }

    public static void saveAllOpenTablesToWorkbook(File file, Boolean appendData, Boolean skipHeadingsWhenAppending) {
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(file.getAbsolutePath(), appendData, skipHeadingsWhenAppending);
    }

    public static void saveAllOpenTablesToWorkbook(String filePath, Boolean appendData, Boolean skipHeadingsWhenAppending) {
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(filePath, appendData, skipHeadingsWhenAppending);
    }

    public static void addImageToWorkbookSheet(ImagePlus imagePlus, String filePath, Object sheetNameOrIndex, int column, int row) {
        AddImageToWorksheet.addImageToWorksheet(imagePlus, filePath, sheetNameOrIndex, column, row);
    }

    public static void appendArrayAsExcelRow(Number[] array, String filePath, Object sheetNameOrIndex, int startingColumn) {
        String[] stringArray = new String[array.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = array[index].toString();
        }
        AppendArrayAsExcelRow.appendArrayAsTableRow(stringArray, filePath, sheetNameOrIndex, startingColumn);
    }

    public static void appendArrayAsExcelRow(String[] array, String filePath, Object sheetNameOrIndex, int startingColumn) {
        AppendArrayAsExcelRow.appendArrayAsTableRow(array, filePath, sheetNameOrIndex, startingColumn);
    }

    public static void appendArrayAsExcelColumn(Number[] array, String filePath, Object sheetNameOrIndex, int startingRow, String columnDataFormat) {
        String[] stringArray = new String[array.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = array[index].toString();
        }
        AppendArrayAsExcelColumn.appendArrayAsTableColumn(stringArray, filePath, sheetNameOrIndex, startingRow, columnDataFormat);
    }

    public static void appendArrayAsExcelColumn(String[] array, String filePath, Object sheetNameOrIndex, int startingRow, String columnDataFormat) {
        AppendArrayAsExcelColumn.appendArrayAsTableColumn(array, filePath, sheetNameOrIndex, startingRow, columnDataFormat);
    }

    public static void setColumnDataFormat(String filePath, Object sheetNameOrIndex, Integer columnNumber, String dataFormatString) {
        SetColumnDataFormat.setColumnDataFormat(filePath, sheetNameOrIndex, columnNumber, dataFormatString);
    }
}

