/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class AppendArrayAsExcelColumn
implements BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());

    protected static void appendArrayAsTableColumn(String[] array, String filePathToExcelWorkbook, Object sheetObject, Integer startingRow, String columnDataFormat) {
        ExcelUtils.setupLogger();
        String[] stringArray = new String[array.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = array[index].toString();
        }
        ExcelUtils excelUtils = new ExcelUtils();
        filePathToExcelWorkbook = excelUtils.fixFilePath(filePathToExcelWorkbook);
        Workbook workbook = excelUtils.getWorkbook(filePathToExcelWorkbook);
        logger.info("Workbook = " + workbook);
        Sheet sheet = excelUtils.getSheet(workbook, sheetObject, true);
        logger.info("Sheet = " + sheet);
        int lastRowIndex = sheet.getLastRowNum();
        int lastColumnIndex = ExcelUtils.getLastColumnNum(sheet);
        int arrayLength = stringArray.length;
        logger.info("Array length = " + arrayLength);
        int arrayIndexCounter = 0;
        startingRow = startingRow < 0 ? 0 : startingRow;
        for (int rowIndex = startingRow.intValue(); rowIndex < startingRow + arrayLength; ++rowIndex) {
            Row row = rowIndex > lastRowIndex ? sheet.createRow(rowIndex) : sheet.getRow(rowIndex);
            Cell cell = row.createCell(lastColumnIndex);
            if (stringArray[arrayIndexCounter].equals("NaN")) {
                stringArray[arrayIndexCounter] = "";
            }
            try {
                cell.setCellValue(Double.parseDouble(stringArray[arrayIndexCounter]));
            }
            catch (Exception e) {
                cell.setCellValue(stringArray[arrayIndexCounter]);
            }
            ++arrayIndexCounter;
        }
        ExcelUtils.setColumnDataFormat(sheet, lastColumnIndex, columnDataFormat);
        excelUtils.saveWorkbook(workbook, filePathToExcelWorkbook);
        logger.info("Saved " + workbook + " at " + filePathToExcelWorkbook);
    }

    @Override
    public void runFromMacro(Object[] parameters) {
        ExcelUtils.setupLogger();
        for (int p = 0; p < parameters.length; ++p) {
            logger.info("Macro parameter " + p + " = " + parameters[p]);
        }
        Object[] inputDataArray = (Object[])parameters[0];
        String[] inputDataArrayAsStringArray = new String[inputDataArray.length];
        for (int dataPoint = 0; dataPoint < inputDataArray.length; ++dataPoint) {
            inputDataArrayAsStringArray[dataPoint] = inputDataArray[dataPoint].toString();
        }
        AppendArrayAsExcelColumn.appendArrayAsTableColumn(inputDataArrayAsStringArray, parameters[1].toString(), parameters[2], (int)Math.round((Double)parameters[3]), parameters[4].toString());
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{4, 1, 1, 2, 1};
    }

    @Override
    public String description() {
        return "Appends data from an array to a defined sheet COLUMN in a defined workbook or creates the latter if not existing yet.\nPossible data formats are described under:\n\n<a href=https://poi.apache.org/apidocs/dev/org/apache/poi/ss/usermodel/BuiltinFormats.html>BuiltinFormats</a>";
    }

    @Override
    public String parameters() {
        return "array, filePathToExcelWorkbook, sheetNameorIndex, startingRow, columnDataFormat";
    }
}

