/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.ImagePlus;
import ij.WindowManager;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Add image to worksheet")
public class AddImageToWorksheet
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter
    ImagePlus imagePlus;
    @Parameter
    File file;
    @Parameter(label="Sheet name or index", description="specify the Excel worksheet name or the 0-based index of the worksheet,non-existing sheets will be automatically created")
    String sheetNameOrIndex;
    @Parameter(description="0-based Excel table column will be the upper left corner of the image added")
    int column;
    @Parameter(description="0-based Excel table row will be the upper left corner of the image added")
    int row;

    public void run() {
        String filePath = this.file.getAbsolutePath();
        int imageID = this.imagePlus.getID();
        AddImageToWorksheet.addImageToWorksheet(this.imagePlus, filePath, this.sheetNameOrIndex, this.column, this.row);
    }

    protected static void addImageToWorksheet(ImagePlus imagePlus, String filePathToExcelWorkbook, Object sheetObject, int column, int row) {
        int rowPictureLocation;
        ExcelUtils.setupLogger();
        logger.info("ImagePlus = " + imagePlus);
        if (imagePlus == null) {
            JOptionPane.showMessageDialog(null, "Specified image could not be found\nor there is no image open", "No such image", 2);
            return;
        }
        ExcelUtils excelUtils = new ExcelUtils();
        filePathToExcelWorkbook = excelUtils.fixFilePath(filePathToExcelWorkbook);
        byte[] imageData = excelUtils.getImageAsByteArray(imagePlus);
        Workbook workbook = excelUtils.getWorkbook(filePathToExcelWorkbook);
        logger.info("Workbook = " + workbook);
        Sheet sheet = excelUtils.getSheet(workbook, sheetObject, true);
        logger.info("Sheet = " + sheet);
        int pictureIndex = workbook.addPicture(imageData, 6);
        CreationHelper helper = workbook.getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        int columnPictureLocation = column;
        Row firstRow = sheet.getRow(0);
        if (columnPictureLocation == -1 && firstRow != null) {
            columnPictureLocation = sheet.getRow(0).getLastCellNum();
        }
        if ((rowPictureLocation = row) == -1) {
            rowPictureLocation = sheet.getLastRowNum() + 1;
        }
        anchor.setCol1(columnPictureLocation);
        anchor.setRow1(rowPictureLocation);
        Drawing drawing = sheet.createDrawingPatriarch();
        Picture pict = drawing.createPicture(anchor, pictureIndex);
        pict.resize();
        excelUtils.saveWorkbook(workbook, filePathToExcelWorkbook);
    }

    @Override
    public void runFromMacro(Object[] parameters) {
        ExcelUtils.setupLogger();
        for (int p = 0; p < parameters.length; ++p) {
            logger.info("Macro parameter " + p + " = " + parameters[p]);
        }
        AddImageToWorksheet.addImageToWorksheet(WindowManager.getImage((int)((int)Math.round((Double)parameters[0]))), (String)parameters[1], parameters[2], ((Double)parameters[3]).intValue(), ((Double)parameters[4]).intValue());
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{2, 1, 1, 2, 2};
    }

    @Override
    public String description() {
        return "Adds a specified image (using the negative image ID) or the active image if no image is given to the specified Excel worksheet in a specified workbook file or creates a new workbook file if the specified one is not existing.\nIf a column and row is specified, the upper left corner of the image is at that position.If value for column = 0, the image will be placed after the last column with data.If row = 0, the image will be placed after the third row.";
    }

    @Override
    public String parameters() {
        return "imageID, filePathToExcelWorkbook, sheetNameOrIndex, column, row";
    }
}

