/**
 * 
 */
package excel.functions.plugins;

import java.io.File;
import java.util.logging.Logger;

import org.apache.poi.ss.usermodel.Workbook;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.macro.MacroExtension;

/**
 * @author BioVoxxel
 *
 */

@Plugin(type = Command.class, menuPath = "Plugins>BioVoxxel>Delete worksheet")
public class DeleteWorkbookSheet implements Command, BioVoxxelMacroExtensionDescriptor {
	
	protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
	
	@Parameter(required = true)
    private File file;
	
	@Parameter(label = "Sheet name or index", initializer = "", style = "", required = true)
	private String sheetNameOrIndex;
	

	
	@Override
	public void run() {
		
		String filePath = (file == null) ? "" : file.getAbsolutePath();
		
		deleteWorkbookSheet(filePath, sheetNameOrIndex);
		
	}

	
	protected static void deleteWorkbookSheet(String filePathToExcelWorkbook, Object sheetObject) {
		ExcelUtils.setupLogger();
		ExcelUtils excelUtils = new ExcelUtils();
		filePathToExcelWorkbook = excelUtils.fixFilePath(filePathToExcelWorkbook);
				
		Workbook workbook = excelUtils.getWorkbook(filePathToExcelWorkbook);
		
		int sheetIndex = excelUtils.getSheetIndex(workbook, sheetObject);
				
		if (sheetIndex >= 0) {
			workbook.removeSheetAt(sheetIndex);
		}
												
		excelUtils.saveWorkbook(workbook, filePathToExcelWorkbook);
		
	}
	
	
	@Override
	public void runFromMacro(Object[] parameters) {
		
		ExcelUtils.setupLogger();
		
		for (int p = 0; p < parameters.length; p++) {
			logger.info("Macro parameter " + p +" = " + parameters[p]);
		}
		
		deleteWorkbookSheet((String)parameters[0], parameters[1]);
		
	}

	@Override
	public int[] parameterTypes() {
		 return new int[] { MacroExtension.ARG_STRING, MacroExtension.ARG_STRING };
	}

	@Override
	public String description() {
		return "Deletes a specified sheet in a specified Excel workbook. The sheet can be given by name or 0-based sheet index";
	}

	@Override
	public String parameters() {
		
		return "filePathToExcelWorkbook, sheetNameOrIndex";
	}

}
