/**
 * 
 */
package excel.functions.plugins;

import java.util.logging.Logger;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.macro.MacroExtension;

/**
 * @author BioVoxxel
 *
 */
public class AppendArrayAsExcelRow implements BioVoxxelMacroExtensionDescriptor {

	protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
	
	protected static void appendArrayAsTableRow(String[] array, String filePathToExcelWorkbook, Object sheetObject, Integer startingColumn) {
		
		ExcelUtils.setupLogger();
		
		ExcelUtils excelUtils = new ExcelUtils();
		filePathToExcelWorkbook = excelUtils.fixFilePath(filePathToExcelWorkbook);
		
		Workbook workbook = excelUtils.getWorkbook(filePathToExcelWorkbook);
		logger.info("Workbook = " + workbook);
		
		Sheet sheet = excelUtils.getSheet(workbook, sheetObject, true);
		logger.info("Sheet = " + sheet);
		
		int lastRowNumber = sheet.getLastRowNum();
		logger.info("Last row number = " + lastRowNumber);
		
		Row row = sheet.createRow(lastRowNumber + 1);
		logger.info("Row = " + row);
		
		startingColumn = (startingColumn < 0) ? 0 : startingColumn;
		
		for (int columnIndex = 0; columnIndex < array.length; columnIndex++) {
			
			Cell cell = row.createCell(startingColumn + columnIndex);
			
			if (array[columnIndex].equals("NaN")) {
				array[columnIndex] = "";
			}
			
			try {
				cell.setCellValue(Double.parseDouble(array[columnIndex]));
			} catch (Exception e) {
				cell.setCellValue(array[columnIndex]);
			}
		}
		
		excelUtils.saveWorkbook(workbook, filePathToExcelWorkbook);
		logger.info("Saved " + workbook + " at " + filePathToExcelWorkbook);
	}
	
	@Override
	public void runFromMacro(Object[] parameters) {

		ExcelUtils.setupLogger();
		
		for (int p = 0; p < parameters.length; p++) {
			logger.info("Macro parameter " + p +" = " + parameters[p]);
		}
		
		Object[] inputDataArray = (Object[])parameters[0];
		String[] inputDataArrayAsStringArray = new String[inputDataArray.length];
		
		for (int dataPoint = 0; dataPoint < inputDataArray.length; dataPoint++) {
			inputDataArrayAsStringArray[dataPoint] = inputDataArray[dataPoint].toString();
		}
				
		appendArrayAsTableRow(inputDataArrayAsStringArray, parameters[1].toString(), parameters[2], (int)Math.round((Double)parameters[3]));
	}

	@Override
	public int[] parameterTypes() {
		return new int[] { MacroExtension.ARG_ARRAY, MacroExtension.ARG_STRING, MacroExtension.ARG_STRING, MacroExtension.ARG_NUMBER };
	}

	@Override
	public String description() {
		
		return "Appends data from an array to a defined sheet ROW in a defined workbook or creates the latter if not existing yet.";
	}

	@Override
	public String parameters() {
		return "array, filePathToExcelWorkbook, sheetNameorIndex, startingColumn";
	}

}
