/*
 * Decompiled with CFR 0.152.
 */
package ij.blob;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RotatingCalipers {
    public static double getArea(Point2D.Double[] rectangle) {
        double deltaXAB = rectangle[0].x - rectangle[1].x;
        double deltaYAB = rectangle[0].y - rectangle[1].y;
        double deltaXBC = rectangle[1].x - rectangle[2].x;
        double deltaYBC = rectangle[1].y - rectangle[2].y;
        double lengthAB = Math.sqrt(deltaXAB * deltaXAB + deltaYAB * deltaYAB);
        double lengthBC = Math.sqrt(deltaXBC * deltaXBC + deltaYBC * deltaYBC);
        return lengthAB * lengthBC;
    }

    public static List<Point2D.Double[]> getAllBoundingRectangles(int[] xs, int[] ys) throws IllegalArgumentException {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < xs.length; ++i) {
            points.add(new Point(xs[i], ys[i]));
        }
        return RotatingCalipers.getAllBoundingRectangles(points);
    }

    public static List<Point2D.Double[]> getAllBoundingRectangles(List<Point> points) throws IllegalArgumentException {
        ArrayList<Point2D.Double[]> rectangles = new ArrayList<Point2D.Double[]>();
        List<Point> convexHull = GrahamScan.getConvexHull(points);
        Caliper I = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.UPPER_RIGHT), 90.0);
        Caliper J = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.UPPER_LEFT), 180.0);
        Caliper K = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.LOWER_LEFT), 270.0);
        Caliper L = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.LOWER_RIGHT), 0.0);
        while (L.currentAngle < 90.0) {
            rectangles.add(new Point2D.Double[]{L.getIntersection(I), I.getIntersection(J), J.getIntersection(K), K.getIntersection(L)});
            double smallestTheta = RotatingCalipers.getSmallestTheta(I, J, K, L);
            I.rotateBy(smallestTheta);
            J.rotateBy(smallestTheta);
            K.rotateBy(smallestTheta);
            L.rotateBy(smallestTheta);
        }
        return rectangles;
    }

    public static Point2D.Double[] getMinimumBoundingRectangle(int[] xs, int[] ys) throws IllegalArgumentException {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < xs.length; ++i) {
            points.add(new Point(xs[i], ys[i]));
        }
        return RotatingCalipers.getMinimumBoundingRectangle(points);
    }

    public static Point2D.Double[] getMinimumBoundingRectangle(List<Point> points) throws IllegalArgumentException {
        List<Point2D.Double[]> rectangles = RotatingCalipers.getAllBoundingRectangles(points);
        Point2D.Double[] minimum = null;
        double area = 9.223372036854776E18;
        for (Point2D.Double[] rectangle : rectangles) {
            double tempArea = RotatingCalipers.getArea(rectangle);
            if (minimum != null && !(tempArea < area)) continue;
            minimum = rectangle;
            area = tempArea;
        }
        return minimum;
    }

    private static double getSmallestTheta(Caliper I, Caliper J, Caliper K, Caliper L) {
        double thetaI = I.getDeltaAngleNextPoint();
        double thetaJ = J.getDeltaAngleNextPoint();
        double thetaK = K.getDeltaAngleNextPoint();
        double thetaL = L.getDeltaAngleNextPoint();
        if (thetaI <= thetaJ && thetaI <= thetaK && thetaI <= thetaL) {
            return thetaI;
        }
        if (thetaJ <= thetaK && thetaJ <= thetaL) {
            return thetaJ;
        }
        if (thetaK <= thetaL) {
            return thetaK;
        }
        return thetaL;
    }

    protected static int getIndex(List<Point> convexHull, Corner corner) {
        int index = 0;
        Point point = convexHull.get(index);
        for (int i = 1; i < convexHull.size() - 1; ++i) {
            Point temp = convexHull.get(i);
            boolean change = false;
            switch (corner) {
                case UPPER_RIGHT: {
                    change = temp.x > point.x || temp.x == point.x && temp.y > point.y;
                    break;
                }
                case UPPER_LEFT: {
                    change = temp.y > point.y || temp.y == point.y && temp.x < point.x;
                    break;
                }
                case LOWER_LEFT: {
                    change = temp.x < point.x || temp.x == point.x && temp.y < point.y;
                    break;
                }
                case LOWER_RIGHT: {
                    boolean bl = change = temp.y < point.y || temp.y == point.y && temp.x > point.x;
                }
            }
            if (!change) continue;
            index = i;
            point = temp;
        }
        return index;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrahamScan {
        private GrahamScan() {
        }

        protected static boolean areAllCollinear(List<Point> points) {
            if (points.size() < 2) {
                return true;
            }
            Point a = points.get(0);
            Point b = points.get(1);
            for (int i = 2; i < points.size(); ++i) {
                Point c = points.get(i);
                if (GrahamScan.getTurn(a, b, c) == Turn.COLLINEAR) continue;
                return false;
            }
            return true;
        }

        public static List<Point> getConvexHull(List<Point> points) throws IllegalArgumentException {
            ArrayList<Point> sorted = new ArrayList<Point>(GrahamScan.getSortedPointSet(points));
            if (sorted.size() < 3) {
                throw new IllegalArgumentException("can only create a convex hull of 3 or more unique points");
            }
            if (GrahamScan.areAllCollinear(sorted)) {
                throw new IllegalArgumentException("cannot create a convex hull from collinear points");
            }
            Stack stack = new Stack();
            stack.push(sorted.get(0));
            stack.push(sorted.get(1));
            block5: for (int i = 2; i < sorted.size(); ++i) {
                Point head = (Point)sorted.get(i);
                Point middle = (Point)stack.pop();
                Point tail = (Point)stack.peek();
                Turn turn = GrahamScan.getTurn(tail, middle, head);
                switch (turn) {
                    case COUNTER_CLOCKWISE: {
                        stack.push(middle);
                        stack.push(head);
                        continue block5;
                    }
                    case CLOCKWISE: {
                        --i;
                        continue block5;
                    }
                    case COLLINEAR: {
                        stack.push(head);
                    }
                }
            }
            stack.push(sorted.get(0));
            return new ArrayList<Point>(stack);
        }

        protected static Point getLowestPoint(List<Point> points) {
            Point lowest = points.get(0);
            for (int i = 1; i < points.size(); ++i) {
                Point temp = points.get(i);
                if (temp.y >= lowest.y && (temp.y != lowest.y || temp.x >= lowest.x)) continue;
                lowest = temp;
            }
            return lowest;
        }

        protected static Set<Point> getSortedPointSet(List<Point> points) {
            final Point lowest = GrahamScan.getLowestPoint(points);
            TreeSet<Point> set = new TreeSet<Point>(new Comparator<Point>(){

                @Override
                public int compare(Point a, Point b) {
                    double distanceB;
                    double thetaB;
                    if (a == b || a.equals(b)) {
                        return 0;
                    }
                    double thetaA = Math.atan2((long)a.y - (long)lowest.y, (long)a.x - (long)lowest.x);
                    if (thetaA < (thetaB = Math.atan2((long)b.y - (long)lowest.y, (long)b.x - (long)lowest.x))) {
                        return -1;
                    }
                    if (thetaA > thetaB) {
                        return 1;
                    }
                    double distanceA = Math.sqrt(((long)lowest.x - (long)a.x) * ((long)lowest.x - (long)a.x) + ((long)lowest.y - (long)a.y) * ((long)lowest.y - (long)a.y));
                    if (distanceA < (distanceB = Math.sqrt(((long)lowest.x - (long)b.x) * ((long)lowest.x - (long)b.x) + ((long)lowest.y - (long)b.y) * ((long)lowest.y - (long)b.y)))) {
                        return -1;
                    }
                    return 1;
                }
            });
            set.addAll(points);
            return set;
        }

        protected static Turn getTurn(Point a, Point b, Point c) {
            double crossProduct = ((long)b.x - (long)a.x) * ((long)c.y - (long)a.y) - ((long)b.y - (long)a.y) * ((long)c.x - (long)a.x);
            if (crossProduct > 0.0) {
                return Turn.COUNTER_CLOCKWISE;
            }
            if (crossProduct < 0.0) {
                return Turn.CLOCKWISE;
            }
            return Turn.COLLINEAR;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum Turn {
            CLOCKWISE,
            COUNTER_CLOCKWISE,
            COLLINEAR;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Caliper {
        static final double SIGMA = 1.0E-11;
        final List<Point> convexHull;
        int pointIndex;
        double currentAngle;

        Caliper(List<Point> convexHull, int pointIndex, double currentAngle) {
            this.convexHull = convexHull;
            this.pointIndex = pointIndex;
            this.currentAngle = currentAngle;
        }

        double getAngleNextPoint() {
            Point p1 = this.convexHull.get(this.pointIndex);
            Point p2 = this.convexHull.get((this.pointIndex + 1) % this.convexHull.size());
            double deltaY = p2.y - p1.y;
            double deltaX = p2.x - p1.x;
            double angle = Math.atan2(deltaY, deltaX) * 180.0 / Math.PI;
            return angle < 0.0 ? 360.0 + angle : angle;
        }

        double getConstant() {
            Point p = this.convexHull.get(this.pointIndex);
            return (double)p.y - this.getSlope() * (double)p.x;
        }

        double getDeltaAngleNextPoint() {
            double angle = this.getAngleNextPoint();
            angle = angle < 0.0 ? 360.0 + angle - this.currentAngle : angle - this.currentAngle;
            return angle < 0.0 ? 360.0 : angle;
        }

        Point2D.Double getIntersection(Caliper that) {
            double x = this.isVertical() ? (double)this.convexHull.get((int)this.pointIndex).x : (this.isHorizontal() ? (double)that.convexHull.get((int)that.pointIndex).x : (that.getConstant() - this.getConstant()) / (this.getSlope() - that.getSlope()));
            double y = this.isVertical() ? that.getConstant() : (this.isHorizontal() ? this.getConstant() : this.getSlope() * x + this.getConstant());
            return new Point2D.Double(x, y);
        }

        double getSlope() {
            return Math.tan(Math.toRadians(this.currentAngle));
        }

        boolean isHorizontal() {
            return Math.abs(this.currentAngle) < 1.0E-11 || Math.abs(this.currentAngle - 180.0) < 1.0E-11;
        }

        boolean isVertical() {
            return Math.abs(this.currentAngle - 90.0) < 1.0E-11 || Math.abs(this.currentAngle - 270.0) < 1.0E-11;
        }

        void rotateBy(double angle) {
            if (this.getDeltaAngleNextPoint() == angle) {
                ++this.pointIndex;
            }
            this.currentAngle += angle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Corner {
        UPPER_RIGHT,
        UPPER_LEFT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

