/*
 * Decompiled with CFR 0.152.
 */
package ij.blob;

import ij.IJ;
import ij.ImagePlus;
import ij.blob.CustomBlobFeature;
import ij.blob.FractalBoxCounterBlob;
import ij.blob.RotatingCalipers;
import ij.gui.NewImage;
import ij.gui.PolygonRoi;
import ij.measure.Calibration;
import ij.plugin.filter.EDM;
import ij.plugin.filter.MaximumFinder;
import ij.process.ByteProcessor;
import ij.process.EllipseFitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.PolygonFiller;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Blob {
    public static final int DRAW_HOLES = 1;
    public static final int DRAW_CONVEX_HULL = 2;
    public static final int DRAW_LABEL = 4;
    private static Color defaultColor = Color.black;
    private Polygon outerContour;
    private ArrayList<Polygon> innerContours;
    private int label;
    private Point2D centerOfGrafity = null;
    private double perimeter = -1.0;
    private double perimeterConvexHull = -1.0;
    private double enclosedArea = -1.0;
    private double circularity = -1.0;
    private double thinnesRatio = -1.0;
    private double areaToPerimeterRatio = -1.0;
    private double temperature = -1.0;
    private double fractalBoxDimension = -1.0;
    private double fractalDimensionGoodness = -1.0;
    private double elongation = -1.0;
    private double eigenMajor = -1.0;
    private double eigenMinor = -1.0;
    private double orientation = -1.0;
    private double convexity = -1.0;
    private double solidity = -1.0;
    private double areaConvexHull = -1.0;
    private Calibration cal = new Calibration();
    private double[][] centralMomentsLUT = new double[][]{{-1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0}};
    private double[][] momentsLUT = new double[][]{{-1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0}};
    EllipseFitter fittedEllipse = null;
    static ArrayList<CustomBlobFeature> customFeatures = new ArrayList();
    public static final String GETFERETDIAMETER = "getFeretDiameter";
    public static final String GETMINFERETDIAMETER = "getMinFeretDiameter";
    public static final String GETORIENTATIONMAJORAXIS = "getOrientationMajorAxis";
    public static final String GETORIENTATIONMINORAXIS = "getOrientationMinorAxis";
    public static final String GETELONGATION = "getElongation";
    public static final String GETLONGSIDEMBR = "getLongSideMBR";
    public static final String GETSHORTSIDEMBR = "getShortSideMBR";
    public static final String GETASPECTRATIO = "getAspectRatio";
    public static final String GETPERIMETER = "getPerimeter";
    public static final String GETPERIMETERCONVEXHULL = "getPerimeterConvexHull";
    public static final String GETCONVEXITY = "getConvexity";
    public static final String GETSOLIDITY = "getSolidity";
    public static final String GETENCLOSEDAREA = "getEnclosedArea";
    public static final String GETAREACONVEXHULL = "getAreaConvexHull";
    public static final String GETCIRCULARITY = "getCircularity";
    public static final String GETTHINNESRATIO = "getThinnesRatio";
    public static final String GETAREATOPERIMETERRATIO = "getAreaToPerimeterRatio";
    public static final String GETCONTOURTEMPERATURE = "getContourTemperature";
    public static final String GETDIAMETERMAXIMUMINSCRIBEDCIRCLE = "getDiamaterMaximumInscribedCircle";
    public static final String GETFRACTALBOXDIMENSION = "getFractalBoxDimension";
    public static final String GETNUMBEROFHOLES = "getNumberofHoles";

    public Blob(Polygon outerContour, int label) {
        this.outerContour = outerContour;
        this.label = label;
        this.innerContours = new ArrayList();
    }

    public Blob(Polygon outerContour, int label, Calibration cal) {
        this.outerContour = outerContour;
        this.label = label;
        this.innerContours = new ArrayList();
        this.cal = cal;
    }

    public void setCalibration(Calibration cal) {
        this.cal = cal;
    }

    public static void addCustomFeature(CustomBlobFeature feature) {
        customFeatures.add(feature);
    }

    public static void setDefaultColor(Color defaultColor) {
        Blob.defaultColor = defaultColor;
    }

    public Object evaluateCustomFeature(String methodName, Object ... params) throws NoSuchMethodException {
        Boolean methodfound = false;
        int featureIndex = -1;
        for (int i = 0; i < customFeatures.size(); ++i) {
            Method[] customMethods = customFeatures.get(i).getClass().getDeclaredMethods();
            for (int j = 0; j < customMethods.length; ++j) {
                if (customMethods[j].getName() != methodName) continue;
                methodfound = true;
                featureIndex = i;
                break;
            }
            if (methodfound.booleanValue()) break;
        }
        Class[] classparams = new Class[]{};
        if (params.length > 0) {
            classparams = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classparams[i] = params[i].getClass();
            }
        }
        Object value = 0;
        try {
            customFeatures.get(featureIndex).setup(this);
            Method m = customFeatures.get(featureIndex).getClass().getMethod(methodName, classparams);
            value = m.invoke((Object)customFeatures.get(featureIndex), params);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("The method " + methodName + " was not found");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    void draw(ImageProcessor ip, int options, Color col) {
        ip.setColor(col);
        this.fillPolygon(ip, this.outerContour, false);
        if ((options & 1) > 0) {
            for (int i = 0; i < this.innerContours.size(); ++i) {
                if (defaultColor == Color.white) {
                    ip.setColor(Color.BLACK);
                } else {
                    ip.setColor(Color.white);
                }
                this.fillPolygon(ip, this.innerContours.get(i), true);
                if (defaultColor == Color.white) {
                    ip.setColor(Color.white);
                } else {
                    ip.setColor(Color.black);
                }
                ip.drawPolygon(this.innerContours.get(i));
            }
        }
        if ((options & 2) > 0) {
            ip.setColor(Color.RED);
            ip.drawPolygon(this.getConvexHull());
        }
        if ((options & 4) > 0) {
            Point2D cog = this.getCenterOfGravity();
            ip.setColor(Color.MAGENTA);
            ip.drawString("" + this.getLabel(), (int)cog.getX(), (int)cog.getX());
        }
    }

    public void draw(ImageProcessor ip, int options) {
        this.draw(ip, options, defaultColor);
    }

    void draw(ImageProcessor ip, int options, int deltax, int deltay) {
        ip.setColor(Color.BLACK);
        Polygon p = new Polygon(this.outerContour.xpoints, this.outerContour.ypoints, this.outerContour.npoints);
        p.translate(deltax, deltay);
        this.fillPolygon(ip, p, false);
        if ((options & 1) > 0) {
            for (int i = 0; i < this.innerContours.size(); ++i) {
                ip.setColor(Color.WHITE);
                p = new Polygon(this.innerContours.get((int)i).xpoints, this.innerContours.get((int)i).ypoints, this.innerContours.get((int)i).npoints);
                p.translate(deltax, deltay);
                this.fillPolygon(ip, p, true);
            }
        }
        if ((options & 2) > 0) {
            ip.setColor(Color.RED);
            ip.drawPolygon(this.getConvexHull());
        }
        if ((options & 4) > 0) {
            Point2D cog = this.getCenterOfGravity();
            ip.setColor(Color.MAGENTA);
            ip.drawString("" + this.getLabel(), (int)cog.getX(), (int)cog.getY());
        }
    }

    public void draw(ImageProcessor ip) {
        this.draw(ip, 1);
    }

    void drawLabels(ImageProcessor ip, Color col) {
        this.draw(ip, 1, col);
    }

    private final double getArea(Polygon p) {
        if (p == null) {
            return Double.NaN;
        }
        int carea = 0;
        for (int i = 0; i < p.npoints; ++i) {
            int iminus1 = i - 1;
            if (iminus1 < 0) {
                iminus1 = p.npoints - 1;
            }
            carea += (p.xpoints[i] + p.xpoints[iminus1]) * (p.ypoints[i] - p.ypoints[iminus1]);
        }
        return Math.abs((double)carea / 2.0);
    }

    public Point2D getCenterOfGravity() {
        if (this.centerOfGrafity != null) {
            return this.centerOfGrafity;
        }
        this.centerOfGrafity = new Point2D.Float();
        int[] x = this.outerContour.xpoints;
        int[] y = this.outerContour.ypoints;
        int sumx = 0;
        int sumy = 0;
        double A = 0.0;
        for (int i = 0; i < this.outerContour.npoints - 1; ++i) {
            int cross = x[i] * y[i + 1] - x[i + 1] * y[i];
            sumx += (x[i] + x[i + 1]) * cross;
            sumy += (y[i] + y[i + 1]) * cross;
            A = A + (double)(x[i] * y[i + 1]) - (double)(x[i + 1] * y[i]);
        }
        A = 0.5 * A;
        this.centerOfGrafity.setLocation(this.cal.getX((double)sumx / (6.0 * A)), this.cal.getY((double)sumy / (6.0 * A)));
        if (this.getEnclosedArea() == 1.0) {
            this.centerOfGrafity.setLocation(this.cal.getX((double)x[0]), this.cal.getY((double)y[0]));
        }
        return this.centerOfGrafity;
    }

    public double getFeretDiameter() {
        PolygonRoi proi = new PolygonRoi(this.outerContour, 6);
        ImagePlus imp = new ImagePlus();
        imp.setCalibration(this.cal);
        proi.setImage(imp);
        return proi.getFeretsDiameter();
    }

    public double getMinFeretDiameter() {
        PolygonRoi proi = new PolygonRoi(this.outerContour, 6);
        ImagePlus imp = new ImagePlus();
        imp.setCalibration(this.cal);
        proi.setImage(imp);
        return proi.getFeretValues()[2];
    }

    public double getMoment(int p, int q) {
        if (p <= 2 && q <= 2 && this.momentsLUT[p][q] != -1.0) {
            return this.momentsLUT[p][q];
        }
        double moment = 0.0;
        Rectangle bounds = this.outerContour.getBounds();
        for (int x = bounds.x; x < bounds.x + bounds.width + 1; ++x) {
            for (int y = bounds.y; y < bounds.y + bounds.height + 1; ++y) {
                if (!this.outerContour.contains((double)x, (double)y)) continue;
                moment += Math.pow(this.cal.getX((double)x), p) * Math.pow(this.cal.getY((double)y), q);
            }
        }
        this.momentsLUT[p][q] = moment;
        return moment;
    }

    public double getCentralMoments(int p, int q) {
        if (p <= 2 && q <= 2 && this.centralMomentsLUT[p][q] != -1.0) {
            return this.centralMomentsLUT[p][q];
        }
        double centralMoment = 0.0;
        double m00 = this.getMoment(0, 0);
        double xc = this.getMoment(1, 0) / m00;
        double yc = this.getMoment(0, 1) / m00;
        if (p == 0 && q == 0) {
            centralMoment = m00;
        } else if (p == 0 && q == 1 || p == 1 && q == 0) {
            centralMoment = 0.0;
        } else if (p == 1 && q == 1) {
            centralMoment = this.getMoment(1, 1) - yc * this.getMoment(1, 0);
        } else if (p == 2 && q == 0) {
            centralMoment = this.getMoment(p, q) - xc * this.getMoment(1, 0);
        } else if (p == 0 && q == 2) {
            centralMoment = this.getMoment(p, q) - yc * this.getMoment(0, 1);
        } else {
            Rectangle bounds = this.outerContour.getBounds();
            for (int x = bounds.x; x < bounds.x + bounds.width; ++x) {
                for (int y = bounds.y; y < bounds.y + bounds.height; ++y) {
                    if (!this.outerContour.contains(x, y)) continue;
                    centralMoment += Math.pow(this.cal.getX((double)x) - xc, p) * Math.pow(this.cal.getY((double)y) - yc, q);
                }
            }
        }
        this.centralMomentsLUT[p][q] = centralMoment;
        return centralMoment;
    }

    public double getOrientationMajorAxis() {
        if (this.orientation != -1.0) {
            return this.orientation;
        }
        this.fitEllipse();
        this.orientation = this.fittedEllipse.angle;
        if (Math.abs(this.orientation - 180.0) < 0.01) {
            this.orientation = 0.0;
        }
        return this.orientation;
    }

    public double getOrientationMinorAxis() {
        if (this.orientation != -1.0) {
            return this.orientation - 90.0;
        }
        this.orientation = this.getOrientationMajorAxis();
        return this.orientation - 90.0;
    }

    private double getEigenvalue(boolean major) {
        double c00 = this.getCentralMoments(0, 0);
        double c20 = this.getCentralMoments(2, 0) / c00;
        double c02 = this.getCentralMoments(0, 2) / c00;
        double c11 = this.getCentralMoments(1, 1) / c00;
        double valuea = 0.5 * (c20 + c02) + 0.5 * Math.sqrt(4.0 * Math.pow(c11, 2.0) + Math.pow(c20 - c02, 2.0));
        double valueb = 0.5 * (c20 + c02) - 0.5 * Math.sqrt(4.0 * Math.pow(c11, 2.0) + Math.pow(c20 - c02, 2.0));
        double value = valuea;
        if (major) {
            if (valuea < valueb) {
                value = valueb;
            }
        } else if (valuea > valueb) {
            value = valueb;
        }
        return value;
    }

    public double getEigenvalueMajorAxis() {
        if (this.eigenMajor != -1.0) {
            return this.eigenMajor;
        }
        this.eigenMajor = this.getEigenvalue(true);
        return this.eigenMajor;
    }

    public double getEigenvalueMinorAxis() {
        if (this.eigenMinor != -1.0) {
            return this.eigenMinor;
        }
        this.eigenMinor = this.getEigenvalue(false);
        return this.eigenMinor;
    }

    public double getElongation() {
        if (this.elongation != -1.0) {
            return this.elongation;
        }
        this.fitEllipse();
        this.elongation = 1.0 - this.fittedEllipse.minor / this.fittedEllipse.major;
        this.elongation = Math.sqrt(this.elongation);
        return this.elongation;
    }

    public Point[] getMinimumBoundingRectangle() {
        Point2D.Double[] mbr;
        int[] xp = new int[this.getOuterContour().npoints];
        int[] yp = new int[this.getOuterContour().npoints];
        for (int i = 0; i < this.getOuterContour().npoints; ++i) {
            xp[i] = this.getOuterContour().xpoints[i];
            yp[i] = this.getOuterContour().ypoints[i];
        }
        try {
            mbr = RotatingCalipers.getMinimumBoundingRectangle(xp, yp);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Point[] p = new Point[4];
        for (int i = 0; i < mbr.length; ++i) {
            p[i] = new Point();
            p[i].x = (int)mbr[i].x;
            p[i].y = (int)mbr[i].y;
        }
        return p;
    }

    public double getLongSideMBR() {
        double secondSide;
        Point[] mbr = this.getMinimumBoundingRectangle();
        if (mbr == null) {
            return Double.NaN;
        }
        double firstSide = Math.sqrt(Math.pow(this.cal.getX((double)mbr[1].x) - this.cal.getX((double)mbr[0].x), 2.0) + Math.pow(this.cal.getY((double)mbr[1].y) - this.cal.getY((double)mbr[0].y), 2.0));
        return firstSide > (secondSide = Math.sqrt(Math.pow(this.cal.getX((double)mbr[1].x) - this.cal.getX((double)mbr[2].x), 2.0) + Math.pow(this.cal.getY((double)mbr[1].y) - this.cal.getY((double)mbr[2].y), 2.0))) ? firstSide : secondSide;
    }

    public double getShortSideMBR() {
        double secondSide;
        Point[] mbr = this.getMinimumBoundingRectangle();
        if (mbr == null) {
            return Double.NaN;
        }
        double firstSide = Math.sqrt(Math.pow(this.cal.getX((double)mbr[1].x) - this.cal.getX((double)mbr[0].x), 2.0) + Math.pow(this.cal.getY((double)mbr[1].y) - this.cal.getY((double)mbr[0].y), 2.0));
        return firstSide < (secondSide = Math.sqrt(Math.pow(this.cal.getX((double)mbr[1].x) - this.cal.getX((double)mbr[2].x), 2.0) + Math.pow(this.cal.getY((double)mbr[1].y) - this.cal.getY((double)mbr[2].y), 2.0))) ? firstSide : secondSide;
    }

    public double getAspectRatio() {
        return this.getLongSideMBR() / this.getShortSideMBR();
    }

    private void fitEllipse() {
        if (this.fittedEllipse == null) {
            this.fittedEllipse = new EllipseFitter();
            Rectangle r = this.outerContour.getBounds();
            ImagePlus help = NewImage.createByteImage((String)"", (int)(r.width + 1), (int)(r.height + 1), (int)1, (int)4);
            ByteProcessor ip = (ByteProcessor)help.getProcessor();
            ip.setColor(Color.black);
            Polygon p = new Polygon(this.outerContour.xpoints, this.outerContour.ypoints, this.outerContour.npoints);
            p.translate(-r.x, -r.y);
            ip.resetRoi();
            ip.setRoi(p);
            this.fittedEllipse.fit((ImageProcessor)ip, null);
        }
    }

    private void fillPolygon(ImageProcessor ip, Polygon p, boolean internContour) {
        PolygonRoi proi = new PolygonRoi(p, 2);
        Rectangle r = proi.getBounds();
        PolygonFiller pf = new PolygonFiller();
        pf.setPolygon(proi.getXCoordinates(), proi.getYCoordinates(), proi.getNCoordinates());
        ip.setRoi(r);
        ImageProcessor objectMask = pf.getMask(r.width, r.height);
        ip.fill(objectMask);
        if (!internContour) {
            ip.drawPolygon(p);
        }
    }

    public Polygon getOuterContour() {
        return this.outerContour;
    }

    public int[] getOuterContourAsChainCode() {
        return this.contourToChainCode(this.getOuterContour());
    }

    public ArrayList<Polygon> getInnerContours() {
        return this.innerContours;
    }

    void addInnerContour(Polygon contour) {
        this.innerContours.add(contour);
    }

    public int getLabel() {
        return this.label;
    }

    public double getPerimeter() {
        if (this.perimeter != -1.0) {
            return this.perimeter;
        }
        return this.getPerimeterOfContour(this.getOuterContour());
    }

    private double getPerimeterOfContour(Polygon contour) {
        double peri = 0.0;
        if (contour.npoints == 1) {
            peri = 1.0;
            return peri;
        }
        int[] cc = this.contourToChainCode(contour);
        int sum_gerade = 0;
        for (int i = 0; i < cc.length; ++i) {
            if (cc[i] % 2 != 0) continue;
            ++sum_gerade;
        }
        peri = (double)sum_gerade * 0.948 + (double)(cc.length - sum_gerade) * 1.34;
        PolygonRoi roi = new PolygonRoi(this.outerContour, 6);
        ImagePlus dummy = new ImagePlus();
        dummy.setCalibration(this.cal);
        roi.setImage(dummy);
        return peri;
    }

    private int[] contourToChainCode(Polygon contour) {
        int[] chaincode = new int[contour.npoints - 1];
        for (int i = 1; i < contour.npoints; ++i) {
            int dx = contour.xpoints[i] - contour.xpoints[i - 1];
            int dy = contour.ypoints[i] - contour.ypoints[i - 1];
            if (dx == 1 && dy == 0) {
                chaincode[i - 1] = 0;
                continue;
            }
            if (dx == 1 && dy == 1) {
                chaincode[i - 1] = 7;
                continue;
            }
            if (dx == 0 && dy == 1) {
                chaincode[i - 1] = 6;
                continue;
            }
            if (dx == -1 && dy == 1) {
                chaincode[i - 1] = 5;
                continue;
            }
            if (dx == -1 && dy == 0) {
                chaincode[i - 1] = 4;
                continue;
            }
            if (dx == -1 && dy == -1) {
                chaincode[i - 1] = 3;
                continue;
            }
            if (dx == 0 && dy == -1) {
                chaincode[i - 1] = 2;
                continue;
            }
            if (dx != 1 || dy != -1) continue;
            chaincode[i - 1] = 1;
        }
        return chaincode;
    }

    public double getPerimeterConvexHull() {
        if (this.perimeterConvexHull != -1.0) {
            return this.perimeterConvexHull;
        }
        PolygonRoi convexRoi = null;
        Polygon hull = this.getConvexHull();
        this.perimeterConvexHull = 0.0;
        try {
            convexRoi = new PolygonRoi(hull, 2);
            ImagePlus dummy = new ImagePlus();
            dummy.setCalibration(this.cal);
            convexRoi.setImage(dummy);
            this.perimeterConvexHull = convexRoi.getLength();
        }
        catch (Exception e) {
            this.perimeterConvexHull = this.getPerimeter();
            IJ.log((String)("Blob ID: " + this.getLabel() + " Error calculating the perimeter of the convex hull. Returning the regular perimeter"));
        }
        return this.perimeterConvexHull;
    }

    public double getConvexity() {
        if (this.convexity != -1.0) {
            return this.convexity;
        }
        this.convexity = this.getPerimeterConvexHull() / this.getPerimeter();
        if (this.convexity > 1.0) {
            this.convexity = 1.0;
        }
        return this.convexity;
    }

    public boolean isOnEdge(ImageProcessor ip) {
        Polygon p = this.getOuterContour();
        for (int i = 0; i < p.npoints; ++i) {
            int x = p.xpoints[i];
            int y = p.ypoints[i];
            if (x != 0 && y != 0 && x != ip.getWidth() - 1 && y != ip.getHeight() - 1) continue;
            return true;
        }
        return false;
    }

    public double getSolidity() {
        if (this.solidity != -1.0) {
            return this.solidity;
        }
        this.solidity = this.getEnclosedArea() / this.getAreaConvexHull();
        if (this.solidity > 1.0) {
            this.solidity = 1.0;
        }
        return this.solidity;
    }

    public Polygon getConvexHull() {
        PolygonRoi roi = new PolygonRoi(this.outerContour, 2);
        Polygon hull = roi.getConvexHull();
        if (hull == null) {
            return this.getOuterContour();
        }
        return hull;
    }

    private double getAreaOfChainCode(int[] cc) {
        int B = 1;
        double A = 0.0;
        block10: for (int i = 0; i < cc.length; ++i) {
            switch (cc[i]) {
                case 0: {
                    A -= (double)B;
                    continue block10;
                }
                case 1: {
                    A += -((double)(++B) + 0.5);
                    continue block10;
                }
                case 2: {
                    ++B;
                    continue block10;
                }
                case 3: {
                    A += (double)(++B) + 0.5;
                    continue block10;
                }
                case 4: {
                    A += (double)B;
                    continue block10;
                }
                case 5: {
                    A += (double)(--B) - 0.5;
                    continue block10;
                }
                case 6: {
                    --B;
                    continue block10;
                }
                case 7: {
                    A += -((double)(--B) - 0.5);
                }
            }
        }
        double area = Math.abs(A);
        if (area == 0.0) {
            area = 1.0;
        }
        return area;
    }

    public double getEnclosedArea() {
        if (this.enclosedArea != -1.0) {
            return this.enclosedArea;
        }
        ImagePlus imp = Blob.generateBlobImage(this);
        this.enclosedArea = (double)imp.getStatistics().histogram[0] * this.cal.pixelHeight * this.cal.pixelWidth;
        return this.enclosedArea;
    }

    public double getAreaConvexHull() {
        if (this.areaConvexHull != -1.0) {
            return this.areaConvexHull;
        }
        Polygon polyPoints = this.getConvexHull();
        Blob helpblob = new Blob(polyPoints, -1);
        ImagePlus imp = Blob.generateBlobImage(helpblob);
        this.areaConvexHull = imp.getStatistics().getHistogram()[0];
        return this.areaConvexHull;
    }

    public double getCircularity() {
        if (this.circularity != -1.0) {
            return this.circularity;
        }
        double perimeter = this.getPerimeter();
        double size = this.getEnclosedArea();
        this.circularity = perimeter * perimeter / size;
        return this.circularity;
    }

    public double getThinnesRatio() {
        if (this.thinnesRatio != -1.0) {
            return this.thinnesRatio;
        }
        this.thinnesRatio = Math.PI * 4 / this.getCircularity();
        this.thinnesRatio = this.thinnesRatio > 1.0 ? 1.0 : this.thinnesRatio;
        return this.thinnesRatio;
    }

    public double getAreaToPerimeterRatio() {
        if (this.areaToPerimeterRatio != -1.0) {
            return this.areaToPerimeterRatio;
        }
        this.areaToPerimeterRatio = this.getEnclosedArea() / this.getPerimeter();
        return this.areaToPerimeterRatio;
    }

    public double getContourTemperature() {
        if (this.temperature != -1.0) {
            return this.temperature;
        }
        double chp = this.getPerimeterConvexHull();
        double peri = this.getPerimeter();
        this.temperature = 1.0 / (Math.log(2.0 * peri / Math.abs(peri - chp)) / Math.log(2.0));
        return this.temperature;
    }

    public double getFractalBoxDimension(int[] boxSizes) {
        if (this.fractalBoxDimension != -1.0) {
            return this.fractalBoxDimension;
        }
        FractalBoxCounterBlob boxcounter = new FractalBoxCounterBlob();
        boxcounter.setBoxSizes(boxSizes);
        double[] FDandGOF = boxcounter.getFractcalDimension(this);
        this.fractalBoxDimension = FDandGOF[0];
        this.fractalDimensionGoodness = FDandGOF[1];
        return this.fractalBoxDimension;
    }

    public double getDiamaterMaximumInscribedCircle() {
        ImagePlus help = Blob.generateBlobImage(this);
        ImageProcessor ipHelp = help.getProcessor();
        ipHelp.invert();
        EDM dm = new EDM();
        FloatProcessor fp = dm.makeFloatEDM(ipHelp, 0, false);
        MaximumFinder mf = new MaximumFinder();
        ByteProcessor bp = mf.findMaxima((ImageProcessor)fp, 0.5, -808080.0, 0, false, true);
        Polygon pl = mf.getMaxima((ImageProcessor)bp, 0.0, true);
        return (double)(fp.getf(pl.xpoints[0], pl.ypoints[0]) * 2.0f) * this.cal.getX(1.0);
    }

    public static ImagePlus generateBlobImage(Blob b) {
        Rectangle r = b.getOuterContour().getBounds();
        r.setBounds(r.x, r.y, (int)r.getWidth() + 1, (int)r.getHeight() + 1);
        ImagePlus help = NewImage.createByteImage((String)"", (int)(r.width + 2), (int)(r.height + 2), (int)1, (int)4);
        ImageProcessor ip = help.getProcessor();
        b.draw(ip, 1, -(r.x - 1), -(r.y - 1));
        help.setProcessor(ip);
        return help;
    }

    public double getFractalBoxDimension() {
        if (this.fractalBoxDimension != -1.0) {
            return this.fractalBoxDimension;
        }
        FractalBoxCounterBlob boxcounter = new FractalBoxCounterBlob();
        double[] FDandGOF = boxcounter.getFractcalDimension(this);
        this.fractalBoxDimension = FDandGOF[0];
        this.fractalDimensionGoodness = FDandGOF[1];
        return this.fractalBoxDimension;
    }

    public double getFractalDimensionGoodness() {
        return this.fractalDimensionGoodness;
    }

    public int getNumberofHoles() {
        return this.innerContours.size();
    }
}

