/*
 * Decompiled with CFR 0.152.
 */
package ij.blob;

import ij.IJ;
import ij.ImagePlus;
import ij.blob.Blob;
import ij.blob.ConnectedComponentLabeler;
import ij.gui.NewImage;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyBlobs
extends ArrayList<Blob> {
    private static final long serialVersionUID = 1L;
    private ImagePlus binaryImage = null;
    private ImagePlus labeledImage = null;
    private int BACKGROUND = 255;
    private int OBJECT = 0;

    public ManyBlobs() {
    }

    public ManyBlobs(ImagePlus binaryImage) {
        this.setImage(binaryImage);
    }

    public void setBackground(int val) {
        if (val > 1) {
            throw new IllegalArgumentException("Value must be 0 or 1 (black/white respectively)");
        }
        if (val == 0) {
            this.BACKGROUND = val;
            this.OBJECT = 255;
        } else {
            this.BACKGROUND = 255;
            this.OBJECT = 0;
        }
    }

    private void setImage(ImagePlus imp) {
        boolean wrongBitDepth;
        this.binaryImage = imp;
        ImageStatistics stats = imp.getStatistics();
        boolean notBinary = stats.histogram[0] + stats.histogram[255] != stats.pixelCount;
        boolean toManyChannels = imp.getNChannels() > 1;
        boolean bl = wrongBitDepth = imp.getBitDepth() != 8;
        if (notBinary | toManyChannels | wrongBitDepth) {
            throw new IllegalArgumentException("Wrong Image Format. IJ Blob only supports 8-bit, single-channel binary images");
        }
    }

    public void findConnectedComponents() {
        if (this.binaryImage == null) {
            throw new RuntimeException("Cannot run findConnectedComponents: No input image specified");
        }
        ConnectedComponentLabeler labeler = new ConnectedComponentLabeler(this, this.binaryImage, this.BACKGROUND, this.OBJECT);
        labeler.doConnectedComponents();
        this.labeledImage = labeler.getLabledImage();
    }

    public ImagePlus getLabeledImage() {
        if (this.labeledImage == null) {
            throw new RuntimeException("No input image was analysed for connected components");
        }
        return this.labeledImage;
    }

    public void setLabeledImage(ImagePlus p) {
        this.labeledImage = p;
    }

    public Blob getSpecificBlob(int x, int y) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((Blob)this.get(i)).getOuterContour().contains(x, y)) continue;
            return (Blob)this.get(i);
        }
        return null;
    }

    public Blob getSpecificBlob(Point p) {
        return this.getSpecificBlob(p.x, p.y);
    }

    public Blob getBlobByLabel(int id) {
        for (Blob b : this) {
            if (b.getLabel() != id) continue;
            return b;
        }
        return null;
    }

    public ManyBlobs filterBlobs(double lowerLimit, double upperLimit, String methodName, Object ... methodparams) {
        ManyBlobs result = null;
        try {
            result = this.filterBlobs2(lowerLimit, upperLimit, methodName, methodparams);
        }
        catch (NoSuchMethodException e) {
            IJ.error((String)("The method " + methodName + "does not exist"));
            e.printStackTrace();
            return null;
        }
        return result;
    }

    private ManyBlobs filterBlobs2(double lowerLimit, double upperLimit, String methodName, Object ... methodparams) throws NoSuchMethodException {
        ManyBlobs blobs = new ManyBlobs();
        blobs.setImage(this.binaryImage);
        Class[] classparams = new Class[]{};
        if (methodparams.length > 0) {
            classparams = new Class[methodparams.length];
            for (int i = 0; i < methodparams.length; ++i) {
                classparams[i] = methodparams[i].getClass();
            }
        }
        try {
            int i;
            boolean methodInBuild = true;
            boolean methodIsCustom = false;
            Method m = null;
            try {
                m = Blob.class.getMethod(methodName, classparams);
            }
            catch (NoSuchMethodException e) {
                methodInBuild = false;
            }
            int featureIndex = 0;
            int methodIndex = 0;
            if (!methodInBuild) {
                for (i = 0; i < Blob.customFeatures.size(); ++i) {
                    Method[] customMethods = Blob.customFeatures.get(i).getClass().getDeclaredMethods();
                    for (int j = 0; j < customMethods.length; ++j) {
                        if (customMethods[j].getName() != methodName) continue;
                        methodIsCustom = true;
                        methodIndex = j;
                        featureIndex = i;
                        m = customMethods[j];
                        break;
                    }
                    if (methodIsCustom) break;
                }
            }
            for (i = 0; i < this.size(); ++i) {
                if (((Blob)this.get((int)i)).getOuterContour().npoints < 4) continue;
                double value = 0.0;
                Object methodvalue = null;
                if (methodInBuild) {
                    methodvalue = m.invoke(this.get(i), methodparams);
                } else if (methodIsCustom) {
                    try {
                        methodvalue = ((Blob)this.get(i)).evaluateCustomFeature(methodName, methodparams);
                    }
                    catch (NoSuchMethodException e) {
                        throw new NoSuchMethodException("The method " + methodName + " was not found");
                    }
                } else {
                    throw new NoSuchMethodException("The method " + methodName + " was not found");
                }
                if (methodvalue instanceof Integer) {
                    int help = (Integer)methodvalue;
                    value = help;
                } else if (methodvalue instanceof Double) {
                    value = (Double)methodvalue;
                } else {
                    IJ.log((String)"Return type not supported");
                }
                boolean included = false;
                if (Double.isNaN(value)) {
                    included = true;
                } else if (Double.isInfinite(upperLimit)) {
                    boolean bl = included = value >= lowerLimit;
                    if (!included) {
                        included = Math.abs(lowerLimit - value) < 1.0E-4;
                    }
                } else {
                    boolean bl = included = value >= lowerLimit && value <= upperLimit;
                    if (!included) {
                        boolean bl2 = included = !included && Math.abs(lowerLimit - value) < 1.0E-4;
                    }
                    if (!included) {
                        boolean bl3 = included = !included && Math.abs(upperLimit - value) < 1.0E-4;
                    }
                }
                if (!included) continue;
                blobs.add(this.get(i));
            }
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("The method " + methodName + " was not found");
        }
        catch (SecurityException e) {
            IJ.log((String)e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            IJ.log((String)e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            IJ.log((String)e.getMessage());
            throw new IllegalArgumentException("Method " + methodName + " was called with wrong types of parameters");
        }
        catch (InvocationTargetException e) {
            IJ.log((String)e.getMessage());
            e.printStackTrace();
        }
        blobs.setLabeledImage(this.generateLabeledImageFromBlobs(blobs));
        return blobs;
    }

    private ImagePlus generateLabeledImageFromBlobs(ManyBlobs blobs) {
        ImagePlus labImg = NewImage.createRGBImage((String)"Labeled Image", (int)this.labeledImage.getWidth(), (int)this.labeledImage.getHeight(), (int)1, (int)4);
        ColorProcessor labledImageProc = (ColorProcessor)labImg.getProcessor();
        for (int i = 0; i < blobs.size(); ++i) {
            int helpcol = (int)((double)i / (double)blobs.size() * 1.6581375E7);
            ((Blob)blobs.get(i)).drawLabels((ImageProcessor)labledImageProc, new Color(helpcol));
        }
        return labImg;
    }

    public ManyBlobs filterBlobs(double[] limits, String methodName, Object ... methodparams) {
        ManyBlobs result = null;
        try {
            result = this.filterBlobs2(limits[0], limits[1], methodName, methodparams);
        }
        catch (NoSuchMethodException e) {
            IJ.error((String)("The method " + methodName + "does not exist"));
            e.printStackTrace();
            return null;
        }
        return result;
    }

    public ManyBlobs filterBlobs(double lowerlimit, String methodName, Object ... methodparams) {
        ManyBlobs result = null;
        try {
            result = this.filterBlobs2(lowerlimit, Double.POSITIVE_INFINITY, methodName, methodparams);
        }
        catch (NoSuchMethodException e) {
            IJ.error((String)("The method " + methodName + "does not exist"));
            e.printStackTrace();
            return null;
        }
        return result;
    }
}

