/*
 * Decompiled with CFR 0.152.
 */
package ij.blob;

import ij.IJ;
import ij.ImagePlus;
import ij.blob.Blob;
import ij.measure.CurveFitter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Rectangle;
import java.util.StringTokenizer;

class FractalBoxCounterBlob {
    static String sizes = "2,3,4,6,8,12,16,32,64";
    static boolean blackBackground;
    int[] boxSizes = this.s2ints(sizes);
    float[] boxCountSums;
    int maxBoxSize;
    int[] counts;
    Rectangle roi;
    int foreground;
    ImagePlus imp;

    public double[] getFractcalDimension(Blob blob) {
        ImagePlus blobImage = Blob.generateBlobImage(blob);
        ImageProcessor ip = blobImage.getProcessor();
        this.imp = new ImagePlus("abc", ip);
        this.boxCountSums = new float[this.boxSizes.length];
        for (int i = 0; i < this.boxSizes.length; ++i) {
            this.maxBoxSize = Math.max(this.maxBoxSize, this.boxSizes[i]);
        }
        this.counts = new int[this.maxBoxSize * this.maxBoxSize + 1];
        this.imp.deleteRoi();
        double[] FDandGOF = this.doBoxCounts(ip);
        return FDandGOF;
    }

    public int[] s2ints(String s) {
        StringTokenizer st = new StringTokenizer(s, ", \t");
        int nInts = st.countTokens();
        int[] ints = new int[nInts];
        for (int i = 0; i < nInts; ++i) {
            try {
                ints[i] = Integer.parseInt(st.nextToken());
                continue;
            }
            catch (NumberFormatException e) {
                IJ.log((String)("" + e));
                return null;
            }
        }
        return ints;
    }

    public void setBoxSizes(int[] sizes) {
        this.boxSizes = sizes;
    }

    public void setBoxSizes(String sizes) {
        this.boxSizes = this.s2ints(sizes);
    }

    boolean FindMargins(ImageProcessor ip) {
        if (IJ.debugMode) {
            IJ.log((String)"FindMargins");
        }
        int[] histogram = new int[256];
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int left = -1;
        do {
            if (++left >= width) {
                IJ.error((String)"No non-backround pixels found.");
                return false;
            }
            ip.setRoi(left, 0, 1, height);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        int top = -1;
        do {
            ip.setRoi(left, ++top, width - left, 1);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        int right = width + 1;
        do {
            ip.setRoi(--right - 1, top, 1, height - top);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        int bottom = height + 1;
        do {
            ip.setRoi(left, --bottom - 1, right - left, 1);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        this.roi = new Rectangle(left, top, right - left, bottom - top);
        return true;
    }

    int count(int size, ImageProcessor ip) {
        int[] histogram = new int[256];
        int x = this.roi.x;
        int y = this.roi.y;
        int w = size <= this.roi.width ? size : this.roi.width;
        int h = size <= this.roi.height ? size : this.roi.height;
        int right = this.roi.x + this.roi.width;
        int bottom = this.roi.y + this.roi.height;
        int maxCount = size * size;
        for (int i = 1; i <= maxCount; ++i) {
            this.counts[i] = 0;
        }
        boolean done = false;
        do {
            ip.setRoi(x, y, w, h);
            histogram = ip.getHistogram();
            int n = histogram[this.foreground];
            this.counts[n] = this.counts[n] + 1;
            if ((x += size) + size < right) continue;
            w = right - x;
            if (x < right) continue;
            w = size;
            x = this.roi.x;
            if ((y += size) + size >= bottom) {
                h = bottom - y;
            }
            boolean bl = done = y >= bottom;
        } while (!done);
        int boxSum = 0;
        for (int i = 1; i <= maxCount; ++i) {
            int nBoxes = this.counts[i];
            if (nBoxes == 0) continue;
            boxSum += nBoxes;
        }
        return boxSum;
    }

    double[] getSlopeAndGoodnessOfFit() {
        int n = this.boxSizes.length;
        float[] sizes = new float[this.boxSizes.length];
        for (int i = 0; i < n; ++i) {
            sizes[i] = (float)Math.log(this.boxSizes[i]);
        }
        CurveFitter cf = new CurveFitter(Tools.toDouble((float[])sizes), Tools.toDouble((float[])this.boxCountSums));
        cf.doFit(0);
        double[] p = cf.getParams();
        double[] slopeandrsquared = new double[]{-p[1], cf.getFitGoodness()};
        return slopeandrsquared;
    }

    double[] doBoxCounts(ImageProcessor ip) {
        if (!this.FindMargins(ip)) {
            return null;
        }
        for (int i = 0; i < this.boxSizes.length; ++i) {
            int boxSum = this.count(this.boxSizes[i], ip);
            this.boxCountSums[i] = (float)Math.log(boxSum);
        }
        double[] D = this.getSlopeAndGoodnessOfFit();
        this.imp.deleteRoi();
        return D;
    }
}

