/*
 * Decompiled with CFR 0.152.
 */
package ij.blob;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.blob.Blob;
import ij.blob.ManyBlobs;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.CanvasResizer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;

class ConnectedComponentLabeler {
    private ImagePlus imp;
    private ImageProcessor labledImage;
    private int NOLABEL = 0;
    private int labelCount = 1;
    private int BACKGROUND = 255;
    private int OBJECT = 0;
    private ManyBlobs allBlobs;
    private boolean removeBorder = false;
    private int offSetX = 0;
    private int offsetY = 0;
    int[] iterationorder = new int[]{5, 4, 3, 6, 2, 7, 0, 1};
    Point prevContourPoint;

    public ConnectedComponentLabeler(ManyBlobs allBlobs, ImagePlus imp, int BACKGROUND, int OBJECT) {
        this.allBlobs = allBlobs;
        this.imp = imp;
        this.BACKGROUND = BACKGROUND;
        this.OBJECT = OBJECT;
        this.addWhiteBorder(imp);
        this.labledImage = new ColorProcessor(this.imp.getWidth(), this.imp.getHeight());
    }

    public void doConnectedComponents() {
        ImageProcessor ip = this.imp.getProcessor();
        Calibration c = this.imp.getCalibration();
        ByteProcessor proc = (ByteProcessor)ip;
        byte[] pixels = (byte[])proc.getPixels();
        int w = proc.getWidth();
        Rectangle roi = ip.getRoi();
        for (int i = roi.y; i < roi.y + roi.height; ++i) {
            int offset = i * w;
            for (int j = roi.x; j < roi.x + roi.width; ++j) {
                int value = pixels[offset + j] & 0xFF;
                if (value != this.OBJECT) continue;
                if (this.isNewExternalContour(j, i, proc) && this.hasNoLabel(j, i)) {
                    this.labledImage.set(j, i, this.labelCount);
                    Polygon outerContour = this.traceContour(j, i, proc, this.labelCount, 1);
                    outerContour.translate(this.offSetX, this.offsetY);
                    this.allBlobs.add(new Blob(outerContour, this.labelCount, c));
                    ++this.labelCount;
                }
                if (this.isNewInternalContour(j, i, proc)) {
                    int label = this.labledImage.get(j, i);
                    if (this.hasNoLabel(j, i)) {
                        label = this.labledImage.get(j - 1, i);
                        this.labledImage.set(j, i, label);
                    }
                    try {
                        Polygon innerContour = this.traceContour(j, i, proc, label, 2);
                        innerContour.translate(this.offSetX, this.offsetY);
                        this.getBlobByLabel(label).addInnerContour(innerContour);
                    }
                    catch (Exception e) {
                        IJ.log((String)("x " + j + " y " + i + " label " + label));
                    }
                    continue;
                }
                if (!this.hasNoLabel(j, i)) continue;
                int precedinglabel = this.labledImage.get(j - 1, i);
                this.labledImage.set(j, i, precedinglabel);
            }
        }
        if (this.removeBorder) {
            this.removeBorder(this.imp);
        }
    }

    private void printImage(ImageProcessor img) {
        System.out.println("=================");
        ImageProcessor proc = img;
        for (int y = 0; y < proc.getHeight(); ++y) {
            String oneline = "";
            int numberSpaces = 0;
            for (int x = 0; x < proc.getWidth(); ++x) {
                String pixel = "" + proc.getPixel(x, y);
                for (int i = 0; i < numberSpaces; ++i) {
                    oneline = oneline + " ";
                }
                oneline = oneline + "" + pixel;
                numberSpaces = 8 - pixel.length() % 8;
            }
            System.out.println(oneline);
        }
    }

    public ImagePlus getLabledImage() {
        ImagePlus img = new ImagePlus("Labeled", this.labledImage);
        ColorProcessor proc = (ColorProcessor)img.getProcessor();
        int[] pixels = (int[])proc.getPixels();
        int w = proc.getWidth();
        int h = proc.getHeight();
        for (int i = 0; i < h; ++i) {
            int offset = i * w;
            for (int j = 0; j < w; ++j) {
                int value = pixels[offset + j];
                if (value != -1) continue;
                pixels[offset + j] = this.BACKGROUND;
            }
        }
        if (this.removeBorder) {
            this.removeBorder(img);
        }
        return img;
    }

    private Polygon traceContour(int x, int y, ByteProcessor proc, int label, int start) {
        Polygon contour = new Polygon();
        Point startPoint = new Point(x, y);
        contour.addPoint(x, y);
        Point nextPoint = this.nextPointOnContour(startPoint, proc, start);
        if (nextPoint.x == -1) {
            return contour;
        }
        Point T = new Point(nextPoint.x, nextPoint.y);
        boolean equalsStartpoint = false;
        do {
            contour.addPoint(nextPoint.x, nextPoint.y);
            this.labledImage.set(nextPoint.x, nextPoint.y, label);
            equalsStartpoint = nextPoint.equals(startPoint);
            nextPoint = this.nextPointOnContour(nextPoint, proc, -1);
        } while (!equalsStartpoint || !nextPoint.equals(T));
        return contour;
    }

    private final Point nextPointOnContour(Point startPoint, ByteProcessor proc, int start) {
        Point[] helpindexToPoint = new Point[8];
        int[] neighbors = new int[8];
        int x = startPoint.x;
        int y = startPoint.y;
        int I = 2;
        int k = I - 1;
        int u = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int window_x = x - k + i;
                int window_y = y - k + j;
                if (window_x == x && window_y == y) continue;
                neighbors[this.iterationorder[u]] = proc.get(window_x, window_y);
                helpindexToPoint[this.iterationorder[u]] = new Point(window_x, window_y);
                ++u;
            }
        }
        ArrayList<Point> indexToPoint = new ArrayList<Point>(Arrays.asList(helpindexToPoint));
        int NOSTARTPOINT = -1;
        boolean STARTEXTERNALCONTOUR = true;
        int STARTINTERNALCONTOUR = 2;
        switch (start) {
            case -1: {
                int prevContourPointIndex = indexToPoint.indexOf(this.prevContourPoint);
                start = (prevContourPointIndex + 2) % 8;
                break;
            }
            case 1: {
                start = 7;
                break;
            }
            case 2: {
                start = 3;
            }
        }
        int counter = start;
        int pos = -2;
        Point returnPoint = null;
        while (pos != start) {
            pos = counter % 8;
            if (neighbors[pos] == this.OBJECT) {
                this.prevContourPoint = startPoint;
                returnPoint = indexToPoint.get(pos);
                return returnPoint;
            }
            Point p = indexToPoint.get(pos);
            if (neighbors[pos] == this.BACKGROUND) {
                try {
                    this.labledImage.set(p.x, p.y, -1);
                }
                catch (Exception e) {
                    IJ.log((String)("x " + p.x + " y " + p.y));
                }
            }
            pos = ++counter % 8;
        }
        Point isIsolated = new Point(-1, -1);
        return isIsolated;
    }

    private boolean isNewExternalContour(int x, int y, ByteProcessor proc) {
        return this.isBackground(x, y - 1, proc);
    }

    private boolean hasNoLabel(int x, int y) {
        int label = this.labledImage.get(x, y);
        return label == this.NOLABEL;
    }

    private boolean isMarked(int x, int y) {
        return this.labledImage.get(x, y) == -1;
    }

    private boolean isBackground(int x, int y, ByteProcessor proc) {
        return proc.get(x, y) == this.BACKGROUND;
    }

    private boolean isNewInternalContour(int x, int y, ByteProcessor proc) {
        return this.isBackground(x, y + 1, proc) && !this.isMarked(x, y + 1);
    }

    private Blob getBlobByLabel(int label) {
        for (int i = 0; i < this.allBlobs.size(); ++i) {
            if (((Blob)this.allBlobs.get(i)).getLabel() != label) continue;
            return (Blob)this.allBlobs.get(i);
        }
        return null;
    }

    private void addWhiteBorder(ImagePlus img) {
        this.offSetX = 0;
        this.offsetY = 0;
        boolean hasWhiteBorder = true;
        ImageProcessor oldip = img.getProcessor();
        ByteProcessor oldproc = (ByteProcessor)oldip;
        byte[] pixels = (byte[])oldproc.getPixels();
        int w = oldproc.getWidth();
        for (int i = 0; i < oldproc.getHeight(); ++i) {
            int offset = i * w;
            if (i == 0 || i == oldproc.getHeight() - 1) {
                for (int j = 0; j < oldproc.getWidth(); ++j) {
                    int value = pixels[offset + j] & 0xFF;
                    if (value != this.OBJECT) continue;
                    hasWhiteBorder = false;
                }
            }
            int firstvalue = pixels[offset + 0] & 0xFF;
            int lastvalue = pixels[offset + oldproc.getWidth() - 1] & 0xFF;
            if (firstvalue == this.OBJECT || lastvalue == this.OBJECT) {
                hasWhiteBorder = false;
            }
            if (hasWhiteBorder) continue;
            i = oldproc.getHeight();
        }
        if (!hasWhiteBorder) {
            this.offSetX = -1;
            this.offsetY = -1;
            this.removeBorder = true;
            CanvasResizer resizer = new CanvasResizer();
            Color oldbg = Toolbar.getBackgroundColor();
            Prefs.set((String)"resizer.zero", (boolean)false);
            if (this.BACKGROUND == 255) {
                Color bgcolor = img.isInvertedLut() ? Color.BLACK : Color.WHITE;
                Toolbar.setBackgroundColor((Color)bgcolor);
            } else {
                Color bgcolor = img.isInvertedLut() ? Color.WHITE : Color.BLACK;
                Toolbar.setBackgroundColor((Color)bgcolor);
            }
            img.setProcessor(resizer.expandImage(img.getProcessor(), img.getWidth() + 2, img.getHeight() + 2, 1, 1));
            Toolbar.setBackgroundColor((Color)oldbg);
        } else {
            this.imp = img;
        }
    }

    public void removeBorder(ImagePlus img) {
        CanvasResizer resizer = new CanvasResizer();
        img.setProcessor(resizer.expandImage(img.getProcessor(), img.getWidth() - 2, img.getHeight() - 2, -1, -1));
    }
}

