/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cogitolearning.cogpar;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.cogitolearning.cogpar.FunctionExpressionNode;
import uk.co.cogitolearning.cogpar.ParserException;
import uk.co.cogitolearning.cogpar.Token;

public class Tokenizer {
    private static final Logger logger = LoggerFactory.getLogger(Tokenizer.class);
    private static Tokenizer expressionTokenizer = null;
    private final LinkedList<TokenInfo> tokenInfos = new LinkedList();
    private final LinkedList<Token> tokens = new LinkedList();

    public static Tokenizer getExpressionTokenizer() {
        if (expressionTokenizer == null) {
            expressionTokenizer = Tokenizer.createExpressionTokenizer();
        }
        return expressionTokenizer;
    }

    private static Tokenizer createExpressionTokenizer() {
        Tokenizer tokenizer = new Tokenizer();
        tokenizer.add("[+-]", 1);
        tokenizer.add("[*/]", 2);
        tokenizer.add("\\^", 3);
        String funcs = FunctionExpressionNode.getAllFunctions();
        tokenizer.add("(" + funcs + ")(?!\\w)", 4);
        tokenizer.add("\\(", 5);
        tokenizer.add("\\)", 6);
        tokenizer.add("(?:\\d+\\.?|\\.\\d)\\d*(?:[Ee][-+]?\\d+)?", 7);
        tokenizer.add("[a-zA-Z]\\w*", 8);
        return tokenizer;
    }

    public void add(String regex, int token) {
        this.tokenInfos.add(new TokenInfo(Pattern.compile("^(" + regex + ")"), token));
    }

    public void tokenize(String string) {
        logger.info("Tokenizing string \"{}\".", (Object)string);
        String trimmedString = string.trim();
        int totalLength = trimmedString.length();
        this.tokens.clear();
        while (!trimmedString.equals("")) {
            int remaining = trimmedString.length();
            boolean match = false;
            for (TokenInfo tokenInfo : this.tokenInfos) {
                Matcher tokenMatcher = tokenInfo.regex.matcher(trimmedString);
                if (!tokenMatcher.find()) continue;
                match = true;
                String token = tokenMatcher.group().trim();
                logger.trace("Matched token \"" + token + "\" to " + tokenInfo.regex.toString());
                trimmedString = tokenMatcher.replaceFirst("").trim();
                this.tokens.add(new Token(tokenInfo.token, token, totalLength - remaining));
                break;
            }
            if (match) continue;
            throw new ParserException("Unexpected character in input: " + trimmedString);
        }
    }

    public LinkedList<Token> getTokens() {
        return this.tokens;
    }

    private class TokenInfo {
        final Pattern regex;
        final int token;

        TokenInfo(Pattern regex, int token) {
            this.regex = regex;
            this.token = token;
        }
    }
}

