/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cogitolearning.cogpar;

import java.util.LinkedList;
import uk.co.cogitolearning.cogpar.AdditionExpressionNode;
import uk.co.cogitolearning.cogpar.ConstantExpressionNode;
import uk.co.cogitolearning.cogpar.ExponentiationExpressionNode;
import uk.co.cogitolearning.cogpar.ExpressionNode;
import uk.co.cogitolearning.cogpar.FunctionExpressionNode;
import uk.co.cogitolearning.cogpar.MultiplicationExpressionNode;
import uk.co.cogitolearning.cogpar.ParserException;
import uk.co.cogitolearning.cogpar.Token;
import uk.co.cogitolearning.cogpar.Tokenizer;
import uk.co.cogitolearning.cogpar.VariableExpressionNode;

public class Parser {
    private LinkedList<Token> tokens;
    private Token lookahead;

    public ExpressionNode parse(String expression) {
        Tokenizer tokenizer = Tokenizer.getExpressionTokenizer();
        tokenizer.tokenize(expression);
        LinkedList<Token> tokens = tokenizer.getTokens();
        return this.parse(tokens);
    }

    public ExpressionNode parse(LinkedList<Token> tokens) {
        this.tokens = (LinkedList)tokens.clone();
        this.lookahead = this.tokens.getFirst();
        ExpressionNode expr = this.expression();
        if (this.lookahead.token != 0) {
            throw new ParserException("Unexpected symbol %s found", this.lookahead);
        }
        return expr;
    }

    private ExpressionNode expression() {
        ExpressionNode expr = this.signedTerm();
        expr = this.sumOp(expr);
        return expr;
    }

    private ExpressionNode sumOp(ExpressionNode expr) {
        if (this.lookahead.token == 1) {
            AdditionExpressionNode sum = expr.getType() == 3 ? (AdditionExpressionNode)expr : new AdditionExpressionNode(expr, true);
            boolean positive = this.lookahead.sequence.equals("+");
            this.nextToken();
            ExpressionNode t = this.term();
            sum.add(t, positive);
            return this.sumOp(sum);
        }
        return expr;
    }

    private ExpressionNode signedTerm() {
        if (this.lookahead.token == 1) {
            boolean positive = this.lookahead.sequence.equals("+");
            this.nextToken();
            ExpressionNode t = this.term();
            if (positive) {
                return t;
            }
            return new AdditionExpressionNode(t, false);
        }
        return this.term();
    }

    private ExpressionNode term() {
        ExpressionNode f = this.factor();
        return this.termOp(f);
    }

    private ExpressionNode termOp(ExpressionNode expression) {
        if (this.lookahead.token == 2) {
            MultiplicationExpressionNode prod = expression.getType() == 4 ? (MultiplicationExpressionNode)expression : new MultiplicationExpressionNode(expression, true);
            boolean positive = this.lookahead.sequence.equals("*");
            this.nextToken();
            ExpressionNode f = this.signedFactor();
            prod.add(f, positive);
            return this.termOp(prod);
        }
        return expression;
    }

    private ExpressionNode signedFactor() {
        if (this.lookahead.token == 1) {
            boolean positive = this.lookahead.sequence.equals("+");
            this.nextToken();
            ExpressionNode t = this.factor();
            if (positive) {
                return t;
            }
            return new AdditionExpressionNode(t, false);
        }
        return this.factor();
    }

    private ExpressionNode factor() {
        ExpressionNode a = this.argument();
        return this.factorOp(a);
    }

    private ExpressionNode factorOp(ExpressionNode expr) {
        if (this.lookahead.token == 3) {
            this.nextToken();
            ExpressionNode exponent = this.signedFactor();
            return new ExponentiationExpressionNode(expr, exponent);
        }
        return expr;
    }

    private ExpressionNode argument() {
        if (this.lookahead.token == 4) {
            int function = FunctionExpressionNode.stringToFunction(this.lookahead.sequence);
            this.nextToken();
            ExpressionNode expr = this.argument();
            return new FunctionExpressionNode(function, expr);
        }
        if (this.lookahead.token == 5) {
            this.nextToken();
            ExpressionNode expr = this.expression();
            if (this.lookahead.token != 6) {
                throw new ParserException("Closing brackets expected", this.lookahead);
            }
            this.nextToken();
            return expr;
        }
        return this.value();
    }

    private ExpressionNode value() {
        if (this.lookahead.token == 7) {
            ConstantExpressionNode expr = new ConstantExpressionNode(this.lookahead.sequence);
            this.nextToken();
            return expr;
        }
        if (this.lookahead.token == 8) {
            VariableExpressionNode expr = new VariableExpressionNode(this.lookahead.sequence);
            this.nextToken();
            return expr;
        }
        if (this.lookahead.token == 0) {
            throw new ParserException("Unexpected end of input");
        }
        throw new ParserException("Unexpected symbol %s found", this.lookahead);
    }

    private void nextToken() {
        this.tokens.pop();
        this.lookahead = this.tokens.isEmpty() ? new Token(0, "", -1) : this.tokens.getFirst();
    }
}

