/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cogitolearning.cogpar;

import uk.co.cogitolearning.cogpar.EvaluationException;
import uk.co.cogitolearning.cogpar.ExpressionNode;
import uk.co.cogitolearning.cogpar.ExpressionNodeVisitor;
import uk.co.cogitolearning.cogpar.ParserException;

public class FunctionExpressionNode
implements ExpressionNode {
    private static final int SIN = 1;
    private static final int COS = 2;
    private static final int TAN = 3;
    private static final int ASIN = 4;
    private static final int ACOS = 5;
    private static final int ATAN = 6;
    private static final int SQRT = 7;
    private static final int EXP = 8;
    private static final int LN = 9;
    private static final int LOG = 10;
    private static final int LOG2 = 11;
    private static final int ABS = 12;
    private final int function;
    private final ExpressionNode argument;

    FunctionExpressionNode(int function, ExpressionNode argument) {
        this.function = function;
        this.argument = argument;
    }

    static int stringToFunction(String str) {
        if (str.equals("sin")) {
            return 1;
        }
        if (str.equals("cos")) {
            return 2;
        }
        if (str.equals("tan")) {
            return 3;
        }
        if (str.equals("asin")) {
            return 4;
        }
        if (str.equals("acos")) {
            return 5;
        }
        if (str.equals("atan")) {
            return 6;
        }
        if (str.equals("sqrt")) {
            return 7;
        }
        if (str.equals("exp")) {
            return 8;
        }
        if (str.equals("ln")) {
            return 9;
        }
        if (str.equals("log")) {
            return 10;
        }
        if (str.equals("log2")) {
            return 11;
        }
        if (str.equals("abs")) {
            return 12;
        }
        throw new ParserException("Unexpected Function " + str + " found");
    }

    static String getAllFunctions() {
        return "sin|cos|tan|asin|acos|atan|sqrt|exp|ln|log|log2|abs";
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public double getValue() {
        switch (this.function) {
            case 1: {
                return Math.sin(this.argument.getValue());
            }
            case 2: {
                return Math.cos(this.argument.getValue());
            }
            case 3: {
                return Math.tan(this.argument.getValue());
            }
            case 4: {
                return Math.asin(this.argument.getValue());
            }
            case 5: {
                return Math.acos(this.argument.getValue());
            }
            case 6: {
                return Math.atan(this.argument.getValue());
            }
            case 7: {
                return Math.sqrt(this.argument.getValue());
            }
            case 8: {
                return Math.exp(this.argument.getValue());
            }
            case 9: {
                return Math.log(this.argument.getValue());
            }
            case 10: {
                return Math.log(this.argument.getValue()) * 0.4342944819032518;
            }
            case 11: {
                return Math.log(this.argument.getValue()) * 1.4426950408889634;
            }
            case 12: {
                return Math.abs(this.argument.getValue());
            }
        }
        throw new EvaluationException("Invalid function id " + this.function + "!");
    }

    @Override
    public void accept(ExpressionNodeVisitor visitor) {
        visitor.visit(this);
        this.argument.accept(visitor);
    }
}

