/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml.converter;

import de.bioforscher.singa.features.units.UnitPrefixes;
import java.util.HashMap;
import java.util.Map;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Unit;
import org.sbml.jsbml.UnitDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.AbstractUnit;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.Units;

public class SBMLUnitConverter {
    private static final Logger logger = LoggerFactory.getLogger(SBMLUnitConverter.class);

    public Map<String, javax.measure.Unit<?>> convertUnits(ListOf<UnitDefinition> sbmlUnits) {
        HashMap units = new HashMap();
        for (UnitDefinition unitDefinition : sbmlUnits) {
            units.put(unitDefinition.getId(), this.convertUnit(unitDefinition));
        }
        return units;
    }

    public javax.measure.Unit<?> convertUnit(UnitDefinition unitDefinition) {
        ProductUnit resultUnit = new ProductUnit();
        for (Unit sbmlUnit : unitDefinition.getListOfUnits()) {
            javax.measure.Unit unitComponent = this.getUnitForKind(sbmlUnit.getKind());
            unitComponent = unitComponent.transform(UnitPrefixes.getUnitPrefixFromScale((int)sbmlUnit.getScale()).getCorrespondingConverter());
            unitComponent = unitComponent.pow((int)sbmlUnit.getExponent());
            unitComponent = unitComponent.multiply(sbmlUnit.getMultiplier());
            resultUnit = resultUnit.multiply(unitComponent);
        }
        logger.debug("Parsed unit {},", (Object)resultUnit.toString());
        return resultUnit;
    }

    private javax.measure.Unit<?> getUnitForKind(Unit.Kind kind) {
        switch (kind) {
            case AMPERE: {
                return Units.AMPERE;
            }
            case AVOGADRO: {
                return AbstractUnit.ONE.multiply(6.022140857E23);
            }
            case BECQUEREL: {
                return Units.BECQUEREL;
            }
            case CANDELA: {
                return Units.CANDELA;
            }
            case CELSIUS: {
                return Units.CELSIUS;
            }
            case COULOMB: {
                return Units.COULOMB;
            }
            case DIMENSIONLESS: {
                return AbstractUnit.ONE;
            }
            case FARAD: {
                return Units.FARAD;
            }
            case GRAM: {
                return Units.GRAM;
            }
            case GRAY: {
                return Units.GRAY;
            }
            case HENRY: {
                return Units.HENRY;
            }
            case HERTZ: {
                return Units.HERTZ;
            }
            case ITEM: {
                return AbstractUnit.ONE;
            }
            case JOULE: {
                return Units.JOULE;
            }
            case KATAL: {
                return Units.KATAL;
            }
            case KELVIN: {
                return Units.KELVIN;
            }
            case KILOGRAM: {
                return Units.KILOGRAM;
            }
            case LITER: {
                return Units.LITRE;
            }
            case LITRE: {
                return Units.LITRE;
            }
            case LUMEN: {
                return Units.LUMEN;
            }
            case LUX: {
                return Units.LUX;
            }
            case METER: {
                return Units.METRE;
            }
            case METRE: {
                return Units.METRE;
            }
            case MOLE: {
                return Units.MOLE;
            }
            case NEWTON: {
                return Units.NEWTON;
            }
            case OHM: {
                return Units.OHM;
            }
            case PASCAL: {
                return Units.PASCAL;
            }
            case RADIAN: {
                return Units.RADIAN;
            }
            case SECOND: {
                return Units.SECOND;
            }
            case SIEMENS: {
                return Units.SIEMENS;
            }
            case SIEVERT: {
                return Units.SIEVERT;
            }
            case STERADIAN: {
                return Units.STERADIAN;
            }
            case TESLA: {
                return Units.TESLA;
            }
            case VOLT: {
                return Units.VOLT;
            }
            case WATT: {
                return Units.WATT;
            }
            case WEBER: {
                return Units.WEBER;
            }
        }
        return AbstractUnit.ONE;
    }
}

