/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml.converter;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import de.bioforscher.singa.simulation.modules.reactions.implementations.DynamicKineticLaw;
import de.bioforscher.singa.simulation.modules.reactions.implementations.DynamicReaction;
import de.bioforscher.singa.simulation.modules.reactions.model.CatalyticReactant;
import de.bioforscher.singa.simulation.modules.reactions.model.ReactantRole;
import de.bioforscher.singa.simulation.modules.reactions.model.StoichiometricReactant;
import de.bioforscher.singa.simulation.parser.sbml.FunctionReference;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLKineticLawConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SpeciesReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SBMLReactionConverter {
    private static final Logger logger = LoggerFactory.getLogger(SBMLReactionConverter.class);
    private final Map<String, ChemicalEntity> entities;
    private final SBMLKineticLawConverter kineticLawConverter;
    private DynamicReaction currentReaction;

    public SBMLReactionConverter(Map<String, Unit<?>> units, Map<String, ChemicalEntity> entities, Map<String, FunctionReference> functions, Map<String, SimulationParameter<?>> globalParameters) {
        this.entities = entities;
        this.kineticLawConverter = new SBMLKineticLawConverter(units, functions, globalParameters);
    }

    public List<DynamicReaction> convertReactions(ListOf<Reaction> sbmlReactions) {
        ArrayList<DynamicReaction> reactions = new ArrayList<DynamicReaction>();
        for (Reaction reaction : sbmlReactions) {
            reactions.add(this.convertReaction(reaction));
        }
        return reactions;
    }

    public DynamicReaction convertReaction(Reaction reaction) {
        Simulation simulation = new Simulation();
        logger.debug("Parsing Reaction {} ...", (Object)reaction.getName());
        DynamicKineticLaw kineticLaw = this.kineticLawConverter.convertKineticLaw(reaction.getKineticLaw());
        this.currentReaction = new DynamicReaction(simulation, kineticLaw);
        this.assignSubstrates((ListOf<SpeciesReference>)reaction.getListOfReactants());
        this.assignProducts((ListOf<SpeciesReference>)reaction.getListOfProducts());
        this.assignModifiers((ListOf<ModifierSpeciesReference>)reaction.getListOfModifiers());
        logger.debug("Parsed Reaction:{}", (Object)this.currentReaction.getDisplayString());
        return this.currentReaction;
    }

    private void assignSubstrates(ListOf<SpeciesReference> substrates) {
        for (SpeciesReference reference : substrates) {
            logger.debug("Assigning Chemical Entity {} as substrate.", (Object)reference.getSpecies());
            String identifier = reference.getSpecies();
            this.currentReaction.getKineticLaw().referenceChemicalEntityToParameter(identifier, this.entities.get(identifier));
            this.currentReaction.getStoichiometricReactants().add(new StoichiometricReactant(this.entities.get(identifier), ReactantRole.DECREASING, reference.getStoichiometry()));
        }
    }

    private void assignProducts(ListOf<SpeciesReference> products) {
        for (SpeciesReference reference : products) {
            logger.debug("Assigning Chemical Entity {} as product.", (Object)reference.getSpecies());
            String identifier = reference.getSpecies();
            this.currentReaction.getKineticLaw().referenceChemicalEntityToParameter(identifier, this.entities.get(identifier));
            this.currentReaction.getStoichiometricReactants().add(new StoichiometricReactant(this.entities.get(identifier), ReactantRole.INCREASING, reference.getStoichiometry()));
        }
    }

    private void assignModifiers(ListOf<ModifierSpeciesReference> modifiers) {
        for (ModifierSpeciesReference reference : modifiers) {
            logger.debug("Assigning Chemical Entity {} as catalytic modifier.", (Object)reference.getSpecies());
            String identifier = reference.getSpecies();
            this.currentReaction.getKineticLaw().referenceChemicalEntityToParameter(identifier, this.entities.get(identifier));
            this.currentReaction.getCatalyticReactants().add(new CatalyticReactant(this.entities.get(identifier), ReactantRole.INCREASING));
        }
    }
}

