/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml.converter;

import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.AbstractUnit;
import tec.uom.se.quantity.Quantities;

public class SBMLParameterConverter {
    private static final Logger logger = LoggerFactory.getLogger(SBMLParameterConverter.class);
    private final Map<String, Unit<?>> units;

    public SBMLParameterConverter(Map<String, Unit<?>> units) {
        this.units = units;
    }

    public Map<String, SimulationParameter<?>> convertSimulationParameters(ListOf<Parameter> sbmlParameters) {
        HashMap parameters = new HashMap();
        for (Parameter parameter : sbmlParameters) {
            parameters.put(parameter.getId(), this.convertSimulationParameter(parameter));
        }
        return parameters;
    }

    public SimulationParameter<?> convertSimulationParameter(Parameter sbmlParameter) {
        return this.convertParameter(sbmlParameter.getId(), sbmlParameter.getValue(), sbmlParameter.getUnits());
    }

    public SimulationParameter<?> convertLocalParameter(LocalParameter sbmlLocalParameter) {
        return this.convertParameter(sbmlLocalParameter.getId(), sbmlLocalParameter.getValue(), sbmlLocalParameter.getUnits());
    }

    private SimulationParameter<?> convertParameter(String primaryIdentifier, double value, String unit) {
        Unit<?> parameterUnit = unit.equalsIgnoreCase("dimensionless") || unit.isEmpty() ? AbstractUnit.ONE : this.units.get(unit);
        SimulationParameter simulationParameter = new SimulationParameter(primaryIdentifier, Quantities.getQuantity((Number)value, parameterUnit));
        logger.debug("Set parameter {} to {}.", (Object)simulationParameter.getIdentifier(), simulationParameter.getQuantity());
        return simulationParameter;
    }
}

